/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.platform;

import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.platform.PluginMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContainer
implements BatchComponent,
ServerComponent {
    ComponentContainer parent;
    ComponentContainer child;
    MutablePicoContainer pico;
    PropertyDefinitions propertyDefinitions;

    public ComponentContainer() {
        this.parent = null;
        this.child = null;
        this.pico = ComponentContainer.createPicoContainer();
        this.propertyDefinitions = new PropertyDefinitions(new Object[0]);
        this.addSingleton(this.propertyDefinitions);
        this.addSingleton(this);
    }

    private ComponentContainer(ComponentContainer parent) {
        this.parent = parent;
        this.pico = parent.pico.makeChildContainer();
        this.parent.child = this;
        this.propertyDefinitions = parent.propertyDefinitions;
        this.addSingleton(this);
    }

    public final ComponentContainer startComponents() {
        this.pico.start();
        return this;
    }

    public final ComponentContainer stopComponents() {
        this.pico.stop();
        return this;
    }

    public final ComponentContainer addSingleton(Object component) {
        return this.addComponent(component, true);
    }

    public final ComponentContainer addComponent(Object component, boolean singleton) {
        this.pico.as(new Properties[]{singleton ? Characteristics.CACHE : Characteristics.NO_CACHE}).addComponent(ComponentContainer.getComponentKey(component), component, new Parameter[0]);
        this.declareExtension(null, component);
        return this;
    }

    public final ComponentContainer addExtension(@Nullable PluginMetadata plugin, Object extension) {
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(ComponentContainer.getComponentKey(extension), extension, new Parameter[0]);
        this.declareExtension(plugin, extension);
        return this;
    }

    public final void declareExtension(@Nullable PluginMetadata plugin, Object extension) {
        this.propertyDefinitions.addComponent(extension, plugin != null ? plugin.getName() : "");
    }

    public final ComponentContainer addPicoAdapter(ComponentAdapter adapter) {
        this.pico.addAdapter(adapter);
        return this;
    }

    public final <T> T getComponentByType(Class<T> tClass) {
        return (T)this.pico.getComponent(tClass);
    }

    public final Object getComponentByKey(Object key) {
        return this.pico.getComponent(key);
    }

    public final <T> List<T> getComponentsByType(Class<T> tClass) {
        return this.pico.getComponents(tClass);
    }

    public final ComponentContainer removeChild() {
        if (this.child != null) {
            this.pico.removeChildContainer((PicoContainer)this.child.pico);
            this.child = null;
        }
        return this;
    }

    public final ComponentContainer createChild() {
        return new ComponentContainer(this);
    }

    static MutablePicoContainer createPicoContainer() {
        ReflectionLifecycleStrategy lifecycleStrategy = new ReflectionLifecycleStrategy((ComponentMonitor)new NullComponentMonitor(), "start", "stop", "dispose");
        return new DefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)lifecycleStrategy, null);
    }

    static Object getComponentKey(Object component) {
        if (component instanceof Class) {
            return component;
        }
        return component.getClass().getCanonicalName() + "-" + component.toString();
    }

    public ComponentContainer getParent() {
        return this.parent;
    }

    public ComponentContainer getChild() {
        return this.child;
    }

    public MutablePicoContainer getPicoContainer() {
        return this.pico;
    }
}

