/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.model.MeasureModel;

@Entity
@Table(name="measure_data")
public class MeasureData
extends BaseIdentifiable {
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="measure_id")
    private MeasureModel measure;
    @Column(name="snapshot_id", updatable=true, nullable=true)
    private Integer snapshotId;
    @Column(name="data", updatable=true, nullable=true, length=0x9FFFFF6)
    private byte[] data;

    public MeasureData(MeasureModel measure) {
        this.measure = measure;
    }

    public MeasureData(MeasureModel measure, byte[] data) {
        this.measure = measure;
        this.data = data;
    }

    public MeasureData(MeasureModel measure, String dataString) {
        this.measure = measure;
        this.data = dataString.getBytes();
    }

    public MeasureData() {
    }

    public MeasureModel getMeasure() {
        return this.measure;
    }

    public void setMeasure(MeasureModel measure) {
        this.measure = measure;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getText() {
        if (this.data != null) {
            try {
                return new String(this.data, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Integer snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("snapshotId", (Object)this.snapshotId).append("mesasure", (Object)this.measure).append("data", this.data).toString();
    }
}

