/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyFieldDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinition {
    private final String key;
    private final String defaultValue;
    private final String name;
    private final PropertyType type;
    private final String[] options;
    private final String description;
    private final String category;
    private final boolean onProject;
    private final boolean onModule;
    private final boolean isGlobal;
    private final boolean multiValues;
    private final String propertySetKey;
    private final String deprecatedKey;
    private final List<PropertyFieldDefinition> fields;

    private PropertyDefinition(Property annotation) {
        this.key = annotation.key();
        this.name = annotation.name();
        this.defaultValue = annotation.defaultValue();
        this.description = annotation.description();
        this.isGlobal = annotation.global();
        this.onProject = annotation.project();
        this.onModule = annotation.module();
        this.category = annotation.category();
        this.type = PropertyDefinition.fixType(annotation.key(), annotation.type());
        this.options = annotation.options();
        this.multiValues = annotation.multiValues();
        this.propertySetKey = annotation.propertySetKey();
        this.fields = ImmutableList.copyOf(PropertyFieldDefinition.create(annotation.fields()));
        this.deprecatedKey = annotation.deprecatedKey();
    }

    private PropertyDefinition(String key, PropertyType type, String[] options) {
        this.key = key;
        this.name = null;
        this.defaultValue = null;
        this.description = null;
        this.isGlobal = true;
        this.onProject = false;
        this.onModule = false;
        this.category = null;
        this.type = type;
        this.options = options;
        this.multiValues = false;
        this.propertySetKey = null;
        this.fields = null;
        this.deprecatedKey = null;
    }

    private static PropertyType fixType(String key, PropertyType type) {
        if (type == PropertyType.STRING) {
            if (StringUtils.endsWith((String)key, (String)".password.secured")) {
                return PropertyType.PASSWORD;
            }
            if (StringUtils.endsWith((String)key, (String)".license.secured")) {
                return PropertyType.LICENSE;
            }
        }
        return type;
    }

    public static PropertyDefinition create(Property annotation) {
        return new PropertyDefinition(annotation);
    }

    public static PropertyDefinition create(String key, PropertyType type, String[] options) {
        return new PropertyDefinition(key, type, options);
    }

    public Result validate(@Nullable String value) {
        return PropertyDefinition.validate(this.type, value, this.options);
    }

    static Result validate(PropertyType type, @Nullable String value, String[] options) {
        if (StringUtils.isNotBlank((String)value)) {
            if (type == PropertyType.BOOLEAN) {
                if (!StringUtils.equalsIgnoreCase((String)value, (String)"true") && !StringUtils.equalsIgnoreCase((String)value, (String)"false")) {
                    return Result.newError("notBoolean");
                }
            } else if (type == PropertyType.INTEGER) {
                if (!NumberUtils.isDigits((String)value)) {
                    return Result.newError("notInteger");
                }
            } else if (type == PropertyType.FLOAT) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    return Result.newError("notFloat");
                }
            } else if (type == PropertyType.SINGLE_SELECT_LIST && !ArrayUtils.contains((Object[])options, (Object)value)) {
                return Result.newError("notInOptions");
            }
        }
        return Result.SUCCESS;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    public String[] getOptions() {
        return (String[])this.options.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isOnProject() {
        return this.onProject;
    }

    public boolean isOnModule() {
        return this.onModule;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isMultiValues() {
        return this.multiValues;
    }

    public String getPropertySetKey() {
        return this.propertySetKey;
    }

    public List<PropertyFieldDefinition> getFields() {
        return this.fields;
    }

    public String getDeprecatedKey() {
        return this.deprecatedKey;
    }

    public static final class Result {
        private static final Result SUCCESS = new Result(null);
        private String errorKey = null;

        private static Result newError(String key) {
            return new Result(key);
        }

        @Nullable
        private Result(@Nullable String errorKey) {
            this.errorKey = errorKey;
        }

        public boolean isValid() {
            return StringUtils.isBlank((String)this.errorKey);
        }

        @Nullable
        public String getErrorKey() {
            return this.errorKey;
        }
    }
}

