/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks.templates;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sonar.api.checks.templates.CheckTemplate;
import org.sonar.api.checks.templates.CheckTemplateProperty;
import org.sonar.api.checks.templates.DefaultCheckTemplate;
import org.sonar.api.checks.templates.DefaultCheckTemplateProperty;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.StandardRulesXmlParser;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlCheckTemplateFactory {
    public List<CheckTemplate> parseXml(String xml) {
        InputStream input = null;
        try {
            input = IOUtils.toInputStream((String)xml, (String)"UTF-8");
            List<CheckTemplate> list = this.parse(input);
            return list;
        }
        catch (IOException e) {
            throw new SonarException("Can't parse xml file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public List<CheckTemplate> parse(Reader reader) {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        List<Rule> rules = parser.parse(reader);
        return this.toCheckTemplates(rules);
    }

    public List<CheckTemplate> parse(InputStream input) {
        StandardRulesXmlParser parser = new StandardRulesXmlParser();
        List<Rule> rules = parser.parse(input);
        return this.toCheckTemplates(rules);
    }

    private List<CheckTemplate> toCheckTemplates(List<Rule> rules) {
        ArrayList<CheckTemplate> templates = new ArrayList<CheckTemplate>();
        if (rules != null) {
            for (Rule rule : rules) {
                DefaultCheckTemplate template = new DefaultCheckTemplate(rule.getKey());
                templates.add(template);
                template.setConfigKey(rule.getConfigKey());
                template.setDescription(rule.getDescription());
                template.setPriority(rule.getSeverity().toCheckPriority());
                template.setTitle(rule.getName());
                if (rule.getParams() == null) continue;
                for (RuleParam param : rule.getParams()) {
                    template.addProperty(this.toProperty(param));
                }
            }
        }
        return templates;
    }

    private CheckTemplateProperty toProperty(RuleParam param) {
        DefaultCheckTemplateProperty property = new DefaultCheckTemplateProperty();
        property.setKey(param.getKey());
        property.setTitle(param.getKey());
        property.setDescription(param.getDescription());
        return property;
    }
}

