/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.ResourcePersister;

public final class MeasurePersister {
    private boolean delayedMode = false;
    private SetMultimap<Resource, Measure> unsavedMeasuresByResource = LinkedHashMultimap.create();
    private DatabaseSession session;
    private ResourcePersister resourcePersister;
    private RuleFinder ruleFinder;

    public MeasurePersister(DatabaseSession session, ResourcePersister resourcePersister, RuleFinder ruleFinder) {
        this.session = session;
        this.resourcePersister = resourcePersister;
        this.ruleFinder = ruleFinder;
    }

    public void setDelayedMode(boolean delayedMode) {
        this.delayedMode = delayedMode;
    }

    public void saveMeasure(Resource resource, Measure measure) {
        boolean saveLater;
        boolean bl = saveLater = measure.getPersistenceMode().useMemory() && this.delayedMode;
        if (saveLater) {
            this.unsavedMeasuresByResource.put((Object)resource, (Object)measure);
        } else {
            Snapshot snapshot = this.resourcePersister.getSnapshotOrFail(resource);
            if (measure.getId() != null) {
                MeasureModel model = (MeasureModel)this.session.reattach(MeasureModel.class, (Object)measure.getId());
                model = this.mergeModel(measure, model);
                model.save(this.session);
            } else if (MeasurePersister.shouldPersistMeasure(resource, measure)) {
                MeasureModel model = this.createModel(measure);
                model.setSnapshotId(snapshot.getId());
                model.save(this.session);
                measure.setId(model.getId());
            }
        }
    }

    static boolean shouldPersistMeasure(Resource resource, Measure measure) {
        Metric metric = measure.getMetric();
        return measure.getPersistenceMode().useDatabase() && (!ResourceUtils.isEntity((Resource)resource) || !MeasurePersister.isBestValueMeasure(measure, metric));
    }

    static boolean isBestValueMeasure(Measure measure, Metric metric) {
        return !(measure.getId() != null || metric.isOptimizedBestValue() != Boolean.TRUE || metric.getBestValue() == null || measure.getValue() != null && NumberUtils.compare((double)metric.getBestValue(), (double)measure.getValue()) != 0 || measure.getAlertStatus() != null || measure.getDescription() != null || measure.getTendency() != null || measure.getUrl() != null || measure.getData() != null || measure.getVariation1() != null && NumberUtils.compare((double)measure.getVariation1(), (double)0.0) != 0 || measure.getVariation2() != null && NumberUtils.compare((double)measure.getVariation2(), (double)0.0) != 0 || measure.getVariation3() != null && NumberUtils.compare((double)measure.getVariation3(), (double)0.0) != 0 || measure.getVariation4() != null && NumberUtils.compare((double)measure.getVariation4(), (double)0.0) != 0 || measure.getVariation5() != null && NumberUtils.compare((double)measure.getVariation5(), (double)0.0) != 0);
    }

    public void dump() {
        LoggerFactory.getLogger(this.getClass()).debug("{} measures to dump", (Object)this.unsavedMeasuresByResource.size());
        Map map = this.unsavedMeasuresByResource.asMap();
        for (Map.Entry entry : map.entrySet()) {
            Resource resource = (Resource)entry.getKey();
            Snapshot snapshot = this.resourcePersister.getSnapshot((Resource)entry.getKey());
            for (Measure measure : (Collection)entry.getValue()) {
                if (!MeasurePersister.shouldPersistMeasure(resource, measure)) continue;
                MeasureModel model = this.createModel(measure);
                model.setSnapshotId(snapshot.getId());
                model.save(this.session);
            }
        }
        this.session.commit();
        this.unsavedMeasuresByResource.clear();
    }

    MeasureModel createModel(Measure measure) {
        return this.mergeModel(measure, new MeasureModel());
    }

    MeasureModel mergeModel(Measure measure, MeasureModel merge) {
        merge.setMetricId(measure.getMetric().getId());
        merge.setDescription(measure.getDescription());
        merge.setData(measure.getData());
        merge.setAlertStatus(measure.getAlertStatus());
        merge.setAlertText(measure.getAlertText());
        merge.setTendency(measure.getTendency());
        merge.setVariationValue1(measure.getVariation1());
        merge.setVariationValue2(measure.getVariation2());
        merge.setVariationValue3(measure.getVariation3());
        merge.setVariationValue4(measure.getVariation4());
        merge.setVariationValue5(measure.getVariation5());
        merge.setUrl(measure.getUrl());
        merge.setCharacteristic(measure.getCharacteristic());
        if (measure.getValue() != null) {
            merge.setValue(Double.valueOf(measure.getValue()));
        } else {
            merge.setValue(null);
        }
        if (measure instanceof RuleMeasure) {
            RuleMeasure ruleMeasure = (RuleMeasure)measure;
            merge.setRulePriority(ruleMeasure.getRulePriority());
            if (ruleMeasure.getRule() != null) {
                Rule ruleWithId = this.ruleFinder.findByKey(ruleMeasure.getRule().getRepositoryKey(), ruleMeasure.getRule().getKey());
                if (ruleWithId != null) {
                    merge.setRuleId(ruleWithId.getId());
                } else {
                    throw new SonarException("Can not save a measure with unknown rule " + ruleMeasure);
                }
            }
        }
        return merge;
    }
}

