/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Decorator;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.batch.FormulaDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecoratorsSelector {
    private BatchExtensionDictionnary dictionnary;

    public DecoratorsSelector(BatchExtensionDictionnary dictionnary) {
        this.dictionnary = dictionnary;
    }

    public Collection<Decorator> select(Project project) {
        ArrayList<Decorator> decorators = new ArrayList<Decorator>(this.dictionnary.select(Decorator.class, project, false));
        SetMultimap<Metric, Decorator> decoratorsByGeneratedMetric = this.getDecoratorsByMetric(decorators);
        for (Metric metric : this.dictionnary.select(Metric.class)) {
            if (metric.getFormula() == null) continue;
            decorators.add(new FormulaDecorator(metric, decoratorsByGeneratedMetric.get((Object)metric)));
        }
        return this.dictionnary.sort(decorators);
    }

    private SetMultimap<Metric, Decorator> getDecoratorsByMetric(Collection<Decorator> pluginDecorators) {
        HashMultimap decoratorsByGeneratedMetric = HashMultimap.create();
        for (Decorator decorator : pluginDecorators) {
            List dependents = this.dictionnary.getDependents((Object)decorator);
            for (Object dependent : dependents) {
                if (!(dependent instanceof Metric)) continue;
                decoratorsByGeneratedMetric.put((Object)((Metric)dependent), (Object)decorator);
            }
        }
        return decoratorsByGeneratedMetric;
    }
}

