/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Named;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.JarHolder;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="jar")
public class JarResourceLoader
extends AbstractResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarResourceLoader.class);
    public static final String ID = "jar";
    private final Map<String, String> entryDirectory = new LinkedHashMap<String, String>(559);
    private final Map<String, JarHolder> jarFiles = new LinkedHashMap<String, JarHolder>(89);

    private void loadJar(String path) {
        LOGGER.debug("JarResourceLoader : trying to load '{}'", (Object)path);
        if (path == null) {
            LOGGER.error("JarResourceLoader : can not load JAR - JAR path is null");
            return;
        }
        if (!path.startsWith("jar:")) {
            LOGGER.error("JarResourceLoader : JAR path must start with jar: -> see java.net.JarURLConnection for information");
            return;
        }
        if (!path.endsWith("!/")) {
            path = path + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(path);
        this.addEntries(temp.getEntries());
        this.jarFiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarFiles.containsKey(path)) {
            JarHolder theJar = this.jarFiles.get(path);
            theJar.close();
        }
    }

    private void addEntries(Map<String, String> entries) {
        this.entryDirectory.putAll(entries);
    }

    @Override
    public PlexusResource getResource(String source) throws ResourceNotFoundException {
        String jarurl;
        JarHolder holder;
        if (source == null || source.length() == 0) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        if (source.startsWith("/")) {
            source = source.substring(1);
        }
        if (this.entryDirectory.containsKey(source) && (holder = this.jarFiles.get(jarurl = this.entryDirectory.get(source))) != null) {
            return holder.getPlexusResource(source);
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + source);
    }

    @Override
    public void addSearchPath(String path) {
        if (!this.paths.contains(path)) {
            this.loadJar(path);
            this.paths.add(path);
        }
    }
}

