/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;

public class PlexusIoURLResource
extends AbstractPlexusIoResource {
    private URL base;

    protected PlexusIoURLResource(URL base, String name, long lastModified, long size, boolean isFile, boolean isDirectory, boolean isExisting) {
        super(name, lastModified, size, isFile, isDirectory, isExisting);
        this.base = base;
    }

    public InputStream getContents() throws IOException {
        URL url = this.getURL();
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new IOException(this.getDescriptionForError(url), e);
        }
    }

    String getDescriptionForError(URL url) {
        return url != null ? url.toExternalForm() : "url=null";
    }

    public URL getURL() throws IOException {
        String spec = this.getName();
        if (spec.startsWith("/")) {
            spec = "./" + spec;
        }
        return new URL(this.base, spec);
    }
}

