/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiverAttributeUtils;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

public abstract class Compressor
extends AbstractLogEnabled {
    private File destFile;
    private PlexusIoResource source;

    public void setDestFile(File compressFile) {
        this.destFile = compressFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setSource(PlexusIoResource source) {
        this.source = source;
    }

    public PlexusIoResource getSource() {
        return this.source;
    }

    public void setSourceFile(File srcFile) {
        PlexusIoFileResource res = new PlexusIoFileResource(srcFile, ArchiverAttributeUtils.getFileAttributes(srcFile));
        this.setSource((PlexusIoResource)res);
    }

    public File getSourceFile() {
        PlexusIoResource res = this.getSource();
        if (res instanceof PlexusIoFileResource) {
            return ((PlexusIoFileResource)res).getFile();
        }
        return null;
    }

    private void validate() throws ArchiverException {
        if (this.destFile == null) {
            throw new ArchiverException("Destination file attribute is required");
        }
        if (this.destFile.isDirectory()) {
            throw new ArchiverException("Destination file attribute must not represent a directory!");
        }
        if (this.source == null) {
            throw new ArchiverException("Source file attribute is required");
        }
        if (this.source.isDirectory()) {
            throw new ArchiverException("Source file attribute must not represent a directory!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ArchiverException {
        this.validate();
        try {
            if (!this.source.isExisting()) {
            } else {
                long l = this.source.getLastModified();
                if (l == 0L || this.destFile.lastModified() == 0L || this.destFile.lastModified() < l) {
                    this.compress();
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void compressFile(InputStream in, OutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compressFile(File file, OutputStream zOut) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.compressFile(in, zOut);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compress(PlexusIoResource resource, OutputStream zOut) throws IOException {
        InputStream in = resource.getContents();
        try {
            this.compressFile(in, zOut);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public abstract void compress() throws ArchiverException;

    public abstract void close();
}

