/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public class MavenProjectUtils {
    public static Set<Dependency> extractPluginDependenciesFromPluginsInPluginManagement(MavenProject project) {
        return Optional.ofNullable(project.getBuild()).map(PluginConfiguration::getPluginManagement).map(PluginContainer::getPlugins).orElse(Collections.emptyList()).stream().filter(plugin -> plugin.getDependencies() != null).flatMap(plugin -> plugin.getDependencies().stream()).collect(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE), Set::add, Set::addAll);
    }

    public static Set<Dependency> extractDependenciesFromPlugins(MavenProject project) {
        return project.getBuildPlugins().stream().filter(plugin -> plugin.getDependencies() != null).flatMap(plugin -> plugin.getDependencies().stream()).collect(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE), Set::add, Set::addAll);
    }

    public static Set<Dependency> extractDependenciesFromDependencyManagement(MavenProject project, boolean processDependencyManagementTransitive, Log log) throws VersionRetrievalException {
        DependencyManagement projectDependencyManagement;
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        DependencyManagement dependencyManagement2 = projectDependencyManagement = processDependencyManagementTransitive ? project.getDependencyManagement() : project.getOriginalModel().getDependencyManagement();
        if (projectDependencyManagement != null) {
            List dependenciesFromPom = projectDependencyManagement.getDependencies();
            for (Dependency dependency : dependenciesFromPom) {
                log.debug((CharSequence)("dependency from pom: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getScope()));
                if (dependency.getVersion() == null) {
                    if (project.hasParent()) {
                        log.debug((CharSequence)"Reading parent dependencyManagement information");
                        DependencyManagement parentProjectDependencyManagement = processDependencyManagementTransitive ? project.getParent().getDependencyManagement() : project.getParent().getOriginalModel().getDependencyManagement();
                        if (parentProjectDependencyManagement == null) continue;
                        List parentDeps = parentProjectDependencyManagement.getDependencies();
                        for (Dependency parentDep : parentDeps) {
                            if (!dependency.getGroupId().equals(parentDep.getGroupId()) || !dependency.getArtifactId().equals(parentDep.getArtifactId()) || !dependency.getType().equals(parentDep.getType())) continue;
                            dependencyManagement.add(parentDep);
                        }
                        continue;
                    }
                    String message = "We can't getModel the version for the dependency " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " because there does not exist a parent.";
                    log.error((CharSequence)message);
                    throw new VersionRetrievalException(message);
                }
                dependency = MavenProjectUtils.interpolateVersion(dependency, project);
                dependencyManagement.add(dependency);
            }
        }
        return dependencyManagement;
    }

    public static Dependency interpolateVersion(Dependency dependency, MavenProject project) {
        String resolvedVersion;
        if (dependency.getVersion().startsWith("${") && (resolvedVersion = project.getOriginalModel().getProperties().getProperty(dependency.getVersion().substring(2, dependency.getVersion().length() - 1))) != null && !resolvedVersion.isEmpty()) {
            dependency.setVersion(resolvedVersion);
        }
        return dependency;
    }
}

