/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.VersionDetails;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public abstract class UpdateScope
implements Comparable,
Serializable {
    public static final UpdateScope SUBINCREMENTAL = new UpdateScope("SUBINCREMENTAL", 0){

        @Override
        public ArtifactVersion getOldestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getOldestVersion(currentVersion, versionComparator.incrementSegment(currentVersion, 2), includeSnapshots, false, false);
        }

        @Override
        public ArtifactVersion getNewestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getNewestVersion(currentVersion, versionComparator.incrementSegment(currentVersion, 2), includeSnapshots, false, false);
        }

        @Override
        public ArtifactVersion[] getAllUpdates(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getVersions(currentVersion, versionComparator.incrementSegment(currentVersion, 2), includeSnapshots, false, false);
        }
    };
    public static final UpdateScope INCREMENTAL = new UpdateScope("INCREMENTAL", 1){

        @Override
        public ArtifactVersion getOldestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getOldestVersion(versionComparator.incrementSegment(currentVersion, 2), versionComparator.incrementSegment(currentVersion, 1), includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion getNewestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getNewestVersion(versionComparator.incrementSegment(currentVersion, 2), versionComparator.incrementSegment(currentVersion, 1), includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion[] getAllUpdates(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 3 ? null : versionDetails.getVersions(versionComparator.incrementSegment(currentVersion, 2), versionComparator.incrementSegment(currentVersion, 1), includeSnapshots, true, false);
        }
    };
    public static final UpdateScope MINOR = new UpdateScope("MINOR", 2){

        @Override
        public ArtifactVersion getOldestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 2 ? null : versionDetails.getOldestVersion(versionComparator.incrementSegment(currentVersion, 1), versionComparator.incrementSegment(currentVersion, 0), includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion getNewestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 2 ? null : versionDetails.getNewestVersion(versionComparator.incrementSegment(currentVersion, 1), versionComparator.incrementSegment(currentVersion, 0), includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion[] getAllUpdates(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 2 ? null : versionDetails.getVersions(versionComparator.incrementSegment(currentVersion, 1), versionComparator.incrementSegment(currentVersion, 0), includeSnapshots, true, false);
        }
    };
    public static final UpdateScope MAJOR = new UpdateScope("MAJOR", 3){

        @Override
        public ArtifactVersion getOldestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 1 ? null : versionDetails.getOldestVersion(versionComparator.incrementSegment(currentVersion, 0), null, includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion getNewestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 1 ? null : versionDetails.getNewestVersion(versionComparator.incrementSegment(currentVersion, 0), null, includeSnapshots, true, false);
        }

        @Override
        public ArtifactVersion[] getAllUpdates(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            VersionComparator versionComparator = versionDetails.getVersionComparator();
            return versionComparator.getSegmentCount(currentVersion) < 1 ? null : versionDetails.getVersions(versionComparator.incrementSegment(currentVersion, 0), null, includeSnapshots, true, false);
        }
    };
    public static final UpdateScope ANY = new UpdateScope("ANY", 4){

        @Override
        public ArtifactVersion getOldestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            return versionDetails.getOldestVersion(currentVersion, null, includeSnapshots, false, false);
        }

        @Override
        public ArtifactVersion getNewestUpdate(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            return versionDetails.getNewestVersion(currentVersion, null, includeSnapshots, false, false);
        }

        @Override
        public ArtifactVersion[] getAllUpdates(VersionDetails versionDetails, ArtifactVersion currentVersion, boolean includeSnapshots) {
            return versionDetails.getVersions(currentVersion, null, includeSnapshots, false, false);
        }
    };
    private final String name;
    private final int ordinal;
    private static final Map levelConstants;

    public abstract ArtifactVersion getOldestUpdate(VersionDetails var1, ArtifactVersion var2, boolean var3);

    public abstract ArtifactVersion getNewestUpdate(VersionDetails var1, ArtifactVersion var2, boolean var3);

    public abstract ArtifactVersion[] getAllUpdates(VersionDetails var1, ArtifactVersion var2, boolean var3);

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    private UpdateScope(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final int compareTo(Object o) {
        UpdateScope other = (UpdateScope)o;
        UpdateScope self = this;
        if (self.getClass() != other.getClass()) {
            throw new ClassCastException();
        }
        return self.ordinal - other.ordinal;
    }

    public final Class getDeclaringClass() {
        return this.getClass();
    }

    public static UpdateScope valueOf(String name) {
        UpdateScope result = (UpdateScope)levelConstants.get(name);
        if (result != null) {
            return result;
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        throw new IllegalArgumentException("No enum const " + UpdateScope.class.getName() + "." + name);
    }

    public static UpdateScope[] values() {
        return new UpdateScope[]{SUBINCREMENTAL, INCREMENTAL, MINOR, MAJOR, ANY};
    }

    public static UpdateScope classifyUpdate(VersionComparator comparator, ArtifactVersion from, ArtifactVersion to) {
        if (comparator.compare(from, to) >= 0) {
            throw new IllegalArgumentException("From version must be less than to version");
        }
        int matchSegment = 0;
        for (int segment = Math.min(comparator.getSegmentCount(from), comparator.getSegmentCount(to)); segment > 0; --segment) {
            ArtifactVersion f = comparator.incrementSegment(from, segment - 1);
            f = comparator.incrementSegment(f, segment - 1);
            ArtifactVersion t = comparator.incrementSegment(to, segment - 1);
            if (!f.toString().equals(t.toString())) continue;
            matchSegment = segment;
            break;
        }
        switch (matchSegment) {
            case 0: {
                return MAJOR;
            }
            case 1: {
                return MINOR;
            }
            case 2: {
                return INCREMENTAL;
            }
        }
        return SUBINCREMENTAL;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.ordinal == UpdateScope.SUBINCREMENTAL.ordinal) {
            return SUBINCREMENTAL;
        }
        if (this.ordinal == UpdateScope.INCREMENTAL.ordinal) {
            return INCREMENTAL;
        }
        if (this.ordinal == UpdateScope.MINOR.ordinal) {
            return MINOR;
        }
        if (this.ordinal == UpdateScope.MAJOR.ordinal) {
            return MAJOR;
        }
        if (this.ordinal == UpdateScope.ANY.ordinal) {
            return ANY;
        }
        throw new StreamCorruptedException();
    }

    static {
        HashMap<String, UpdateScope> map = new HashMap<String, UpdateScope>(5);
        map.put(SUBINCREMENTAL.name(), SUBINCREMENTAL);
        map.put(INCREMENTAL.name(), INCREMENTAL);
        map.put(MINOR.name(), MINOR);
        map.put(MAJOR.name(), MAJOR);
        map.put(ANY.name(), ANY);
        levelConstants = map;
    }
}

