/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Ranlib;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.manager.RanlibManager;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;

public class NativeRanlibMojo
extends AbstractNativeMojo {
    protected File ranlibOutputDirectory;
    private String provider;
    private RanlibManager manager;

    public void execute() throws MojoExecutionException {
        try {
            String finalName = this.project.getBuild().getFinalName();
            String fileExt = this.project.getArtifact().getArtifactHandler().getExtension();
            File outputFile = new File(this.ranlibOutputDirectory.getAbsolutePath() + "/" + finalName + "." + fileExt);
            Ranlib ranlib = this.getRanlib();
            ranlib.run(outputFile);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error executing ranlib.", (Exception)((Object)e));
        }
    }

    private Ranlib getRanlib() throws MojoExecutionException {
        Ranlib ranlib;
        try {
            ranlib = this.manager.getRanlib(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return ranlib;
    }
}

