/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.configuration;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.hibernate3.configuration.AbstractComponentConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.Ejb3Configuration;

public class JPAComponentConfiguration
extends AbstractComponentConfiguration {
    public String getName() {
        return "jpaconfiguration";
    }

    protected Configuration createConfiguration() {
        String persistenceUnit = this.getExporterMojo().getComponentProperty("persistenceunit");
        try {
            Ejb3Configuration ejb3cfg = new Ejb3Configuration();
            if (ejb3cfg.configure(persistenceUnit, this.getMappedProperties()) == null) {
                this.getExporterMojo().getLog().error((CharSequence)("Persistence unit not found: '" + persistenceUnit + "'."));
                return null;
            }
            return ejb3cfg.getHibernateConfiguration();
        }
        catch (HibernateException he) {
            this.getExporterMojo().getLog().error((CharSequence)he.getMessage());
            return null;
        }
    }

    private Map getMappedProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        String namingStrategy = this.getExporterMojo().getComponentProperty("namingstrategy");
        if (namingStrategy != null) {
            map.put("hibernate.ejb.naming_strategy", namingStrategy);
        }
        return map;
    }
}

