/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.configuration;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.hibernate3.configuration.AbstractComponentConfiguration;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.util.ReflectHelper;
import org.jboss.util.file.ArchiveBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationComponentConfiguration
extends AbstractComponentConfiguration {
    public String getName() {
        return "annotationconfiguration";
    }

    protected Configuration createConfiguration() {
        AnnotationConfiguration configuration = new AnnotationConfiguration();
        if (this.getExporterMojo().getComponentProperty("scan-classes", false) || this.getExporterMojo().getComponentProperty("scan-jars", false)) {
            try {
                Build build = this.getExporterMojo().getProject().getBuild();
                ArrayList<String> entities = new ArrayList<String>(50);
                if (this.getExporterMojo().getComponentProperty("scan-classes", false)) {
                    this.scanForClasses(new File(build.getOutputDirectory()), entities);
                    this.scanForClasses(new File(build.getTestOutputDirectory()), entities);
                }
                if (this.getExporterMojo().getComponentProperty("scan-jars", false)) {
                    List runtimeArtifacts = this.getExporterMojo().getProject().getRuntimeArtifacts();
                    for (Object o : runtimeArtifacts) {
                        File artifactFile = ((Artifact)o).getFile();
                        if (artifactFile.isDirectory()) continue;
                        this.getExporterMojo().getLog().debug((CharSequence)("[URL] " + artifactFile.toURI().toURL().toString()));
                        this.scanForClasses(artifactFile, entities);
                    }
                    List testArtifacts = this.getExporterMojo().getProject().getTestArtifacts();
                    for (Object o : testArtifacts) {
                        File artifactFile = ((Artifact)o).getFile();
                        if (artifactFile.isDirectory()) continue;
                        this.getExporterMojo().getLog().debug((CharSequence)("[URL] " + artifactFile.toURI().toURL().toString()));
                        this.scanForClasses(artifactFile, entities);
                    }
                }
                this.addNamedAnnotatedClasses(configuration, entities);
            }
            catch (MalformedURLException e) {
                this.getExporterMojo().getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForClasses(File directory, List<String> entities) throws MalformedURLException {
        if (directory.list() != null) {
            Iterator it;
            this.getExporterMojo().getLog().debug((CharSequence)("[scanForClasses] " + directory));
            URL jar = directory.toURI().toURL();
            try {
                it = ArchiveBrowser.getBrowser((URL)jar, (ArchiveBrowser.Filter)new ArchiveBrowser.Filter(){

                    public boolean accept(String filename) {
                        return filename.endsWith(".class");
                    }
                });
            }
            catch (RuntimeException e) {
                throw new RuntimeException("error trying to scan <jar-file>: " + jar.toString(), e);
            }
            while (it.hasNext()) {
                boolean isEmbeddableSuperclass;
                boolean isEmbeddable;
                boolean isEntity;
                InputStream stream = (InputStream)it.next();
                DataInputStream dstream = new DataInputStream(stream);
                ClassFile cf = null;
                try {
                    try {
                        cf = new ClassFile(dstream);
                    }
                    finally {
                        dstream.close();
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
                if (visible == null) continue;
                boolean bl = isEntity = visible.getAnnotation(Entity.class.getName()) != null;
                if (isEntity) {
                    this.getExporterMojo().getLog().info((CharSequence)("found EJB3 Entity bean: " + cf.getName()));
                    entities.add(cf.getName());
                }
                boolean bl2 = isEmbeddable = visible.getAnnotation(Embeddable.class.getName()) != null;
                if (isEmbeddable) {
                    this.getExporterMojo().getLog().info((CharSequence)("found EJB3 @Embeddable: " + cf.getName()));
                    entities.add(cf.getName());
                }
                if (!(isEmbeddableSuperclass = visible.getAnnotation(MappedSuperclass.class.getName()) != null)) continue;
                this.getExporterMojo().getLog().info((CharSequence)("found EJB3 @MappedSuperclass: " + cf.getName()));
                entities.add(cf.getName());
            }
        }
    }

    private void addNamedAnnotatedClasses(AnnotationConfiguration cfg, Collection<String> classNames) {
        for (String name : classNames) {
            try {
                Class clazz = this.classForName(name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg;
                try {
                    pkg = this.classForName(name + ".package-info").getPackage();
                }
                catch (ClassNotFoundException e) {
                    pkg = null;
                }
                if (pkg == null) {
                    throw new PersistenceException(name + " class or package not found", (Throwable)cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }

    private Class classForName(String className) throws ClassNotFoundException {
        return ReflectHelper.classForName((String)className, ((Object)((Object)this)).getClass());
    }

    protected void validateParameters() throws MojoExecutionException {
        super.validateParameters();
        if (this.getConfigurationFile() == null && !this.getExporterMojo().getComponentProperty("scan-classes", false) && !this.getExporterMojo().getComponentProperty("scan-jars", false)) {
            throw new MojoExecutionException("No hibernate.cfg.xml configuration provided. Annotated classes/packages is only configurable via hibernate.cfg.xml");
        }
    }
}

