/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.exporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:hibernate3-maven-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Hibernate3 Maven Plugin 2.2", 0);
        this.append(sb, "Maven plugin based on the hibernate-tools project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2cfgxml".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2cfgxml", 0);
            this.append(sb, "Generates hibernate.cfg.xml", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2dao".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2dao", 0);
            this.append(sb, "Base class for the different hibernate3 goals based on the Ant tasks of hibernate tools.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2ddl".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2ddl", 0);
            this.append(sb, "Generates database schema.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2doc".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2doc", 0);
            this.append(sb, "Generates HTML documentation for the database schema.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2hbmxml".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2hbmxml", 0);
            this.append(sb, "Generates a set of hbm.xml files", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2java".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2java", 0);
            this.append(sb, "Generates Java classes from set of *.hbm.xml files", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbmtemplate".equals(this.goal)) {
            this.append(sb, "hibernate3:hbmtemplate", 0);
            this.append(sb, "Generic exporter that can be controlled by a user provided template or class.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "componentProperties", 2);
                this.append(sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "components", 2);
                this.append(sb, "Parameter that holds components definitions specified by the user.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "hibernate3:help", 0);
            this.append(sb, "Display help information on hibernate3-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0hibernate3:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

