/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.hibernate3.ExporterMojo;
import org.codehaus.mojo.hibernate3.HibernateUtils;
import org.codehaus.mojo.hibernate3.configuration.ComponentConfiguration;
import org.codehaus.mojo.hibernate3.exporter.Component;
import org.hibernate.tool.hbm2x.Exporter;

public abstract class HibernateExporterMojo
extends AbstractMojo
implements ExporterMojo {
    private List components = new ArrayList();
    private Map defaultComponents = new HashMap();
    private Map componentProperties = new HashMap();
    private List componentConfigurations = new ArrayList();
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public boolean getComponentProperty(String key, boolean defaultValue) {
        String s = this.getComponentProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClassLoader());
            if (this.getComponentProperty("skip", false)) {
                this.getLog().info((CharSequence)"skipping hibernate3 execution");
            } else {
                this.doExecute();
            }
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    protected void addDefaultComponent(String outputDirectory, String implementation, boolean jdk5) {
        Component component = new Component();
        component.setName(this.getName());
        component.setOutputDirectory(outputDirectory);
        component.setImplementation(implementation);
        this.defaultComponents.put(jdk5 ? "jdk15" : "jdk14", component);
    }

    protected Exporter configureExporter(Exporter exporter) throws MojoExecutionException {
        String implementation = this.getComponentProperty("implementation", this.getComponent().getImplementation());
        ComponentConfiguration componentConfiguration = this.getComponentConfiguration(implementation);
        this.getLog().info((CharSequence)("using " + componentConfiguration.getName() + " task."));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.componentProperties);
        exporter.setProperties(properties);
        exporter.setConfiguration(componentConfiguration.getConfiguration((ExporterMojo)this));
        exporter.setOutputDirectory(new File(this.getProject().getBasedir(), this.getComponent().getOutputDirectory()));
        File outputDir = new File(this.getProject().getBasedir(), this.getComponent().getOutputDirectory());
        if (this.getComponent().isCompileSourceRoot()) {
            this.getProject().addCompileSourceRoot(outputDir.getPath());
        }
        if (this.getComponentProperty("template") != null) {
            File templatePathDefault = new File(this.getProject().getBasedir(), "/src/main/config/templates");
            String templatePath = this.getComponentProperty("templatepath", templatePathDefault.getPath());
            this.getLog().info((CharSequence)("Exporter will use templatepath : " + templatePath));
            exporter.setTemplatePath(new String[]{templatePath});
        }
        return exporter;
    }

    protected ComponentConfiguration getComponentConfiguration(String name) throws MojoExecutionException {
        Iterator it = this.componentConfigurations.iterator();
        while (it.hasNext()) {
            ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
            if (!componentConfiguration.getName().equals(name)) continue;
            return componentConfiguration;
        }
        throw new MojoExecutionException("Could not get ConfigurationTask.");
    }

    public String getComponentProperty(String key) {
        return this.getComponentProperty(key, null);
    }

    public String getComponentProperty(String key, String defaultValue) {
        String value = (String)this.componentProperties.get(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value;
    }

    protected abstract Exporter createExporter();

    protected void doExecute() throws MojoExecutionException {
        this.configureExporter(this.createExporter()).start();
    }

    private ClassLoader getClassLoader() {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Couldn't get the classloader.");
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Component getComponent() {
        Component defaultGoal = (Component)this.defaultComponents.get(HibernateUtils.getJavaVersion());
        if (!this.components.isEmpty()) {
            String name = this.getName();
            if ("report".equals(name)) {
                name = "hbm2doc";
            }
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                Component component = (Component)it.next();
                if (!name.equals(component.getName())) continue;
                if (component.getImplementation() == null) {
                    component.setImplementation(defaultGoal.getImplementation());
                }
                if (component.getOutputDirectory() == null) {
                    component.setOutputDirectory(defaultGoal.getOutputDirectory());
                }
                return component;
            }
        }
        return defaultGoal;
    }
}

