/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireProjectUrl
implements EnforcerRule {
    private String regex = "^.+$";

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            if (project.getUrl() == null) {
                throw new EnforcerRuleException("The project URL is not defined");
            }
            Matcher matcher = Pattern.compile(this.regex).matcher(project.getUrl());
            if (!matcher.matches()) {
                throw new EnforcerRuleException("The project URL " + project.getUrl() + " does not match the required regex: " + this.regex);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (PatternSyntaxException e) {
            throw new EnforcerRuleException("Invalid regex \"" + this.regex + "\": " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }
}

