/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cobertura.CoberturaMojoUtils;
import org.codehaus.mojo.cobertura.configuration.MaxHeapSizeUtil;
import org.codehaus.mojo.cobertura.tasks.AbstractTask;

public abstract class AbstractCoberturaMojo
extends AbstractMojo {
    private MavenProject project;
    private String maxmem = "64m";
    private File dataFile;
    private MojoExecution mojoExecution;
    private boolean quiet;
    protected List<Artifact> pluginClasspathList;
    private boolean skip;
    private boolean forceMojoExecution;

    protected void setTaskDefaults(AbstractTask task) {
        task.setLog(this.getLog());
        task.setPluginClasspathList(this.pluginClasspathList);
        if (MaxHeapSizeUtil.getInstance().envHasMavenMaxMemSetting()) {
            this.maxmem = MaxHeapSizeUtil.getInstance().getMavenMaxMemSetting();
        } else {
            task.setMaxmem(this.maxmem);
        }
        task.setQuiet(this.quiet);
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cobertura execution");
            return true;
        }
        if (!this.forceMojoExecution && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping cobertura mojo for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected File getDataFile() {
        return CoberturaMojoUtils.getDataFile(new File(this.project.getBuild().getDirectory()), this.mojoExecution);
    }

    protected final MavenProject getProject() {
        return this.project;
    }
}

