/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;

public class DependencyCalculator {
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${session.projectBuildingRequest}", readonly=true, required=true)
    private ProjectBuildingRequest projectBuildingRequest;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject mavenProject;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private ArtifactInstaller installer;

    public DependencyCalculator(DependencyResolver dependencyResolver, ArtifactResolver artifactResolver, ProjectBuildingRequest projectBuildingRequest, MavenProject mavenProject, ProjectBuilder mavenProjectBuilder, ArtifactInstaller installer) {
        this.dependencyResolver = dependencyResolver;
        this.artifactResolver = artifactResolver;
        this.projectBuildingRequest = projectBuildingRequest;
        this.mavenProject = mavenProject;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.installer = installer;
    }

    public Set<File> execute() throws Exception {
        this.fixupProjectArtifact();
        Artifact art = this.mavenProject.getArtifact();
        DefaultArtifactCoordinate containerArtifactCoordinate = new DefaultArtifactCoordinate();
        containerArtifactCoordinate.setGroupId(art.getGroupId() + ".cargodeps");
        containerArtifactCoordinate.setArtifactId(art.getArtifactId());
        containerArtifactCoordinate.setVersion(art.getVersion());
        containerArtifactCoordinate.setExtension("pom");
        Artifact art2 = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)containerArtifactCoordinate).getArtifact();
        ProjectBuildingResult projectBuildingResult = this.mavenProjectBuilder.build(art2, this.projectBuildingRequest);
        HashSet<File> filesToAdd = new HashSet<File>();
        for (Artifact artifact : projectBuildingResult.getProject().getArtifacts()) {
            if (!artifact.getType().equals("jar")) continue;
            filesToAdd.add(artifact.getFile());
        }
        return filesToAdd;
    }

    protected void fixupProjectArtifact() throws Exception {
        MavenProject mp2 = this.mavenProject.clone();
        for (Artifact artifact : mp2.getArtifacts()) {
            if (!artifact.getType().equals("war")) continue;
            DefaultArtifactCoordinate containerArtifactCoordinate = new DefaultArtifactCoordinate();
            containerArtifactCoordinate.setGroupId(artifact.getGroupId());
            containerArtifactCoordinate.setArtifactId(artifact.getArtifactId());
            containerArtifactCoordinate.setVersion(artifact.getVersion());
            containerArtifactCoordinate.setExtension("pom");
            Artifact art2 = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)containerArtifactCoordinate).getArtifact();
            this.fixupRepositoryArtifact(art2);
        }
        Model pomFile = mp2.getModel();
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        pomFile = pomReader.read((Reader)new FileReader(outFile));
        Artifact art = mp2.getArtifact();
        this.fixModelAndSaveInRepository(art, pomFile);
        outFile.delete();
    }

    protected void fixupRepositoryArtifact(Artifact artifact) throws Exception {
        File artifactFile = artifact.getFile();
        ProjectBuildingResult projectBuildingResult = this.mavenProjectBuilder.build(artifact, this.projectBuildingRequest);
        for (Artifact createdArtifact : projectBuildingResult.getProject().getArtifacts()) {
            if (!createdArtifact.getType().equals("war")) continue;
            DefaultArtifactCoordinate containerArtifactCoordinate = new DefaultArtifactCoordinate();
            containerArtifactCoordinate.setGroupId(createdArtifact.getGroupId());
            containerArtifactCoordinate.setArtifactId(createdArtifact.getArtifactId());
            containerArtifactCoordinate.setVersion(createdArtifact.getVersion());
            containerArtifactCoordinate.setExtension("pom");
            Artifact art2 = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)containerArtifactCoordinate).getArtifact();
            this.fixupRepositoryArtifact(art2);
        }
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model pomFile = pomReader.read((Reader)new FileReader(artifactFile));
        this.fixModelAndSaveInRepository(artifact, pomFile);
    }

    protected void fixModelAndSaveInRepository(Artifact artifact, Model pomFile) throws Exception {
        for (Object dependency : pomFile.getDependencies()) {
            Dependency art = (Dependency)dependency;
            if (!art.getType().equals("war")) continue;
            art.setGroupId(art.getGroupId() + ".cargodeps");
            art.setType("pom");
        }
        pomFile.setPackaging("pom");
        String version = pomFile.getVersion();
        if (version == null) {
            version = pomFile.getParent().getVersion();
        }
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        DefaultArtifactCoordinate containerArtifactCoordinate = new DefaultArtifactCoordinate();
        containerArtifactCoordinate.setGroupId(artifact.getGroupId() + ".cargodeps");
        containerArtifactCoordinate.setArtifactId(artifact.getArtifactId());
        containerArtifactCoordinate.setVersion(artifact.getVersion());
        containerArtifactCoordinate.setExtension("pom");
        Artifact art2 = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)containerArtifactCoordinate).getArtifact();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>(1);
        artifactList.add(art2);
        this.installer.install(this.projectBuildingRequest, artifactList);
        outFile.delete();
    }
}

