/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.maven3.AbstractCommonMojo;
import org.codehaus.cargo.maven3.configuration.ArtifactInstaller;
import org.codehaus.cargo.maven3.configuration.Configuration;
import org.codehaus.cargo.maven3.configuration.Container;
import org.codehaus.cargo.maven3.configuration.Daemon;
import org.codehaus.cargo.maven3.configuration.Deployable;
import org.codehaus.cargo.maven3.configuration.Deployer;
import org.codehaus.cargo.maven3.configuration.ZipUrlInstaller;
import org.codehaus.cargo.maven3.deployer.DefaultDeployableMonitorFactory;
import org.codehaus.cargo.maven3.log.MavenLogger;
import org.codehaus.cargo.maven3.util.CargoProject;
import org.codehaus.cargo.maven3.util.EmbeddedContainerArtifactResolver;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractCargoMojo
extends AbstractCommonMojo {
    public static final String CONTEXT_KEY_CONTAINER = AbstractCargoMojo.class.getName() + "-Container";
    public static final String CONTEXT_KEY_CLASSLOADER = "-classloader";
    private static final String MAVEN_REPOSITORY_URL = "https://repo.maven.apache.org/maven2/";
    @Parameter
    private Configuration configuration;
    @Parameter
    private Container container;
    @Parameter
    private Daemon daemon;
    @Parameter
    private Deployer deployer;
    @Parameter
    private Deployable[] deployables;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${session.projectBuildingRequest}", readonly=true, required=true)
    private ProjectBuildingRequest projectBuildingRequest;
    @Parameter(property="cargo.maven.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cargo.maven.useLogCategoryPrefix", defaultValue="false")
    private boolean useLogCategoryPrefix;
    private CargoProject cargoProject;
    @Parameter(property="settings", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="plugin.version", readonly=true, required=true)
    private String pluginVersion;
    @Parameter(property="cargo.ignore.failures", defaultValue="false")
    private boolean ignoreFailures = false;

    public static String calculateContainerArtifactId(String containerId) {
        return "cargo-core-container-" + containerId.replaceAll("\\d+x", "");
    }

    public static ArtifactInstaller calculateArtifact(String url) {
        if (!url.startsWith(MAVEN_REPOSITORY_URL)) {
            throw new IllegalArgumentException("URL [" + url + "] does not start with [" + MAVEN_REPOSITORY_URL + "]");
        }
        ArtifactInstaller installer = new ArtifactInstaller();
        String[] urlParts = url.substring(MAVEN_REPOSITORY_URL.length()).split("/+");
        StringBuilder groupId = new StringBuilder();
        for (int i = 0; i < urlParts.length - 3; ++i) {
            String urlPart = urlParts[i];
            if (groupId.length() > 0) {
                groupId.append(".");
            }
            groupId.append(urlPart);
        }
        installer.setGroupId(groupId.toString());
        installer.setArtifactId(urlParts[urlParts.length - 3]);
        installer.setVersion(urlParts[urlParts.length - 2]);
        String filePrefix = installer.getArtifactId() + "-" + installer.getVersion();
        String file = urlParts[urlParts.length - 1];
        installer.setType(file.substring(file.indexOf(46, filePrefix.length()) + 1));
        if (!file.equals(filePrefix + "." + installer.getType())) {
            String classifier = file.substring(filePrefix.length() + 1);
            installer.setClassifier(classifier.substring(0, classifier.indexOf(46)));
        }
        return installer;
    }

    protected Deployer getDeployerElement() {
        return this.deployer;
    }

    protected void setDeployerElement(Deployer deployerElement) {
        this.deployer = deployerElement;
    }

    protected Daemon getDaemon() {
        if (this.daemon == null) {
            this.daemon = new Daemon();
        }
        return this.daemon;
    }

    protected Deployable[] getDeployablesElement() {
        return this.deployables;
    }

    protected void setDeployablesElement(Deployable[] deployablesElement) {
        this.deployables = deployablesElement;
    }

    protected Configuration getConfigurationElement() {
        return this.configuration;
    }

    protected void setConfigurationElement(Configuration configurationElement) {
        this.configuration = configurationElement;
    }

    protected Container getContainerElement() {
        return this.container;
    }

    protected void setContainerElement(Container containerElement) {
        this.container = containerElement;
    }

    protected void setCargoProject(CargoProject cargoProject) {
        this.cargoProject = cargoProject;
    }

    protected CargoProject getCargoProject() {
        return this.cargoProject;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException {
        block11: {
            Proxy activeProxy;
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping cargo execution");
                return;
            }
            if (this.cargoProject == null) {
                this.cargoProject = new CargoProject(this.getProject(), this.getLog());
            }
            org.codehaus.cargo.container.installer.Proxy proxy = null;
            if (this.settings != null && (activeProxy = this.settings.getActiveProxy()) != null) {
                this.getLog().debug((CharSequence)"Using proxy definitions from the Maven settings");
                proxy = new org.codehaus.cargo.container.installer.Proxy();
                proxy.setHost(activeProxy.getHost());
                proxy.setPort(activeProxy.getPort());
                proxy.setExcludeHosts(activeProxy.getNonProxyHosts());
                proxy.setUser(activeProxy.getUsername());
                proxy.setPassword(activeProxy.getPassword());
            }
            Map previousProperties = null;
            try {
                if (proxy != null) {
                    previousProperties = proxy.configure();
                }
                this.doExecute();
            }
            catch (MojoExecutionException e) {
                if (this.ignoreFailures) {
                    this.getLog().error((CharSequence)"Ignoring failures during execution", (Throwable)e);
                    break block11;
                }
                throw e;
            }
            finally {
                if (proxy != null) {
                    proxy.clear(previousProperties);
                }
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException;

    protected org.codehaus.cargo.container.configuration.Configuration createConfiguration() throws MojoExecutionException {
        if (this.getConfigurationElement() == null) {
            Configuration configurationElement = new Configuration();
            if (this.getContainerElement().getType().isLocal()) {
                File home = new File(this.getCargoProject().getBuildDirectory(), "cargo/configurations/" + this.getContainerElement().getContainerId());
                configurationElement.setType(ConfigurationType.STANDALONE);
                configurationElement.setHome(home.getAbsolutePath());
            } else {
                configurationElement.setType(ConfigurationType.RUNTIME);
            }
            this.setConfigurationElement(configurationElement);
        } else if (this.getConfigurationElement().getHome() != null && !this.getCargoProject().isDaemonRun()) {
            this.getConfigurationElement().setHome(this.calculateAbsoluteDirectory("configuration home", this.getConfigurationElement().getHome()));
        }
        String contextKey = null;
        if (this.getContainerElement() != null && this.getContainerElement().getContextKey() != null && !this.getContainerElement().getContextKey().trim().isEmpty()) {
            contextKey = this.getContainerElement().getContextKey().trim();
        }
        org.codehaus.cargo.container.configuration.Configuration configuration = this.getConfigurationElement().createConfiguration(this.getContainerElement().getContainerId(), this.getContainerElement().getType(), this.getDeployablesElement(), this.getCargoProject(), this.getProject(), contextKey, this.settings, this.getLog());
        return configuration;
    }

    protected org.codehaus.cargo.container.Container createContainer() throws MojoExecutionException {
        org.codehaus.cargo.container.Container container = null;
        Map context = this.getPluginContext();
        String containerKey = CONTEXT_KEY_CONTAINER;
        if (this.getContainerElement() != null) {
            if (this.getContainerElement().getHome() != null && !this.getCargoProject().isDaemonRun()) {
                this.getContainerElement().setHome(this.calculateAbsoluteDirectory("container home", this.getContainerElement().getHome()));
            }
            if (this.getContainerElement().getArtifactInstaller() != null && this.getContainerElement().getArtifactInstaller().getExtractDir() != null) {
                this.getContainerElement().getArtifactInstaller().setExtractDir(this.calculateAbsoluteDirectory("artifact installer extract", this.getContainerElement().getArtifactInstaller().getExtractDir()));
            }
            if (this.getContainerElement().getZipUrlInstaller() != null && this.getContainerElement().getZipUrlInstaller().getDownloadDir() != null) {
                this.getContainerElement().getZipUrlInstaller().setDownloadDir(this.calculateAbsoluteDirectory("zip URL installer download", this.getContainerElement().getZipUrlInstaller().getDownloadDir()));
            }
            if (this.getContainerElement().getZipUrlInstaller() != null && this.getContainerElement().getZipUrlInstaller().getExtractDir() != null) {
                this.getContainerElement().getZipUrlInstaller().setExtractDir(this.calculateAbsoluteDirectory("zip URL installer extract", this.getContainerElement().getZipUrlInstaller().getExtractDir()));
            }
            containerKey = this.getContainerElement().getContextKey() != null && !this.getContainerElement().getContextKey().isEmpty() ? containerKey + "." + this.getContainerElement().getContextKey() : containerKey + "." + this.getContainerElement().getType() + "." + this.getContainerElement().getHome();
        }
        if (this.getConfigurationElement() != null && !this.getCargoProject().isDaemonRun()) {
            if (this.getConfigurationElement().getHome() != null) {
                this.getConfigurationElement().setHome(this.calculateAbsoluteDirectory("configuration home", this.getConfigurationElement().getHome()));
            }
            if (this.getContainerElement() == null || this.getContainerElement().getContextKey() == null || this.getContainerElement().getContextKey().isEmpty()) {
                containerKey = containerKey + "." + this.getConfigurationElement().getHome();
            }
        }
        if (context != null) {
            container = (org.codehaus.cargo.container.Container)context.get(containerKey);
            String classloaderKey = containerKey + CONTEXT_KEY_CLASSLOADER;
            if (context.containsKey(classloaderKey)) {
                ResourceUtils.setResourceLoader((ClassLoader)((ClassLoader)context.get(classloaderKey)));
            }
        }
        if (container == null) {
            container = this.createNewContainer();
        } else if (this.getConfigurationElement() != null) {
            this.createDefaultContainerElementIfNecessary();
            org.codehaus.cargo.container.configuration.Configuration configuration = this.createConfiguration();
            configuration.setLogger(container.getLogger());
            if (container instanceof RemoteContainer) {
                if (!(configuration instanceof RuntimeConfiguration)) {
                    throw new MojoExecutionException("Expected a " + RuntimeConfiguration.class.getName() + " but got a " + configuration.getClass().getName());
                }
                ((RemoteContainer)container).setConfiguration((RuntimeConfiguration)configuration);
            } else if (container instanceof LocalContainer) {
                if (!(configuration instanceof LocalConfiguration)) {
                    throw new MojoExecutionException("Expected a " + LocalConfiguration.class.getName() + " but got a " + configuration.getClass().getName());
                }
                ((LocalContainer)container).setConfiguration((LocalConfiguration)configuration);
            } else {
                throw new MojoExecutionException("Unknown container type " + container.getClass().getName());
            }
        }
        if (context != null) {
            context.put(containerKey, container);
            if (ResourceUtils.getResourceLoader() != null) {
                context.put(containerKey + CONTEXT_KEY_CLASSLOADER, ResourceUtils.getResourceLoader());
            }
        }
        return container;
    }

    protected org.codehaus.cargo.container.Container createNewContainer() throws MojoExecutionException {
        this.createDefaultContainerElementIfNecessary();
        try {
            this.createDefaultInstallerElementIfNecessary();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Cannot load the URL to put as the optional default installer element for the container, skipping as this won't kill anyway...", (Throwable)e);
        }
        if (this.getContainerElement().getType() == ContainerType.EMBEDDED) {
            EmbeddedContainerArtifactResolver resolver = new EmbeddedContainerArtifactResolver(this.artifactResolver, this.projectBuildingRequest);
            ClassLoader classLoader = resolver.resolveDependencies(this.getContainerElement().getContainerId(), this.getCargoProject().getEmbeddedClassLoader());
            this.getCargoProject().setEmbeddedClassLoader(classLoader);
            if (("tomcat8x".equals(this.getContainerElement().getContainerId()) || "tomcat9x".equals(this.getContainerElement().getContainerId())) && Security.getProperty("authconfigprovider.factory") == null) {
                Security.setProperty("authconfigprovider.factory", "org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl");
            }
        }
        Logger logger = this.createLogger();
        org.codehaus.cargo.container.configuration.Configuration configuration = this.createConfiguration();
        configuration.setLogger(logger);
        org.codehaus.cargo.container.Container container = this.getContainerElement().createContainer(configuration, logger, this.getCargoProject(), this.artifactResolver, this.projectBuildingRequest, this.settings);
        return container;
    }

    protected void createDefaultContainerElementIfNecessary() throws MojoExecutionException {
        String containerId;
        if (this.getContainerElement() == null) {
            if (this.getCargoProject().getPackaging() != null && !this.getCargoProject().getPackaging().equalsIgnoreCase("war")) {
                throw new MojoExecutionException("For all packaging other than war you need to configure the container you wish to use.");
            }
            Container containerElement = new Container();
            this.setContainerElement(containerElement);
        }
        if (this.getContainerElement().getContainerId() == null) {
            if (this.getContainerElement().getArtifactInstaller() != null) {
                throw new MojoExecutionException("You have specified no containerId but have specified an artifactInstaller. Please check the plugin configuration.");
            }
            if (this.getContainerElement().getZipUrlInstaller() != null) {
                throw new MojoExecutionException("You have specified no containerId but have specified a zipUrlInstaller. Please check the plugin configuration.");
            }
            this.getContainerElement().setContainerId("jetty9x");
            this.getContainerElement().setType(ContainerType.INSTALLED);
            ArtifactInstaller artifactInstaller = new ArtifactInstaller();
            artifactInstaller.setGroupId("org.eclipse.jetty");
            artifactInstaller.setArtifactId("jetty-home");
            artifactInstaller.setVersion("9.4.53.v20231009");
            this.getContainerElement().setArtifactInstaller(artifactInstaller);
            this.getLog().info((CharSequence)("No container defined, using a default [" + this.getContainerElement().getContainerId() + ", " + this.getContainerElement().getType().getType() + "] container"));
        }
        if ((containerId = this.getContainerElement().getContainerId()) != null && this.artifactResolver != null && this.dependencyResolver != null) {
            String containerArtifactId = AbstractCargoMojo.calculateContainerArtifactId(containerId);
            DefaultArtifactCoordinate containerArtifactCoordinate = new DefaultArtifactCoordinate();
            containerArtifactCoordinate.setGroupId("org.codehaus.cargo");
            containerArtifactCoordinate.setArtifactId(containerArtifactId);
            containerArtifactCoordinate.setVersion(this.pluginVersion);
            containerArtifactCoordinate.setExtension("jar");
            try {
                Artifact containerArtifact = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)containerArtifactCoordinate).getArtifact();
                URL containerArtifactUrl = containerArtifact.getFile().toURI().toURL();
                ArrayList<URL> urlClassLoaderURLs = new ArrayList<URL>();
                for (ClassLoader classLoader = ResourceUtils.getResourceLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                    if (!(classLoader instanceof URLClassLoader)) continue;
                    urlClassLoaderURLs.addAll(Arrays.asList(((URLClassLoader)classLoader).getURLs()));
                }
                if (urlClassLoaderURLs.contains(containerArtifactUrl)) {
                    this.createLogger().debug("Container artifact " + containerArtifact + " for container " + containerId + " already in class loader", ((Object)((Object)this)).getClass().getName());
                } else {
                    ArrayList<URL> containerArtifactURLs = new ArrayList<URL>();
                    containerArtifactURLs.add(containerArtifactUrl);
                    DefaultDependableCoordinate containerDependableCoordinate = new DefaultDependableCoordinate();
                    containerDependableCoordinate.setGroupId("org.codehaus.cargo");
                    containerDependableCoordinate.setArtifactId(containerArtifactId);
                    containerDependableCoordinate.setVersion(this.pluginVersion);
                    containerDependableCoordinate.setType("jar");
                    for (ArtifactResult artifactResult : this.dependencyResolver.resolveDependencies(this.projectBuildingRequest, (DependableCoordinate)containerDependableCoordinate, (TransformableFilter)ScopeFilter.including((String[])new String[]{"compile"}))) {
                        URL artifactURL = artifactResult.getArtifact().getFile().toURI().toURL();
                        if (urlClassLoaderURLs.contains(artifactURL)) continue;
                        containerArtifactURLs.add(artifactURL);
                    }
                    URL[] containerArtifactArray = new URL[containerArtifactURLs.size()];
                    containerArtifactArray = containerArtifactURLs.toArray(containerArtifactArray);
                    URLClassLoader containerArtifactClassLoader = new URLClassLoader(containerArtifactArray, ((Object)((Object)this)).getClass().getClassLoader());
                    ResourceUtils.setResourceLoader((ClassLoader)containerArtifactClassLoader);
                    this.createLogger().debug("Resolved artifact and dependencies: " + containerArtifactURLs, ((Object)((Object)this)).getClass().getName());
                    this.createLogger().info("Resolved container artifact " + containerArtifact + " for container " + containerId, ((Object)((Object)this)).getClass().getName());
                }
            }
            catch (Exception e) {
                this.createLogger().debug("Cannot resolve container artifact " + containerArtifactCoordinate + " for container " + containerId + ": " + e.toString(), ((Object)((Object)this)).getClass().getName());
            }
        }
    }

    protected void createDefaultInstallerElementIfNecessary() throws IOException {
        InputStream containerUrls;
        if (this.getContainerElement().getType() == ContainerType.INSTALLED && this.getContainerElement().getHome() == null && this.getContainerElement().getZipUrlInstaller() == null && this.getContainerElement().getArtifactInstaller() == null && (containerUrls = ((Object)((Object)this)).getClass().getResourceAsStream("/org/codehaus/cargo/documentation/container-urls.properties")) != null) {
            Properties containerUrlsProperties = new Properties();
            containerUrlsProperties.load(containerUrls);
            String url = containerUrlsProperties.getProperty("cargo." + this.getContainerElement().getContainerId() + ".url");
            if (url != null) {
                if (url.startsWith(MAVEN_REPOSITORY_URL)) {
                    try {
                        ArtifactInstaller installerElement = AbstractCargoMojo.calculateArtifact(url);
                        this.getContainerElement().setArtifactInstaller(installerElement);
                        this.getLog().info((CharSequence)("You did not specify a container home nor any installer. Codehaus Cargo will automatically download your container's binaries as a Maven 3 artifact from [" + url + "]."));
                        return;
                    }
                    catch (Exception e) {
                        this.getLog().debug((CharSequence)("Cannot parse URL [" + url + "]."), (Throwable)e);
                    }
                }
                ZipUrlInstaller installerElement = new ZipUrlInstaller();
                this.getContainerElement().setZipUrlInstaller(installerElement);
                installerElement.setUrl(new URL(url));
                this.getLog().info((CharSequence)("You did not specify a container home nor any installer. Codehaus Cargo will automatically download your container's binaries from [" + url + "]."));
            }
        }
    }

    protected org.codehaus.cargo.container.deployable.Deployable createAutoDeployDeployable(org.codehaus.cargo.container.Container container) throws MojoExecutionException {
        Deployable deployableElement = new Deployable();
        return deployableElement.createDeployable(container.getId(), this.getCargoProject());
    }

    protected Logger createLogger() {
        MavenLogger logger;
        if (this.getContainerElement() != null && this.getContainerElement().getLog() != null) {
            this.getContainerElement().getLog().getParentFile().mkdirs();
            logger = new FileLogger(this.getContainerElement().getLog(), true);
        } else {
            logger = new MavenLogger(this.getLog(), this.useLogCategoryPrefix);
        }
        if (this.getContainerElement() != null && this.getContainerElement().getLogLevel() != null) {
            logger.setLevel(this.getContainerElement().getLogLevel());
        } else if (this.getLog().isDebugEnabled()) {
            logger.setLevel(LogLevel.DEBUG);
        } else if (this.getLog().isInfoEnabled()) {
            logger.setLevel(LogLevel.INFO);
        } else {
            logger.setLevel(LogLevel.WARN);
        }
        return logger;
    }

    protected void waitDeployableMonitor(org.codehaus.cargo.container.Container container, boolean starting) {
        if (this.getDeployablesElement() != null) {
            Logger watchdogLogger = this.createLogger();
            Deployable[] deployableArray = this.getDeployablesElement();
            int n = deployableArray.length;
            for (int i = 0; i < n; ++i) {
                DefaultDeployableMonitorFactory monitorFactory = new DefaultDeployableMonitorFactory();
                Deployable deployable = deployableArray[i];
                DeployableMonitor monitor = monitorFactory.createDeployableMonitor(container, deployable);
                if (monitor == null) continue;
                DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
                watchdog.setLogger(watchdogLogger);
                monitor.setLogger(watchdogLogger);
                watchdog.watch(starting);
            }
        }
    }

    private String calculateAbsoluteDirectory(String type, String directory) {
        File directoryFile = new File(directory);
        if (!directoryFile.isAbsolute()) {
            String absoluteDirectory = directoryFile.getAbsolutePath();
            this.getLog().warn((CharSequence)("The provided " + type + " directory [" + directory + "] is not an absolute directory. Replacing it with its absolute directory counterpart, i.e. [" + absoluteDirectory + "]. To avoid this message in the future, you can also use the ${basedir} variable in your paths."));
            return absoluteDirectory;
        }
        return directory;
    }
}

