/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.generic.storeByValueSimulation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import javax.cache.CacheException;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CopyTransformer;

public class SerializableCopyTransformer<T>
extends CopyTransformer<T> {
    private final ClassLoader classLoader;

    public SerializableCopyTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    protected T copy(T o) {
        return (T)this.copySerializableObject(o);
    }

    Object copySerializableObject(Object o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, SerializableCopyTransformer.this.classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return in.readObject();
        }
        catch (IOException ex) {
            throw new CacheException("Failure to copy object", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new CacheException("Failure to copy object", (Throwable)ex);
        }
    }
}

