/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.time.Duration;
import org.cache2k.CacheEntry;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.core.Entry;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.timing.DefaultTimer;
import org.cache2k.core.timing.Tasks;
import org.cache2k.core.timing.Timer;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.core.timing.Timing;
import org.cache2k.expiry.Expiry;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.io.ResiliencePolicy;
import org.cache2k.operation.TimeReference;

public class StaticTiming<K, V>
extends Timing<K, V> {
    public static final Duration SHARP_EXPIRY_SAFETY_GAP;
    protected final ResiliencePolicy<K, V> resiliencePolicy;
    protected final TimeReference clock;
    protected final boolean sharpExpiry;
    protected final boolean refreshAhead;
    protected final long expiryTicks;
    private final Timer timer;
    private TimerEventListener<K, V> target;
    private final long safetyGapTicks;

    StaticTiming(InternalCacheBuildContext<K, V> buildContext, ResiliencePolicy<K, V> resiliencePolicy) {
        this.clock = buildContext.getTimeReference();
        Cache2kConfig<K, V> cfg = buildContext.getConfig();
        this.expiryTicks = cfg.getExpireAfterWrite() == null || cfg.getExpireAfterWrite() == Cache2kConfig.EXPIRY_ETERNAL ? Long.MAX_VALUE : this.clock.toTicks(cfg.getExpireAfterWrite());
        this.refreshAhead = cfg.isRefreshAhead();
        this.sharpExpiry = cfg.isSharpExpiry();
        this.timer = cfg.getTimerLag() == null ? new DefaultTimer(this.clock, buildContext.createScheduler()) : new DefaultTimer(this.clock, buildContext.createScheduler(), this.clock.toTicks(cfg.getTimerLag()));
        this.resiliencePolicy = resiliencePolicy;
        this.safetyGapTicks = StaticTiming.fetchSafetyGapTicks(buildContext);
    }

    private static long fetchSafetyGapTicks(InternalCacheBuildContext<?, ?> ctx) {
        long ticks = ctx.getTimeReference().toTicks(SHARP_EXPIRY_SAFETY_GAP);
        if (ticks <= 0L) {
            ticks = Long.MAX_VALUE;
        }
        return ticks;
    }

    @Override
    public void setTarget(TimerEventListener<K, V> target) {
        this.target = target;
    }

    @Override
    public void cancelAll() {
        this.timer.cancelAll();
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
        closeContext.closeCustomization(this.resiliencePolicy, "resiliencePolicy");
        this.timer.close(closeContext);
    }

    @Override
    public long calculateNextRefreshTime(Entry<K, V> e, V value, long loadTime) {
        return StaticTiming.calcNextRefreshTime(e.getKey(), value, loadTime, e, null, this.expiryTicks, this.sharpExpiry);
    }

    @Override
    public long limitExpiryTime(long now, long expiryTime) {
        return StaticTiming.limitExpiryToMaxLinger(now, this.expiryTicks, expiryTime, this.sharpExpiry);
    }

    @Override
    public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
        long pointInTime = this.resiliencePolicy.suppressExceptionUntil(e.getKey(), inf, e.getInspectionEntry());
        return Expiry.mixTimeSpanAndPointInTime((long)inf.getLoadTime(), (long)this.expiryTicks, (long)pointInTime);
    }

    @Override
    public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
        long pointInTime = this.resiliencePolicy.retryLoadAfter(e.getKey(), inf);
        return Expiry.mixTimeSpanAndPointInTime((long)inf.getLoadTime(), (long)this.expiryTicks, (long)pointInTime);
    }

    long expiredEventuallyStartBackgroundRefresh(Entry<K, V> e, boolean sharpExpiry) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
            this.scheduleTask(0L, e);
            return sharpExpiry ? 5L : 16L;
        }
        return 4L;
    }

    @Override
    public long stopStartTimer(long expiryTime, Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        if (expiryTime == 0L) {
            return 4L;
        }
        if (expiryTime == -1L) {
            long nrt = e.getNextRefreshTime();
            if (nrt == 0L) {
                throw new IllegalArgumentException("neutral expiry not allowed for creation");
            }
            return e.getNextRefreshTime();
        }
        if (expiryTime == Long.MAX_VALUE) {
            return expiryTime;
        }
        long now = this.clock.ticks();
        if (Math.abs(expiryTime) <= now) {
            return this.expiredEventuallyStartBackgroundRefresh(e, expiryTime < 0L);
        }
        if (expiryTime < 0L) {
            long timerTime = -expiryTime - this.safetyGapTicks - this.timer.getLagTicks();
            if (timerTime >= now) {
                e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
                this.scheduleTask(timerTime, e);
                expiryTime = -expiryTime;
            } else {
                this.scheduleFinalExpireWithOptionalRefresh(e, -expiryTime);
            }
        } else {
            this.scheduleFinalExpireWithOptionalRefresh(e, expiryTime);
        }
        return expiryTime;
    }

    @Override
    public boolean startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        this.cancelExpiryTimer(e);
        long absTime = Math.abs(nextRefreshTime);
        e.setRefreshProbationNextRefreshTime(absTime);
        e.setNextRefreshTime(6L);
        if (nextRefreshTime != Long.MAX_VALUE) {
            e.setTask(new Tasks.RefreshExpireTimerTask<K, V>().to(this.target, e));
            this.scheduleTask(absTime, e);
        }
        return false;
    }

    @Override
    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        this.scheduleFinalExpireWithOptionalRefresh(e, e.getNextRefreshTime());
    }

    void scheduleFinalExpireWithOptionalRefresh(Entry<K, V> e, long t) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
        } else {
            e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
        }
        this.scheduleTask(t, e);
    }

    void scheduleTask(long nextRefreshTime, Entry<K, V> e) {
        try {
            this.timer.schedule(e.getTask(), nextRefreshTime);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void cancelExpiryTimer(Entry<K, V> e) {
        Tasks tsk = (Tasks)e.getTask();
        if (tsk != null) {
            this.timer.cancel(tsk);
        }
        e.setTask(null);
    }

    @Override
    public long getExpiryAfterWriteTicks() {
        return this.expiryTicks;
    }

    static <K, V> long calcNextRefreshTime(K key, V value, long now, CacheEntry<K, V> entry, ExpiryPolicy<K, V> policy, long maxLinger, boolean sharpExpiryEnabled) {
        long t;
        if (maxLinger == 0L) {
            return 0L;
        }
        if (policy != null) {
            long t2 = policy.calculateExpiryTime(key, value, now, entry);
            return StaticTiming.limitExpiryToMaxLinger(now, maxLinger, t2, sharpExpiryEnabled);
        }
        if (maxLinger < Long.MAX_VALUE && (t = maxLinger + now) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    static long limitExpiryToMaxLinger(long now, long maxLinger, long requestedExpiryTime, boolean sharpExpiryEnabled) {
        if (sharpExpiryEnabled && requestedExpiryTime > 0L && requestedExpiryTime < Long.MAX_VALUE) {
            requestedExpiryTime = -requestedExpiryTime;
        }
        return Expiry.mixTimeSpanAndPointInTime((long)now, (long)maxLinger, (long)requestedExpiryTime);
    }

    static {
        long millis = Long.parseLong(System.getProperty("org.cache2k.sharpExpirySafetyGapMillis", "27127"));
        SHARP_EXPIRY_SAFETY_GAP = Duration.ofMillis(millis);
    }
}

