/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cache2k.CacheClosedException;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.timing.Timer;
import org.cache2k.core.timing.TimerStructure;
import org.cache2k.core.timing.TimerTask;
import org.cache2k.core.timing.TimerWheels;
import org.cache2k.operation.Scheduler;
import org.cache2k.operation.TimeReference;

public class DefaultTimer
implements Timer {
    public static final long DEFAULT_TIMER_LAG_MILLIS = 1003L;
    public static final int DEFAULT_SLOTS_PER_WHEEL = 921;
    private final Lock lock = new ReentrantLock();
    private final TimeReference clock;
    private final Scheduler scheduler;
    private final TimerStructure structure;
    private final long lagTicks;
    private long nextScheduled = Long.MAX_VALUE;
    private final Runnable timerAction = new Runnable(){

        @Override
        public void run() {
            DefaultTimer.this.timeReachedEvent(DefaultTimer.this.clock.ticks());
        }
    };

    public DefaultTimer(TimeReference clock, Scheduler scheduler) {
        this(clock, scheduler, 1003L);
    }

    public DefaultTimer(TimeReference clock, Scheduler scheduler, long lagTicks) {
        this(clock, scheduler, lagTicks, 921);
    }

    public DefaultTimer(TimeReference c, Scheduler scheduler, long lagTicks, int steps) {
        this.structure = new TimerWheels(c.ticks() + 1L, lagTicks + 1L, steps);
        this.lagTicks = lagTicks;
        this.clock = c;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(TimerTask task, long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (!task.isUnscheduled()) {
            throw new IllegalStateException("scheduled already");
        }
        if (time == 0L) {
            this.executeImmediately(task);
            return;
        }
        this.lock.lock();
        try {
            long slotTime = this.structure.schedule(task, time);
            if (slotTime != 0L) {
                this.rescheduleEventually(slotTime);
                return;
            }
            this.executeImmediately(task);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeImmediately(TimerTask task) {
        task.markForImmediateExecution();
        this.scheduler.execute((Runnable)task);
    }

    @Override
    public void cancel(TimerTask t) {
        this.lock.lock();
        try {
            t.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getLagTicks() {
        return this.lagTicks;
    }

    @Override
    public void cancelAll() {
        this.lock.lock();
        try {
            this.structure.cancelAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
        this.cancelAll();
        closeContext.closeCustomization(this.scheduler, "scheduler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeReachedEvent(long currentTime) {
        while (true) {
            TimerTask task;
            this.lock.lock();
            try {
                task = this.structure.removeNextToRun(currentTime);
            }
            finally {
                this.lock.unlock();
            }
            if (task == null) break;
            task.execute();
            task.action();
        }
        this.lock.lock();
        try {
            long nextTime = this.structure.nextRun();
            this.scheduleNextWakeup(nextTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void scheduleNextWakeup(long time) {
        boolean alreadyScheduled;
        boolean noMoreEvents = time == Long.MAX_VALUE;
        boolean bl = alreadyScheduled = this.nextScheduled == time;
        if (noMoreEvents || alreadyScheduled) {
            this.nextScheduled = Long.MAX_VALUE;
            return;
        }
        this.scheduleNext(time);
    }

    void rescheduleEventually(long time) {
        if (time >= this.nextScheduled) {
            return;
        }
        this.scheduleNext(time);
    }

    private void scheduleNext(long time) {
        this.nextScheduled = time;
        try {
            this.scheduler.schedule(this.timerAction, this.clock.ticksToMillisCeiling(this.nextScheduled - this.clock.ticks()));
        }
        catch (RejectedExecutionException ex) {
            throw new CacheClosedException();
        }
    }
}

