/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cache2k.core.BulkResultCollector;
import org.cache2k.io.CacheLoaderException;

public class OperationCompletion<K> {
    private final CompletableFuture<Void> future = new CompletableFuture();
    private final int initialCount;
    private volatile int countDown;
    private volatile int exceptionCount;
    private volatile Throwable exception;
    static final AtomicIntegerFieldUpdater<OperationCompletion> BULK_OP_COUNT = AtomicIntegerFieldUpdater.newUpdater(OperationCompletion.class, "countDown");
    static final AtomicIntegerFieldUpdater<OperationCompletion> BULK_OP_EXCEPTION_COUNT = AtomicIntegerFieldUpdater.newUpdater(OperationCompletion.class, "exceptionCount");
    static final AtomicReferenceFieldUpdater<OperationCompletion, Throwable> BULK_OP_EXCEPTION = AtomicReferenceFieldUpdater.newUpdater(OperationCompletion.class, Throwable.class, "exception");

    public OperationCompletion(Set<K> keys) {
        this.initialCount = this.countDown = keys.size();
    }

    public void complete(K key, Throwable exception) {
        int i;
        if (exception != null) {
            BULK_OP_EXCEPTION_COUNT.incrementAndGet(this);
            BULK_OP_EXCEPTION.compareAndSet(this, null, exception);
        }
        if ((i = BULK_OP_COUNT.decrementAndGet(this)) == 0) {
            this.allCompleted();
        }
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    private void allCompleted() {
        if (this.exceptionCount == 0) {
            this.future.complete(null);
            return;
        }
        CacheLoaderException bulkLoaderException = BulkResultCollector.createBulkLoaderException(this.exceptionCount, this.initialCount, this.exception);
        this.future.completeExceptionally((Throwable)bulkLoaderException);
    }
}

