/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.text.DecimalFormat;
import java.time.Instant;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.HeapCache;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.eviction.EvictionMetrics;
import org.cache2k.core.util.Util;

class CacheBaseInfo
implements InternalCacheInfo {
    private final CommonMetrics metrics;
    private final HeapCache heapCache;
    private final InternalCache cache;
    private final long size;
    private final long infoCreatedTime;
    private final long missCnt;
    private final long heapHitCnt;
    private final long correctedPutCnt;
    private final IntegrityState integrityState;
    private final long totalLoadCnt;
    private final EvictionMetrics evictionMetrics;
    private final long clearedTime;
    private final long keyMutationCnt;
    private final long clearRemovedCnt;
    private final long clearCnt;
    private final long internalExceptionCnt;
    private final String evictionToString;

    CacheBaseInfo(HeapCache heapCache, InternalCache userCache, long now) {
        this.infoCreatedTime = now;
        this.cache = userCache;
        this.heapCache = heapCache;
        this.metrics = heapCache.metrics;
        this.evictionMetrics = heapCache.eviction.getMetrics();
        this.clearedTime = heapCache.clearedTime;
        this.keyMutationCnt = heapCache.keyMutationCnt;
        this.clearRemovedCnt = heapCache.clearRemovedCnt;
        this.clearCnt = heapCache.clearCnt;
        this.internalExceptionCnt = heapCache.internalExceptionCnt;
        if (Thread.holdsLock(heapCache.lock)) {
            this.evictionToString = heapCache.eviction.toString();
            this.integrityState = heapCache.getIntegrityState();
        } else {
            this.integrityState = null;
            this.evictionToString = null;
        }
        this.size = this.evictionMetrics.getSize();
        this.missCnt = this.metrics.getReadThroughCount() + this.metrics.getExplicitLoadCount() + this.metrics.getPeekHitNotFreshCount() + this.metrics.getPeekMissCount();
        this.heapHitCnt = this.metrics.getHeapHitCount();
        this.correctedPutCnt = this.metrics.getPutNewEntryCount() + this.metrics.getPutHitCount();
        this.totalLoadCnt = this.metrics.getReadThroughCount() + this.metrics.getExplicitLoadCount() + this.metrics.getRefreshCount();
    }

    String percentString(double d) {
        String s = Double.toString(d);
        return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
    }

    @Override
    public String getName() {
        return this.heapCache.name;
    }

    @Override
    public String getImplementation() {
        return this.cache.getClass().getSimpleName();
    }

    @Override
    public long getExplicitLoadCount() {
        return this.metrics.getExplicitLoadCount();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getHeapCapacity() {
        return this.evictionMetrics.getMaxSize();
    }

    @Override
    public long getMaximumWeight() {
        return this.evictionMetrics.getMaxWeight();
    }

    @Override
    public long getTotalWeight() {
        return this.evictionMetrics.getTotalWeight();
    }

    @Override
    public long getEvictedWeight() {
        return this.evictionMetrics.getEvictedWeight();
    }

    @Override
    public long getScanCount() {
        return this.evictionMetrics.getScanCount();
    }

    @Override
    public long getGetCount() {
        return this.heapHitCnt + this.metrics.getPeekMissCount() + this.metrics.getReadThroughCount() - this.metrics.getHeapHitButNoReadCount();
    }

    @Override
    public long getMissCount() {
        return this.missCnt;
    }

    @Override
    public long getNewEntryCount() {
        return this.evictionMetrics.getNewEntryCount();
    }

    @Override
    public long getHeapHitCount() {
        return this.heapHitCnt;
    }

    @Override
    public long getLoadCount() {
        return this.totalLoadCnt;
    }

    @Override
    public long getRefreshCount() {
        return this.metrics.getRefreshCount();
    }

    @Override
    public long getInternalExceptionCount() {
        return this.internalExceptionCnt;
    }

    @Override
    public long getRefreshRejectedCount() {
        return this.metrics.getRefreshRejectedCount();
    }

    @Override
    public long getSuppressedExceptionCount() {
        return this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.metrics.getLoadExceptionCount() + this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getRefreshedHitCount() {
        return this.metrics.getRefreshedHitCount();
    }

    @Override
    public long getExpiredCount() {
        return this.evictionMetrics.getExpiredRemovedCount() + this.metrics.getExpiredKeptCount();
    }

    @Override
    public long getEvictedCount() {
        return this.evictionMetrics.getEvictedCount();
    }

    @Override
    public int getEvictionRunningCount() {
        return this.evictionMetrics.getEvictionRunningCount();
    }

    @Override
    public long getRemoveCount() {
        return this.evictionMetrics.getRemovedCount();
    }

    @Override
    public long getPutCount() {
        return this.correctedPutCnt;
    }

    @Override
    public long getGoneSpinCount() {
        return this.metrics.getGoneSpinCount();
    }

    @Override
    public long getKeyMutationCount() {
        return this.keyMutationCnt;
    }

    @Override
    public long getTimerEventCount() {
        return this.metrics.getTimerEventCount();
    }

    @Override
    public double getHitRate() {
        long cnt = this.getGetCount();
        return cnt == 0L ? 0.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
    }

    @Override
    public String getHitRateString() {
        return this.percentString(this.getHitRate());
    }

    @Override
    public double getMillisPerLoad() {
        return this.getLoadCount() == 0L ? 0.0 : (double)this.getLoadMillis() * 1.0 / (double)this.getLoadCount();
    }

    @Override
    public long getLoadMillis() {
        return this.cache.getClock().ticksToMillisCeiling(this.metrics.getLoadTicks());
    }

    @Override
    public boolean isIntegrityFailure() {
        return this.integrityState.isFailure();
    }

    @Override
    public String getFailedIntegrityChecks() {
        return this.integrityState.getFailingChecks();
    }

    @Override
    public Instant getStartedTime() {
        return this.instantOrNull(this.heapCache.startedTime);
    }

    @Override
    public Instant getClearedTime() {
        return this.instantOrNull(this.clearedTime);
    }

    @Override
    public Instant getInfoCreatedTime() {
        return this.instantOrNull(this.infoCreatedTime);
    }

    Instant instantOrNull(long ticks) {
        return ticks == 0L ? null : this.cache.getClock().ticksToInstant(ticks);
    }

    private static String timestampToString(Instant t) {
        if (t == null) {
            return "-";
        }
        return Util.formatTime(t);
    }

    @Override
    public long getClearCount() {
        return this.clearCnt;
    }

    @Override
    public long getClearedEntriesCount() {
        return this.clearRemovedCnt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache(");
        CacheManagerImpl cm = (CacheManagerImpl)this.cache.getCacheManager();
        sb.append("name=").append(this.cache.getQualifiedName()).append(", ").append("size=").append(this.getSize()).append(", ");
        if (this.getHeapCapacity() >= 0L) {
            sb.append("capacity=").append(this.getHeapCapacity() != Long.MAX_VALUE ? Long.valueOf(this.getHeapCapacity()) : "unlimited").append(", ");
        } else {
            sb.append("maximumWeight=").append(this.getMaximumWeight() != Long.MAX_VALUE ? Long.valueOf(this.getMaximumWeight()) : "unlimited").append(", ");
            sb.append("currentWeight=").append(this.getTotalWeight()).append(", ");
        }
        sb.append("get=").append(this.getGetCount()).append(", ").append("miss=").append(this.getMissCount()).append(", ").append("put=").append(this.getPutCount()).append(", ").append("load=").append(this.getLoadCount()).append(", ").append("reload=").append(this.getExplicitLoadCount()).append(", ").append("heapHit=").append(this.getHeapHitCount()).append(", ").append("refresh=").append(this.getRefreshCount()).append(", ").append("refreshRejected=").append(this.getRefreshRejectedCount()).append(", ").append("refreshedHit=").append(this.getRefreshedHitCount()).append(", ").append("loadException=").append(this.getLoadExceptionCount()).append(", ").append("suppressedException=").append(this.getSuppressedExceptionCount()).append(", ").append("new=").append(this.getNewEntryCount()).append(", ").append("expire=").append(this.getExpiredCount()).append(", ").append("remove=").append(this.getRemoveCount()).append(", ").append("clear=").append(this.getClearCount()).append(", ").append("removeByClear=").append(this.getClearedEntriesCount()).append(", ").append("evict=").append(this.getEvictedCount()).append(", ").append("timer=").append(this.getTimerEventCount()).append(", ").append("goneSpin=").append(this.getGoneSpinCount()).append(", ").append("hitRate=").append(this.getHitRateString()).append(", ").append("msecs/load=").append(CacheBaseInfo.formatMillisPerLoad(this.getMillisPerLoad())).append(", ").append("created=").append(CacheBaseInfo.timestampToString(this.getStartedTime())).append(", ").append("cleared=").append(CacheBaseInfo.timestampToString(this.getClearedTime())).append(", ").append("infoCreated=").append(CacheBaseInfo.timestampToString(this.getInfoCreatedTime())).append(", ").append("impl=").append(this.getImplementation()).append(", ").append("evictionRunning=").append(this.getEvictionRunningCount()).append(", ").append("keyMutation=").append(this.getKeyMutationCount()).append(", ").append("evictionScanCount=").append(this.evictionMetrics.getScanCount()).append(", ").append("internalException=").append(this.getInternalExceptionCount()).append(", ").append("version=").append(cm.getProvider().getVersion());
        if (this.evictionToString != null && !this.evictionToString.isEmpty()) {
            sb.append(", ");
            sb.append(this.evictionToString);
        }
        sb.append(")");
        return sb.toString();
    }

    static String formatMillisPerLoad(double val) {
        if (val < 0.0) {
            return "-";
        }
        DecimalFormat f = new DecimalFormat("#.###");
        return f.format(val);
    }
}

