/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.ShortIndexer;

public class ShortArrayIndexer
extends ShortIndexer {
    protected short[] array;

    public ShortArrayIndexer(short[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public ShortArrayIndexer(short[] array, long ... sizes) {
        this(array, sizes, ShortArrayIndexer.strides(sizes));
    }

    public ShortArrayIndexer(short[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public short get(long i) {
        return this.array[(int)i];
    }

    @Override
    public ShortIndexer get(long i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public short get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public ShortIndexer get(long i, long j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public short get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public short get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public ShortIndexer get(long[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, short s) {
        this.array[(int)i] = s;
        return this;
    }

    @Override
    public ShortIndexer put(long i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, short s) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = s;
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, long k, short s) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = s;
        return this;
    }

    @Override
    public ShortIndexer put(long[] indices, short s) {
        this.array[(int)this.index((long[])indices)] = s;
        return this;
    }

    @Override
    public ShortIndexer put(long[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

