/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.aruco;

import java.util.ArrayList;
import java.util.List;
import org.opencv.aruco.Dictionary;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint3f;
import org.opencv.utils.Converters;

public class Board {
    protected final long nativeObj;

    protected Board(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Board __fromPtr__(long addr) {
        return new Board(addr);
    }

    public static Board create(List<Mat> objPoints, Dictionary dictionary, Mat ids) {
        Mat objPoints_mat = Converters.vector_Mat_to_Mat(objPoints);
        Board retVal = Board.__fromPtr__(Board.create_0(objPoints_mat.nativeObj, dictionary.getNativeObjAddr(), ids.nativeObj));
        return retVal;
    }

    public List<MatOfPoint3f> get_objPoints() {
        ArrayList<MatOfPoint3f> retVal = new ArrayList<MatOfPoint3f>();
        Mat retValMat = new Mat(Board.get_objPoints_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point3f(retValMat, retVal);
        return retVal;
    }

    public Dictionary get_dictionary() {
        Dictionary retVal = Dictionary.__fromPtr__(Board.get_dictionary_0(this.nativeObj));
        return retVal;
    }

    public MatOfInt get_ids() {
        MatOfInt retVal = MatOfInt.fromNativeAddr(Board.get_ids_0(this.nativeObj));
        return retVal;
    }

    protected void finalize() throws Throwable {
        Board.delete(this.nativeObj);
    }

    private static native long create_0(long var0, long var2, long var4);

    private static native long get_objPoints_0(long var0);

    private static native long get_dictionary_0(long var0);

    private static native long get_ids_0(long var0);

    private static native void delete(long var0);
}

