// Targeted by JavaCPP version 1.4.3: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;

public class opencv_xphoto extends org.bytedeco.javacpp.presets.opencv_xphoto {
    static { Loader.load(); }

// Parsed from <opencv2/xphoto.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_XPHOTO_HPP__
// #define __OPENCV_XPHOTO_HPP__

/** \defgroup xphoto Additional photo processing algorithms
*/

// #include "xphoto/inpainting.hpp"
// #include "xphoto/white_balance.hpp"
// #include "xphoto/dct_image_denoising.hpp"
// #include "xphoto/bm3d_image_denoising.hpp"
// #endif


// Parsed from <opencv2/xphoto/inpainting.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_INPAINTING_HPP__
// #define __OPENCV_INPAINTING_HPP__

/** \file
\date Jul 22, 2014
@author Yury Gitman
*/

// #include <opencv2/core.hpp>

/** \addtogroup xphoto
 *  \{
     <p>
     *  various inpainting algorithms */
    /** enum cv::xphoto::InpaintTypes */
    public static final int
        /** This algorithm searches for dominant correspondences (transformations) of
        image patches and tries to seamlessly fill-in the area to be inpainted using this
        transformations */
        INPAINT_SHIFTMAP = 0;

    /** \brief The function implements different single-image inpainting algorithms.
    <p>
    See the original paper \cite He2012 for details.
    <p>
    @param src source image, it could be of any type and any number of channels from 1 to 4. In case of
    3- and 4-channels images the function expect them in CIELab colorspace or similar one, where first
    color component shows intensity, while second and third shows colors. Nonetheless you can try any
    colorspaces.
    @param mask mask (CV_8UC1), where non-zero pixels indicate valid image area, while zero pixels
    indicate area to be inpainted
    @param dst destination image
    @param algorithmType see xphoto::InpaintTypes
    */
    @Namespace("cv::xphoto") public static native void inpaint(@Const @ByRef Mat src, @Const @ByRef Mat mask, @ByRef Mat dst, int algorithmType);

/** \} */




// #endif // __OPENCV_INPAINTING_HPP__


// Parsed from <opencv2/xphoto/white_balance.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_SIMPLE_COLOR_BALANCE_HPP__
// #define __OPENCV_SIMPLE_COLOR_BALANCE_HPP__

/** \file
\date Jun 26, 2014
@author Yury Gitman
*/

// #include <opencv2/core.hpp>

/** \addtogroup xphoto
 *  \{
<p>
/** \brief The base class for auto white balance algorithms.
 */
@Namespace("cv::xphoto") public static class WhiteBalancer extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public WhiteBalancer(Pointer p) { super(p); }

    /** \brief Applies white balancing to the input image
    <p>
    @param src Input image
    @param dst White balancing result
    \sa cvtColor, equalizeHist
    */
    public native void balanceWhite(@ByVal Mat src, @ByVal Mat dst);
    public native void balanceWhite(@ByVal UMat src, @ByVal UMat dst);
    public native void balanceWhite(@ByVal GpuMat src, @ByVal GpuMat dst);
}

/** \brief A simple white balance algorithm that works by independently stretching
    each of the input image channels to the specified range. For increased robustness
    it ignores the top and bottom \f$p\%\f$ of pixel values.
 */
@Namespace("cv::xphoto") public static class SimpleWB extends WhiteBalancer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SimpleWB(Pointer p) { super(p); }

    /** \brief Input image range minimum value
    @see setInputMin */
    public native float getInputMin();
    /** \copybrief getInputMin @see getInputMin */
    public native void setInputMin(float val);

    /** \brief Input image range maximum value
    @see setInputMax */
    public native float getInputMax();
    /** \copybrief getInputMax @see getInputMax */
    public native void setInputMax(float val);

    /** \brief Output image range minimum value
    @see setOutputMin */
    public native float getOutputMin();
    /** \copybrief getOutputMin @see getOutputMin */
    public native void setOutputMin(float val);

    /** \brief Output image range maximum value
    @see setOutputMax */
    public native float getOutputMax();
    /** \copybrief getOutputMax @see getOutputMax */
    public native void setOutputMax(float val);

    /** \brief Percent of top/bottom values to ignore
    @see setP */
    public native float getP();
    /** \copybrief getP @see getP */
    public native void setP(float val);
}

/** \brief Creates an instance of SimpleWB
 */
@Namespace("cv::xphoto") public static native @Ptr SimpleWB createSimpleWB();

/** \brief Gray-world white balance algorithm
<p>
This algorithm scales the values of pixels based on a
gray-world assumption which states that the average of all channels
should result in a gray image.
<p>
It adds a modification which thresholds pixels based on their
saturation value and only uses pixels below the provided threshold in
finding average pixel values.
<p>
Saturation is calculated using the following for a 3-channel RGB image per
pixel I and is in the range [0, 1]:
<p>
\f[ \texttt{Saturation} [I] = \frac{\textrm{max}(R,G,B) - \textrm{min}(R,G,B)
}{\textrm{max}(R,G,B)} \f]
<p>
A threshold of 1 means that all pixels are used to white-balance, while a
threshold of 0 means no pixels are used. Lower thresholds are useful in
white-balancing saturated images.
<p>
Currently supports images of type \ref CV_8UC3 and \ref CV_16UC3.
 */
@Namespace("cv::xphoto") public static class GrayworldWB extends WhiteBalancer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GrayworldWB(Pointer p) { super(p); }

    /** \brief Maximum saturation for a pixel to be included in the
        gray-world assumption
    @see setSaturationThreshold */
    public native float getSaturationThreshold();
    /** \copybrief getSaturationThreshold @see getSaturationThreshold */
    public native void setSaturationThreshold(float val);
}

/** \brief Creates an instance of GrayworldWB
 */
@Namespace("cv::xphoto") public static native @Ptr GrayworldWB createGrayworldWB();

/** \brief More sophisticated learning-based automatic white balance algorithm.
<p>
As \ref GrayworldWB, this algorithm works by applying different gains to the input
image channels, but their computation is a bit more involved compared to the
simple gray-world assumption. More details about the algorithm can be found in
\cite Cheng2015 .
<p>
To mask out saturated pixels this function uses only pixels that satisfy the
following condition:
<p>
\f[ \frac{\textrm{max}(R,G,B)}{\texttt{range_max_val}} < \texttt{saturation_thresh} \f]
<p>
Currently supports images of type \ref CV_8UC3 and \ref CV_16UC3.
 */
@Namespace("cv::xphoto") public static class LearningBasedWB extends WhiteBalancer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LearningBasedWB(Pointer p) { super(p); }

    /** \brief Implements the feature extraction part of the algorithm.
    <p>
    In accordance with \cite Cheng2015 , computes the following features for the input image:
    1. Chromaticity of an average (R,G,B) tuple
    2. Chromaticity of the brightest (R,G,B) tuple (while ignoring saturated pixels)
    3. Chromaticity of the dominant (R,G,B) tuple (the one that has the highest value in the RGB histogram)
    4. Mode of the chromaticity palette, that is constructed by taking 300 most common colors according to
       the RGB histogram and projecting them on the chromaticity plane. Mode is the most high-density point
       of the palette, which is computed by a straightforward fixed-bandwidth kernel density estimator with
       a Epanechnikov kernel function.
    <p>
    @param src Input three-channel image (BGR color space is assumed).
    @param dst An array of four (r,g) chromaticity tuples corresponding to the features listed above.
    */
    public native void extractSimpleFeatures(@ByVal Mat src, @ByVal Mat dst);
    public native void extractSimpleFeatures(@ByVal UMat src, @ByVal UMat dst);
    public native void extractSimpleFeatures(@ByVal GpuMat src, @ByVal GpuMat dst);

    /** \brief Maximum possible value of the input image (e.g. 255 for 8 bit images,
               4095 for 12 bit images)
    @see setRangeMaxVal */
    public native int getRangeMaxVal();
    /** \copybrief getRangeMaxVal @see getRangeMaxVal */
    public native void setRangeMaxVal(int val);

    /** \brief Threshold that is used to determine saturated pixels, i.e. pixels where at least one of the
        channels exceeds \f$\texttt{saturation_threshold}\times\texttt{range_max_val}\f$ are ignored.
    @see setSaturationThreshold */
    public native float getSaturationThreshold();
    /** \copybrief getSaturationThreshold @see getSaturationThreshold */
    public native void setSaturationThreshold(float val);

    /** \brief Defines the size of one dimension of a three-dimensional RGB histogram that is used internally
        by the algorithm. It often makes sense to increase the number of bins for images with higher bit depth
        (e.g. 256 bins for a 12 bit image).
    @see setHistBinNum */
    public native int getHistBinNum();
    /** \copybrief getHistBinNum @see getHistBinNum */
    public native void setHistBinNum(int val);
}

/** \brief Creates an instance of LearningBasedWB
<p>
@param path_to_model Path to a .yml file with the model. If not specified, the default model is used
 */
@Namespace("cv::xphoto") public static native @Ptr LearningBasedWB createLearningBasedWB(@Str BytePointer path_to_model/*=cv::String()*/);
@Namespace("cv::xphoto") public static native @Ptr LearningBasedWB createLearningBasedWB();
@Namespace("cv::xphoto") public static native @Ptr LearningBasedWB createLearningBasedWB(@Str String path_to_model/*=cv::String()*/);

/** \brief Implements an efficient fixed-point approximation for applying channel gains, which is
    the last step of multiple white balance algorithms.
<p>
@param src Input three-channel image in the BGR color space (either CV_8UC3 or CV_16UC3)
@param dst Output image of the same size and type as src.
@param gainB gain for the B channel
@param gainG gain for the G channel
@param gainR gain for the R channel
*/
@Namespace("cv::xphoto") public static native void applyChannelGains(@ByVal Mat src, @ByVal Mat dst, float gainB, float gainG, float gainR);
@Namespace("cv::xphoto") public static native void applyChannelGains(@ByVal UMat src, @ByVal UMat dst, float gainB, float gainG, float gainR);
@Namespace("cv::xphoto") public static native void applyChannelGains(@ByVal GpuMat src, @ByVal GpuMat dst, float gainB, float gainG, float gainR);
/** \} */



// #endif // __OPENCV_SIMPLE_COLOR_BALANCE_HPP__


// Parsed from <opencv2/xphoto/dct_image_denoising.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_DCT_IMAGE_DENOISING_HPP__
// #define __OPENCV_DCT_IMAGE_DENOISING_HPP__

/** \file
\date Jun 26, 2014
@author Yury Gitman
*/

// #include <opencv2/core.hpp>

/** \addtogroup xphoto
 *  \{
    <p>
    /** \brief The function implements simple dct-based denoising
    <p>
    <http://www.ipol.im/pub/art/2011/ys-dct/>.
    @param src source image
    @param dst destination image
    @param sigma expected noise standard deviation
    @param psize size of block side where dct is computed
    <p>
    \sa
       fastNlMeansDenoising
     */
    @Namespace("cv::xphoto") public static native void dctDenoising(@Const @ByRef Mat src, @ByRef Mat dst, double sigma, int psize/*=16*/);
    @Namespace("cv::xphoto") public static native void dctDenoising(@Const @ByRef Mat src, @ByRef Mat dst, double sigma);

/** \} */




// #endif // __OPENCV_DCT_IMAGE_DENOISING_HPP__


// Parsed from <opencv2/xphoto/bm3d_image_denoising.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_BM3D_IMAGE_DENOISING_HPP__
// #define __OPENCV_BM3D_IMAGE_DENOISING_HPP__

/** \file
\date Jul 19, 2016
@author Bartek Pawlik
*/

// #include <opencv2/core.hpp>
        /** \addtogroup xphoto
         *  \{
         <p>
         *  BM3D transform types */
        /** enum cv::xphoto::TransformTypes */
        public static final int
            /** Un-normalized Haar transform */
            HAAR = 0;

        /** BM3D algorithm steps */
        /** enum cv::xphoto::Bm3dSteps */
        public static final int
            /** Execute all steps of the algorithm */
            BM3D_STEPALL = 0,
            /** Execute only first step of the algorithm */
            BM3D_STEP1 = 1,
            /** Execute only second step of the algorithm */
            BM3D_STEP2 = 2;

        /** \brief Performs image denoising using the Block-Matching and 3D-filtering algorithm
        <http://www.cs.tut.fi/~foi/GCF-BM3D/BM3D_TIP_2007.pdf> with several computational
        optimizations. Noise expected to be a gaussian white noise.
        <p>
        @param src Input 8-bit or 16-bit 1-channel image.
        @param dstStep1 Output image of the first step of BM3D with the same size and type as src.
        @param dstStep2 Output image of the second step of BM3D with the same size and type as src.
        @param h Parameter regulating filter strength. Big h value perfectly removes noise but also
        removes image details, smaller h value preserves details but also preserves some noise.
        @param templateWindowSize Size in pixels of the template patch that is used for block-matching.
        Should be power of 2.
        @param searchWindowSize Size in pixels of the window that is used to perform block-matching.
        Affect performance linearly: greater searchWindowsSize - greater denoising time.
        Must be larger than templateWindowSize.
        @param blockMatchingStep1 Block matching threshold for the first step of BM3D (hard thresholding),
        i.e. maximum distance for which two blocks are considered similar.
        Value expressed in euclidean distance.
        @param blockMatchingStep2 Block matching threshold for the second step of BM3D (Wiener filtering),
        i.e. maximum distance for which two blocks are considered similar.
        Value expressed in euclidean distance.
        @param groupSize Maximum size of the 3D group for collaborative filtering.
        @param slidingStep Sliding step to process every next reference block.
        @param beta Kaiser window parameter that affects the sidelobe attenuation of the transform of the
        window. Kaiser window is used in order to reduce border effects. To prevent usage of the window,
        set beta to zero.
        @param normType Norm used to calculate distance between blocks. L2 is slower than L1
        but yields more accurate results.
        @param step Step of BM3D to be executed. Possible variants are: step 1, step 2, both steps.
        @param transformType Type of the orthogonal transform used in collaborative filtering step.
        Currently only Haar transform is supported.
        <p>
        This function expected to be applied to grayscale images. Advanced usage of this function
        can be manual denoising of colored image in different colorspaces.
        <p>
        \sa
        fastNlMeansDenoising
        */
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal Mat src,
                    @ByVal Mat dstStep1,
                    @ByVal Mat dstStep2,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal Mat src,
                    @ByVal Mat dstStep1,
                    @ByVal Mat dstStep2);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal UMat src,
                    @ByVal UMat dstStep1,
                    @ByVal UMat dstStep2,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal UMat src,
                    @ByVal UMat dstStep1,
                    @ByVal UMat dstStep2);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal GpuMat src,
                    @ByVal GpuMat dstStep1,
                    @ByVal GpuMat dstStep2,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal GpuMat src,
                    @ByVal GpuMat dstStep1,
                    @ByVal GpuMat dstStep2);

        /** \brief Performs image denoising using the Block-Matching and 3D-filtering algorithm
        <http://www.cs.tut.fi/~foi/GCF-BM3D/BM3D_TIP_2007.pdf> with several computational
        optimizations. Noise expected to be a gaussian white noise.
        <p>
        @param src Input 8-bit or 16-bit 1-channel image.
        @param dst Output image with the same size and type as src.
        @param h Parameter regulating filter strength. Big h value perfectly removes noise but also
        removes image details, smaller h value preserves details but also preserves some noise.
        @param templateWindowSize Size in pixels of the template patch that is used for block-matching.
        Should be power of 2.
        @param searchWindowSize Size in pixels of the window that is used to perform block-matching.
        Affect performance linearly: greater searchWindowsSize - greater denoising time.
        Must be larger than templateWindowSize.
        @param blockMatchingStep1 Block matching threshold for the first step of BM3D (hard thresholding),
        i.e. maximum distance for which two blocks are considered similar.
        Value expressed in euclidean distance.
        @param blockMatchingStep2 Block matching threshold for the second step of BM3D (Wiener filtering),
        i.e. maximum distance for which two blocks are considered similar.
        Value expressed in euclidean distance.
        @param groupSize Maximum size of the 3D group for collaborative filtering.
        @param slidingStep Sliding step to process every next reference block.
        @param beta Kaiser window parameter that affects the sidelobe attenuation of the transform of the
        window. Kaiser window is used in order to reduce border effects. To prevent usage of the window,
        set beta to zero.
        @param normType Norm used to calculate distance between blocks. L2 is slower than L1
        but yields more accurate results.
        @param step Step of BM3D to be executed. Allowed are only BM3D_STEP1 and BM3D_STEPALL.
        BM3D_STEP2 is not allowed as it requires basic estimate to be present.
        @param transformType Type of the orthogonal transform used in collaborative filtering step.
        Currently only Haar transform is supported.
        <p>
        This function expected to be applied to grayscale images. Advanced usage of this function
        can be manual denoising of colored image in different colorspaces.
        <p>
        \sa
        fastNlMeansDenoising
        */
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal Mat src,
                    @ByVal Mat dst,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal Mat src,
                    @ByVal Mat dst);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal UMat src,
                    @ByVal UMat dst,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal UMat src,
                    @ByVal UMat dst);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal GpuMat src,
                    @ByVal GpuMat dst,
                    float h/*=1*/,
                    int templateWindowSize/*=4*/,
                    int searchWindowSize/*=16*/,
                    int blockMatchingStep1/*=2500*/,
                    int blockMatchingStep2/*=400*/,
                    int groupSize/*=8*/,
                    int slidingStep/*=1*/,
                    float beta/*=2.0f*/,
                    int normType/*=cv::NORM_L2*/,
                    int step/*=cv::xphoto::BM3D_STEPALL*/,
                    int transformType/*=cv::xphoto::HAAR*/);
        @Namespace("cv::xphoto") public static native void bm3dDenoising(
                    @ByVal GpuMat src,
                    @ByVal GpuMat dst);
        /** \} */
    


// #endif // __OPENCV_BM3D_IMAGE_DENOISING_HPP__


}
