// Targeted by JavaCPP version 1.4.3: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;

public class opencv_phase_unwrapping extends org.bytedeco.javacpp.presets.opencv_phase_unwrapping {
    static { Loader.load(); }

// Parsed from <opencv2/phase_unwrapping.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
 //
 //  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 //
 //  By downloading, copying, installing or using the software you agree to this license.
 //  If you do not agree to this license, do not download, install,
 //  copy or use the software.
 //
 //
 //                           License Agreement
 //                For Open Source Computer Vision Library
 //
 // Copyright (C) 2015, OpenCV Foundation, all rights reserved.
 // Third party copyrights are property of their respective owners.
 //
 // Redistribution and use in source and binary forms, with or without modification,
 // are permitted provided that the following conditions are met:
 //
 //   * Redistribution's of source code must retain the above copyright notice,
 //     this list of conditions and the following disclaimer.
 //
 //   * Redistribution's in binary form must reproduce the above copyright notice,
 //     this list of conditions and the following disclaimer in the documentation
 //     and/or other materials provided with the distribution.
 //
 //   * The name of the copyright holders may not be used to endorse or promote products
 //     derived from this software without specific prior written permission.
 //
 // This software is provided by the copyright holders and contributors "as is" and
 // any express or implied warranties, including, but not limited to, the implied
 // warranties of merchantability and fitness for a particular purpose are disclaimed.
 // In no event shall the Intel Corporation or contributors be liable for any direct,
 // indirect, incidental, special, exemplary, or consequential damages
 // (including, but not limited to, procurement of substitute goods or services;
 // loss of use, data, or profits; or business interruption) however caused
 // and on any theory of liability, whether in contract, strict liability,
 // or tort (including negligence or otherwise) arising in any way out of
 // the use of this software, even if advised of the possibility of such damage.
 //
 //M*/

// #include "opencv2/phase_unwrapping/phase_unwrapping.hpp"
// #include "opencv2/phase_unwrapping/histogramphaseunwrapping.hpp"

/** \defgroup phase_unwrapping Phase Unwrapping API
<p>
Two-dimensional phase unwrapping is found in different applications like terrain elevation estimation
in synthetic aperture radar (SAR), field mapping in magnetic resonance imaging or as a way of finding
corresponding pixels in structured light reconstruction with sinusoidal patterns.
<p>
Given a phase map, wrapped between [-pi; pi], phase unwrapping aims at finding the "true" phase map
by adding the right number of 2*pi to each pixel.
<p>
The problem is straightforward for perfect wrapped phase map, but real data are usually not noise-free.
Among the different algorithms that were developed, quality-guided phase unwrapping methods are fast
and efficient. They follow a path that unwraps high quality pixels first,
avoiding error propagation from the start.
<p>
In this module, a quality-guided phase unwrapping is implemented following the approach described in \cite histogramUnwrapping .
<p>
*/

// Parsed from <opencv2/phase_unwrapping/phase_unwrapping.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
 //
 //  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 //
 //  By downloading, copying, installing or using the software you agree to this license.
 //  If you do not agree to this license, do not download, install,
 //  copy or use the software.
 //
 //
 //                           License Agreement
 //                For Open Source Computer Vision Library
 //
 // Copyright (C) 2015, OpenCV Foundation, all rights reserved.
 // Third party copyrights are property of their respective owners.
 //
 // Redistribution and use in source and binary forms, with or without modification,
 // are permitted provided that the following conditions are met:
 //
 //   * Redistribution's of source code must retain the above copyright notice,
 //     this list of conditions and the following disclaimer.
 //
 //   * Redistribution's in binary form must reproduce the above copyright notice,
 //     this list of conditions and the following disclaimer in the documentation
 //     and/or other materials provided with the distribution.
 //
 //   * The name of the copyright holders may not be used to endorse or promote products
 //     derived from this software without specific prior written permission.
 //
 // This software is provided by the copyright holders and contributors "as is" and
 // any express or implied warranties, including, but not limited to, the implied
 // warranties of merchantability and fitness for a particular purpose are disclaimed.
 // In no event shall the Intel Corporation or contributors be liable for any direct,
 // indirect, incidental, special, exemplary, or consequential damages
 // (including, but not limited to, procurement of substitute goods or services;
 // loss of use, data, or profits; or business interruption) however caused
 // and on any theory of liability, whether in contract, strict liability,
 // or tort (including negligence or otherwise) arising in any way out of
 // the use of this software, even if advised of the possibility of such damage.
 //
 //M*/

// #ifndef __OPENCV_PHASE_UNWRAPPING_HPP__
// #define __OPENCV_PHASE_UNWRAPPING_HPP__

// #include "opencv2/core.hpp"
/** \addtogroup phase_unwrapping
 *  \{
    <p>
    /**
     \brief Abstract base class for phase unwrapping.
    */
@Namespace("cv::phase_unwrapping") public static class PhaseUnwrapping extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PhaseUnwrapping(Pointer p) { super(p); }

    /**
     * \brief Unwraps a 2D phase map.
     <p>
     * @param wrappedPhaseMap The wrapped phase map that needs to be unwrapped.
     * @param unwrappedPhaseMap The unwrapped phase map.
     * @param shadowMask Optional parameter used when some pixels do not hold any phase information in the wrapped phase map.
     */
    public native void unwrapPhaseMap( @ByVal Mat wrappedPhaseMap, @ByVal Mat unwrappedPhaseMap,
                                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat shadowMask );
    public native void unwrapPhaseMap( @ByVal Mat wrappedPhaseMap, @ByVal Mat unwrappedPhaseMap );
    public native void unwrapPhaseMap( @ByVal UMat wrappedPhaseMap, @ByVal UMat unwrappedPhaseMap,
                                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat shadowMask );
    public native void unwrapPhaseMap( @ByVal UMat wrappedPhaseMap, @ByVal UMat unwrappedPhaseMap );
    public native void unwrapPhaseMap( @ByVal GpuMat wrappedPhaseMap, @ByVal GpuMat unwrappedPhaseMap,
                                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat shadowMask );
    public native void unwrapPhaseMap( @ByVal GpuMat wrappedPhaseMap, @ByVal GpuMat unwrappedPhaseMap );

}

/** \} */


// #endif

// Parsed from <opencv2/phase_unwrapping/histogramphaseunwrapping.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
 //
 //  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 //
 //  By downloading, copying, installing or using the software you agree to this license.
 //  If you do not agree to this license, do not download, install,
 //  copy or use the software.
 //
 //
 //                           License Agreement
 //                For Open Source Computer Vision Library
 //
 // Copyright (C) 2015, OpenCV Foundation, all rights reserved.
 // Third party copyrights are property of their respective owners.
 //
 // Redistribution and use in source and binary forms, with or without modification,
 // are permitted provided that the following conditions are met:
 //
 //   * Redistribution's of source code must retain the above copyright notice,
 //     this list of conditions and the following disclaimer.
 //
 //   * Redistribution's in binary form must reproduce the above copyright notice,
 //     this list of conditions and the following disclaimer in the documentation
 //     and/or other materials provided with the distribution.
 //
 //   * The name of the copyright holders may not be used to endorse or promote products
 //     derived from this software without specific prior written permission.
 //
 // This software is provided by the copyright holders and contributors "as is" and
 // any express or implied warranties, including, but not limited to, the implied
 // warranties of merchantability and fitness for a particular purpose are disclaimed.
 // In no event shall the Intel Corporation or contributors be liable for any direct,
 // indirect, incidental, special, exemplary, or consequential damages
 // (including, but not limited to, procurement of substitute goods or services;
 // loss of use, data, or profits; or business interruption) however caused
 // and on any theory of liability, whether in contract, strict liability,
 // or tort (including negligence or otherwise) arising in any way out of
 // the use of this software, even if advised of the possibility of such damage.
 //
 //M*/

// #ifndef __OPENCV_HISTOGRAM_PHASE_UNWRAPPING_HPP__
// #define __OPENCV_HISTOGRAM_PHASE_UNWRAPPING_HPP__

// #include "opencv2/core.hpp"
// #include <opencv2/imgproc.hpp>
// #include "opencv2/phase_unwrapping/phase_unwrapping.hpp"
/** \addtogroup phase_unwrapping
 *  \{
    <p>
    /** \brief Class implementing two-dimensional phase unwrapping based on \cite histogramUnwrapping
     * This algorithm belongs to the quality-guided phase unwrapping methods.
     * First, it computes a reliability map from second differences between a pixel and its eight neighbours.
     * Reliability values lie between 0 and 16*pi*pi. Then, this reliability map is used to compute
     * the reliabilities of "edges". An edge is an entity defined by two pixels that are connected
     * horizontally or vertically. Its reliability is found by adding the the reliabilities of the
     * two pixels connected through it. Edges are sorted in a histogram based on their reliability values.
     * This histogram is then used to unwrap pixels, starting from the highest quality pixel.
     <p>
     * The wrapped phase map and the unwrapped result are stored in CV_32FC1 Mat.
     */
@Namespace("cv::phase_unwrapping") public static class HistogramPhaseUnwrapping extends PhaseUnwrapping {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HistogramPhaseUnwrapping(Pointer p) { super(p); }

    /**
     * \brief Parameters of phaseUnwrapping constructor.
     <p>
     * @param width Phase map width.
     * @param height Phase map height.
     * @param histThresh Bins in the histogram are not of equal size. Default value is 3*pi*pi. The one before "histThresh" value are smaller.
     * @param nbrOfSmallBins Number of bins between 0 and "histThresh". Default value is 10.
     * @param nbrOfLargeBins Number of bins between "histThresh" and 32*pi*pi (highest edge reliability value). Default value is 5.
     */
    @NoOffset public static class Params extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Params(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Params(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Params position(long position) {
            return (Params)super.position(position);
        }
    
        public Params() { super((Pointer)null); allocate(); }
        private native void allocate();
        public native int width(); public native Params width(int width);
        public native int height(); public native Params height(int height);
        public native float histThresh(); public native Params histThresh(float histThresh);
        public native int nbrOfSmallBins(); public native Params nbrOfSmallBins(int nbrOfSmallBins);
        public native int nbrOfLargeBins(); public native Params nbrOfLargeBins(int nbrOfLargeBins);
    }
    /**
     * \brief Constructor
     <p>
     * @param parameters HistogramPhaseUnwrapping parameters HistogramPhaseUnwrapping::Params: width,height of the phase map and histogram characteristics.
     */
    public static native @Ptr HistogramPhaseUnwrapping create( @Const @ByRef(nullValue = "cv::phase_unwrapping::HistogramPhaseUnwrapping::Params()") Params parameters );
    public static native @Ptr HistogramPhaseUnwrapping create( );

    /**
     * \brief Get the reliability map computed from the wrapped phase map.
     <p>
     * @param reliabilityMap Image where the reliability map is stored.
     */
    public native void getInverseReliabilityMap( @ByVal Mat reliabilityMap );
    public native void getInverseReliabilityMap( @ByVal UMat reliabilityMap );
    public native void getInverseReliabilityMap( @ByVal GpuMat reliabilityMap );
}

/** \} */


// #endif

}
