// Targeted by JavaCPP version 1.4.3: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_plot.*;
import static org.bytedeco.javacpp.opencv_video.*;
import static org.bytedeco.javacpp.opencv_dnn.*;
import static org.bytedeco.javacpp.opencv_tracking.*;
import static org.bytedeco.javacpp.opencv_objdetect.*;
import static org.bytedeco.javacpp.opencv_photo.*;

public class opencv_face extends org.bytedeco.javacpp.presets.opencv_face {
    static { Loader.load(); }

// Parsed from <opencv2/face/predict_collector.hpp>

/*
By downloading, copying, installing or using the software you agree to this license.
If you do not agree to this license, do not download, install,
copy or use the software.


                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2000-2015, Intel Corporation, all rights reserved.
Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
Copyright (C) 2009-2015, NVIDIA Corporation, all rights reserved.
Copyright (C) 2010-2013, Advanced Micro Devices, Inc., all rights reserved.
Copyright (C) 2015, OpenCV Foundation, all rights reserved.
Copyright (C) 2015, Itseez Inc., all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are disclaimed.
In no event shall copyright holders or contributors be liable for any direct,
indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_PREDICT_COLLECTOR_HPP__
// #define __OPENCV_PREDICT_COLLECTOR_HPP__

// #include <vector>
// #include <map>
// #include <utility>
// #include <cfloat>

// #include "opencv2/core/cvstd.hpp"
/** \addtogroup face
 *  \{
/** \brief Abstract base class for all strategies of prediction result handling
*/
@Namespace("cv::face") public static class PredictCollector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PredictCollector(Pointer p) { super(p); }


    /** \brief Interface method called by face recognizer before results processing
    @param size total size of prediction evaluation that recognizer could perform
    */
    public native void init(@Cast("size_t") long size);

    /** \brief Interface method called by face recognizer for each result
    @param label current prediction label
    @param dist current prediction distance (confidence)
    */
    public native @Cast("bool") boolean collect(int label, double dist);
}

/** \brief Default predict collector
<p>
Trace minimal distance with treshhold checking (that is default behavior for most predict logic)
*/
@Namespace("cv::face") @NoOffset public static class StandardCollector extends PredictCollector {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StandardCollector(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StandardCollector(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public StandardCollector position(long position) {
        return (StandardCollector)super.position(position);
    }

    @NoOffset public static class PredictResult extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public PredictResult(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public PredictResult(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public PredictResult position(long position) {
            return (PredictResult)super.position(position);
        }
    
        public native int label(); public native PredictResult label(int label);
        public native double distance(); public native PredictResult distance(double distance);
        public PredictResult(int label_/*=-1*/, double distance_/*=DBL_MAX*/) { super((Pointer)null); allocate(label_, distance_); }
        private native void allocate(int label_/*=-1*/, double distance_/*=DBL_MAX*/);
        public PredictResult() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
    /** \brief Constructor
    @param threshold_ set threshold
    */
    public StandardCollector(double threshold_/*=DBL_MAX*/) { super((Pointer)null); allocate(threshold_); }
    private native void allocate(double threshold_/*=DBL_MAX*/);
    public StandardCollector() { super((Pointer)null); allocate(); }
    private native void allocate();
    /** \brief overloaded interface method */
    public native void init(@Cast("size_t") long size);
    /** \brief overloaded interface method */
    public native @Cast("bool") boolean collect(int label, double dist);
    /** \brief Returns label with minimal distance */
    public native int getMinLabel();
    /** \brief Returns minimal distance value */
    public native double getMinDist();
    /** \brief Return results as vector
    @param sorted If set, results will be sorted by distance
    Each values is a pair of label and distance.
    */
    public native @ByVal IntDoublePairVector getResults(@Cast("bool") boolean sorted/*=false*/);
    public native @ByVal IntDoublePairVector getResults();
    /** \brief Return results as map
    Labels are keys, values are minimal distances
    */
    public native @ByVal IntDoubleMap getResultsMap();
    /** \brief Static constructor
    @param threshold set threshold
    */
    public static native @Ptr StandardCollector create(double threshold/*=DBL_MAX*/);
    public static native @Ptr StandardCollector create();
}

/** \} */



// #endif


// Parsed from <opencv2/face.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_FACE_HPP__
// #define __OPENCV_FACE_HPP__

/**
\defgroup face Face Analysis
<p>
- \ref face_changelog
- \ref tutorial_face_main
<p>
*/

// #include "opencv2/core.hpp"
// #include "face/predict_collector.hpp"
// #include <map>

/** \addtogroup face
 *  \{
<p>
/** \brief Abstract base class for all face recognition models
<p>
All face recognition models in OpenCV are derived from the abstract base class FaceRecognizer, which
provides a unified access to all face recongition algorithms in OpenCV.
<p>
### Description
<p>
I'll go a bit more into detail explaining FaceRecognizer, because it doesn't look like a powerful
interface at first sight. But: Every FaceRecognizer is an Algorithm, so you can easily get/set all
model internals (if allowed by the implementation). Algorithm is a relatively new OpenCV concept,
which is available since the 2.4 release. I suggest you take a look at its description.
<p>
Algorithm provides the following features for all derived classes:
<p>
-   So called "virtual constructor". That is, each Algorithm derivative is registered at program
    start and you can get the list of registered algorithms and create instance of a particular
    algorithm by its name (see Algorithm::create). If you plan to add your own algorithms, it is
    good practice to add a unique prefix to your algorithms to distinguish them from other
    algorithms.
-   Setting/Retrieving algorithm parameters by name. If you used video capturing functionality from
    OpenCV highgui module, you are probably familar with cv::cvSetCaptureProperty,
ocvcvGetCaptureProperty, VideoCapture::set and VideoCapture::get. Algorithm provides similar
    method where instead of integer id's you specify the parameter names as text Strings. See
    Algorithm::set and Algorithm::get for details.
-   Reading and writing parameters from/to XML or YAML files. Every Algorithm derivative can store
    all its parameters and then read them back. There is no need to re-implement it each time.
<p>
Moreover every FaceRecognizer supports the:
<p>
-   **Training** of a FaceRecognizer with FaceRecognizer::train on a given set of images (your face
    database!).
-   **Prediction** of a given sample image, that means a face. The image is given as a Mat.
-   **Loading/Saving** the model state from/to a given XML or YAML.
-   **Setting/Getting labels info**, that is stored as a string. String labels info is useful for
    keeping names of the recognized people.
<p>
\note When using the FaceRecognizer interface in combination with Python, please stick to Python 2.
Some underlying scripts like create_csv will not work in other versions, like Python 3. Setting the
Thresholds +++++++++++++++++++++++
<p>
Sometimes you run into the situation, when you want to apply a threshold on the prediction. A common
scenario in face recognition is to tell, whether a face belongs to the training dataset or if it is
unknown. You might wonder, why there's no public API in FaceRecognizer to set the threshold for the
prediction, but rest assured: It's supported. It just means there's no generic way in an abstract
class to provide an interface for setting/getting the thresholds of *every possible* FaceRecognizer
algorithm. The appropriate place to set the thresholds is in the constructor of the specific
FaceRecognizer and since every FaceRecognizer is a Algorithm (see above), you can get/set the
thresholds at runtime!
<p>
Here is an example of setting a threshold for the Eigenfaces method, when creating the model:
<p>
<pre>{@code
// Let's say we want to keep 10 Eigenfaces and have a threshold value of 10.0
int num_components = 10;
double threshold = 10.0;
// Then if you want to have a cv::FaceRecognizer with a confidence threshold,
// create the concrete implementation with the appropiate parameters:
Ptr<FaceRecognizer> model = EigenFaceRecognizer::create(num_components, threshold);
}</pre>
<p>
Sometimes it's impossible to train the model, just to experiment with threshold values. Thanks to
Algorithm it's possible to set internal model thresholds during runtime. Let's see how we would
set/get the prediction for the Eigenface model, we've created above:
<p>
<pre>{@code
// The following line reads the threshold from the Eigenfaces model:
double current_threshold = model->getDouble("threshold");
// And this line sets the threshold to 0.0:
model->set("threshold", 0.0);
}</pre>
<p>
If you've set the threshold to 0.0 as we did above, then:
<p>
<pre>{@code
//
Mat img = imread("person1/3.jpg", CV_LOAD_IMAGE_GRAYSCALE);
// Get a prediction from the model. Note: We've set a threshold of 0.0 above,
// since the distance is almost always larger than 0.0, you'll get -1 as
// label, which indicates, this face is unknown
int predicted_label = model->predict(img);
// ...
}</pre>
<p>
is going to yield -1 as predicted label, which states this face is unknown.
<p>
### Getting the name of a FaceRecognizer
<p>
Since every FaceRecognizer is a Algorithm, you can use Algorithm::name to get the name of a
FaceRecognizer:
<p>
<pre>{@code
// Create a FaceRecognizer:
Ptr<FaceRecognizer> model = EigenFaceRecognizer::create();
// And here's how to get its name:
String name = model->name();
}</pre>
 <p>
 */
@Namespace("cv::face") @NoOffset public static class FaceRecognizer extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FaceRecognizer(Pointer p) { super(p); }

    /** \brief Trains a FaceRecognizer with given data and associated labels.
    <p>
    @param src The training images, that means the faces you want to learn. The data has to be
    given as a vector\<Mat\>.
    @param labels The labels corresponding to the images have to be given either as a vector\<int\>
    or a
    <p>
    The following source code snippet shows you how to learn a Fisherfaces model on a given set of
    images. The images are read with imread and pushed into a std::vector\<Mat\>. The labels of each
    image are stored within a std::vector\<int\> (you could also use a Mat of type CV_32SC1). Think of
    the label as the subject (the person) this image belongs to, so same subjects (persons) should have
    the same label. For the available FaceRecognizer you don't have to pay any attention to the order of
    the labels, just make sure same persons have the same label:
    <p>
    <pre>{@code
    // holds images and labels
    vector<Mat> images;
    vector<int> labels;
    // images for first person
    images.push_back(imread("person0/0.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(0);
    images.push_back(imread("person0/1.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(0);
    images.push_back(imread("person0/2.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(0);
    // images for second person
    images.push_back(imread("person1/0.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(1);
    images.push_back(imread("person1/1.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(1);
    images.push_back(imread("person1/2.jpg", CV_LOAD_IMAGE_GRAYSCALE)); labels.push_back(1);
    }</pre>
    <p>
    Now that you have read some images, we can create a new FaceRecognizer. In this example I'll create
    a Fisherfaces model and decide to keep all of the possible Fisherfaces:
    <p>
    <pre>{@code
    // Create a new Fisherfaces model and retain all available Fisherfaces,
    // this is the most common usage of this specific FaceRecognizer:
    //
    Ptr<FaceRecognizer> model =  FisherFaceRecognizer::create();
    }</pre>
    <p>
    And finally train it on the given dataset (the face images and labels):
    <p>
    <pre>{@code
    // This is the common interface to train all of the available cv::FaceRecognizer
    // implementations:
    //
    model->train(images, labels);
    }</pre>
     */
    public native void train(@ByVal MatVector src, @ByVal Mat labels);
    public native void train(@ByVal UMatVector src, @ByVal Mat labels);
    public native void train(@ByVal GpuMatVector src, @ByVal Mat labels);
    public native void train(@ByVal MatVector src, @ByVal UMat labels);
    public native void train(@ByVal UMatVector src, @ByVal UMat labels);
    public native void train(@ByVal GpuMatVector src, @ByVal UMat labels);
    public native void train(@ByVal MatVector src, @ByVal GpuMat labels);
    public native void train(@ByVal UMatVector src, @ByVal GpuMat labels);
    public native void train(@ByVal GpuMatVector src, @ByVal GpuMat labels);

    /** \brief Updates a FaceRecognizer with given data and associated labels.
    <p>
    @param src The training images, that means the faces you want to learn. The data has to be given
    as a vector\<Mat\>.
    @param labels The labels corresponding to the images have to be given either as a vector\<int\> or
    a
    <p>
    This method updates a (probably trained) FaceRecognizer, but only if the algorithm supports it. The
    Local Binary Patterns Histograms (LBPH) recognizer (see createLBPHFaceRecognizer) can be updated.
    For the Eigenfaces and Fisherfaces method, this is algorithmically not possible and you have to
    re-estimate the model with FaceRecognizer::train. In any case, a call to train empties the existing
    model and learns a new model, while update does not delete any model data.
    <p>
    <pre>{@code
    // Create a new LBPH model (it can be updated) and use the default parameters,
    // this is the most common usage of this specific FaceRecognizer:
    //
    Ptr<FaceRecognizer> model =  LBPHFaceRecognizer::create();
    // This is the common interface to train all of the available cv::FaceRecognizer
    // implementations:
    //
    model->train(images, labels);
    // Some containers to hold new image:
    vector<Mat> newImages;
    vector<int> newLabels;
    // You should add some images to the containers:
    //
    // ...
    //
    // Now updating the model is as easy as calling:
    model->update(newImages,newLabels);
    // This will preserve the old model data and extend the existing model
    // with the new features extracted from newImages!
    }</pre>
    <p>
    Calling update on an Eigenfaces model (see EigenFaceRecognizer::create), which doesn't support
    updating, will throw an error similar to:
    <p>
    <pre>{@code
    OpenCV Error: The function/feature is not implemented (This FaceRecognizer (FaceRecognizer.Eigenfaces) does not support updating, you have to use FaceRecognizer::train to update it.) in update, file /home/philipp/git/opencv/modules/contrib/src/facerec.cpp, line 305
    terminate called after throwing an instance of 'cv::Exception'
    }</pre>
    <p>
    \note The FaceRecognizer does not store your training images, because this would be very
    memory intense and it's not the responsibility of te FaceRecognizer to do so. The caller is
    responsible for maintaining the dataset, he want to work with.
     */
    public native void update(@ByVal MatVector src, @ByVal Mat labels);
    public native void update(@ByVal UMatVector src, @ByVal Mat labels);
    public native void update(@ByVal GpuMatVector src, @ByVal Mat labels);
    public native void update(@ByVal MatVector src, @ByVal UMat labels);
    public native void update(@ByVal UMatVector src, @ByVal UMat labels);
    public native void update(@ByVal GpuMatVector src, @ByVal UMat labels);
    public native void update(@ByVal MatVector src, @ByVal GpuMat labels);
    public native void update(@ByVal UMatVector src, @ByVal GpuMat labels);
    public native void update(@ByVal GpuMatVector src, @ByVal GpuMat labels);

    /** \overload */
    public native @Name("predict") int predict_label(@ByVal Mat src);
    public native @Name("predict") int predict_label(@ByVal UMat src);
    public native @Name("predict") int predict_label(@ByVal GpuMat src);


    /** \brief Predicts a label and associated confidence (e.g. distance) for a given input image.
    <p>
    @param src Sample image to get a prediction from.
    @param label The predicted label for the given image.
    @param confidence Associated confidence (e.g. distance) for the predicted label.
    <p>
    The suffix const means that prediction does not affect the internal model state, so the method can
    be safely called from within different threads.
    <p>
    The following example shows how to get a prediction from a trained model:
    <p>
    <pre>{@code
    using namespace cv;
    // Do your initialization here (create the cv::FaceRecognizer model) ...
    // ...
    // Read in a sample image:
    Mat img = imread("person1/3.jpg", CV_LOAD_IMAGE_GRAYSCALE);
    // And get a prediction from the cv::FaceRecognizer:
    int predicted = model->predict(img);
    }</pre>
    <p>
    Or to get a prediction and the associated confidence (e.g. distance):
    <p>
    <pre>{@code
    using namespace cv;
    // Do your initialization here (create the cv::FaceRecognizer model) ...
    // ...
    Mat img = imread("person1/3.jpg", CV_LOAD_IMAGE_GRAYSCALE);
    // Some variables for the predicted label and associated confidence (e.g. distance):
    int predicted_label = -1;
    double predicted_confidence = 0.0;
    // Get the prediction and associated confidence from the model
    model->predict(img, predicted_label, predicted_confidence);
    }</pre>
     */
    public native void predict(@ByVal Mat src, @ByRef IntPointer label, @ByRef DoublePointer confidence);
    public native void predict(@ByVal Mat src, @ByRef IntBuffer label, @ByRef DoubleBuffer confidence);
    public native void predict(@ByVal Mat src, @ByRef int[] label, @ByRef double[] confidence);
    public native void predict(@ByVal UMat src, @ByRef IntPointer label, @ByRef DoublePointer confidence);
    public native void predict(@ByVal UMat src, @ByRef IntBuffer label, @ByRef DoubleBuffer confidence);
    public native void predict(@ByVal UMat src, @ByRef int[] label, @ByRef double[] confidence);
    public native void predict(@ByVal GpuMat src, @ByRef IntPointer label, @ByRef DoublePointer confidence);
    public native void predict(@ByVal GpuMat src, @ByRef IntBuffer label, @ByRef DoubleBuffer confidence);
    public native void predict(@ByVal GpuMat src, @ByRef int[] label, @ByRef double[] confidence);


    /** \brief - if implemented - send all result of prediction to collector that can be used for somehow custom result handling
    @param src Sample image to get a prediction from.
    @param collector User-defined collector object that accepts all results
    <p>
    To implement this method u just have to do same internal cycle as in predict(InputArray src, CV_OUT int &label, CV_OUT double &confidence) but
    not try to get "best\ result, just resend it to caller side with given collector
    */
    public native @Name("predict") void predict_collect(@ByVal Mat src, @Ptr PredictCollector collector);
    public native @Name("predict") void predict_collect(@ByVal UMat src, @Ptr PredictCollector collector);
    public native @Name("predict") void predict_collect(@ByVal GpuMat src, @Ptr PredictCollector collector);

    /** \brief Saves a FaceRecognizer and its model state.
    <p>
    Saves this model to a given filename, either as XML or YAML.
    @param filename The filename to store this FaceRecognizer to (either XML/YAML).
    <p>
    Every FaceRecognizer overwrites FaceRecognizer::save(FileStorage& fs) to save the internal model
    state. FaceRecognizer::save(const String& filename) saves the state of a model to the given
    filename.
    <p>
    The suffix const means that prediction does not affect the internal model state, so the method can
    be safely called from within different threads.
     */
    public native void write(@Str BytePointer filename);
    public native void write(@Str String filename);

    /** \brief Loads a FaceRecognizer and its model state.
    <p>
    Loads a persisted model and state from a given XML or YAML file . Every FaceRecognizer has to
    overwrite FaceRecognizer::load(FileStorage& fs) to enable loading the model state.
    FaceRecognizer::load(FileStorage& fs) in turn gets called by
    FaceRecognizer::load(const String& filename), to ease saving a model.
     */
    public native void read(@Str BytePointer filename);
    public native void read(@Str String filename);

    /** \overload
    Saves this model to a given FileStorage.
    @param fs The FileStorage to store this FaceRecognizer to.
    */
    public native void write(@ByRef FileStorage fs);

    /** \overload */
    public native void read(@Const @ByRef FileNode fn);

    /** \overload */
    public native @Cast("bool") boolean empty();

    /** \brief Sets string info for the specified model's label.
    <p>
    The string info is replaced by the provided value if it was set before for the specified label.
     */
    public native void setLabelInfo(int label, @Str BytePointer strInfo);
    public native void setLabelInfo(int label, @Str String strInfo);

    /** \brief Gets string information by label.
    <p>
    If an unknown label id is provided or there is no label information associated with the specified
    label id the method returns an empty string.
     */
    public native @Str BytePointer getLabelInfo(int label);

    /** \brief Gets vector of labels by string.
    <p>
    The function searches for the labels containing the specified sub-string in the associated string
    info.
     */
    public native @StdVector IntPointer getLabelsByString(@Str BytePointer str);
    public native @StdVector IntBuffer getLabelsByString(@Str String str);
    /** \brief threshold parameter accessor - required for default BestMinDist collector */
    public native double getThreshold();
    /** \brief Sets threshold of model */
    public native void setThreshold(double val);
}

/** \} */



// #include "opencv2/face/facerec.hpp"
// #include "opencv2/face/facemark.hpp"
// #include "opencv2/face/facemark_train.hpp"
// #include "opencv2/face/facemarkLBF.hpp"
// #include "opencv2/face/facemarkAAM.hpp"
// #include "opencv2/face/face_alignment.hpp"
// #include "opencv2/face/mace.hpp"

// #endif // __OPENCV_FACE_HPP__


// Parsed from <opencv2/face/facerec.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// Copyright (c) 2011,2012. Philipp Wagner <bytefish[at]gmx[dot]de>.
// Third party copyrights are property of their respective owners.

// #ifndef __OPENCV_FACEREC_HPP__
// #define __OPENCV_FACEREC_HPP__

// #include "opencv2/face.hpp"
// #include "opencv2/core.hpp"

/** \addtogroup face
 *  \{ */

// base for two classes
@Namespace("cv::face") @NoOffset public static class BasicFaceRecognizer extends FaceRecognizer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BasicFaceRecognizer(Pointer p) { super(p); }

    /** @see setNumComponents */
    public native int getNumComponents();
    /** \copybrief getNumComponents @see getNumComponents */
    public native void setNumComponents(int val);
    /** @see setThreshold */
    public native double getThreshold();
    /** \copybrief getThreshold @see getThreshold */
    public native void setThreshold(double val);
    public native @ByVal MatVector getProjections();
    public native @ByVal Mat getLabels();
    public native @ByVal Mat getEigenValues();
    public native @ByVal Mat getEigenVectors();
    public native @ByVal Mat getMean();

    public native void read(@Const @ByRef FileNode fn);
    public native void write(@ByRef FileStorage fs);
    public native @Cast("bool") boolean empty();
}

@Namespace("cv::face") public static class EigenFaceRecognizer extends BasicFaceRecognizer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EigenFaceRecognizer(Pointer p) { super(p); }

    /**
    @param num_components The number of components (read: Eigenfaces) kept for this Principal
    Component Analysis. As a hint: There's no rule how many components (read: Eigenfaces) should be
    kept for good reconstruction capabilities. It is based on your input data, so experiment with the
    number. Keeping 80 components should almost always be sufficient.
    @param threshold The threshold applied in the prediction.
    <p>
    ### Notes:
    <p>
    -   Training and prediction must be done on grayscale images, use cvtColor to convert between the
        color spaces.
    -   **THE EIGENFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL
        SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your
        input data has the correct shape, else a meaningful exception is thrown. Use resize to resize
        the images.
    -   This model does not support updating.
    <p>
    ### Model internal data:
    <p>
    -   num_components see EigenFaceRecognizer::create.
    -   threshold see EigenFaceRecognizer::create.
    -   eigenvalues The eigenvalues for this Principal Component Analysis (ordered descending).
    -   eigenvectors The eigenvectors for this Principal Component Analysis (ordered by their
        eigenvalue).
    -   mean The sample mean calculated from the training data.
    -   projections The projections of the training data.
    -   labels The threshold applied in the prediction. If the distance to the nearest neighbor is
        larger than the threshold, this method returns -1.
     */
    public static native @Ptr EigenFaceRecognizer create(int num_components/*=0*/, double threshold/*=DBL_MAX*/);
    public static native @Ptr EigenFaceRecognizer create();
}

@Namespace("cv::face") public static class FisherFaceRecognizer extends BasicFaceRecognizer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FisherFaceRecognizer(Pointer p) { super(p); }

    /**
    @param num_components The number of components (read: Fisherfaces) kept for this Linear
    Discriminant Analysis with the Fisherfaces criterion. It's useful to keep all components, that
    means the number of your classes c (read: subjects, persons you want to recognize). If you leave
    this at the default (0) or set it to a value less-equal 0 or greater (c-1), it will be set to the
    correct number (c-1) automatically.
    @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor
    is larger than the threshold, this method returns -1.
    <p>
    ### Notes:
    <p>
    -   Training and prediction must be done on grayscale images, use cvtColor to convert between the
        color spaces.
    -   **THE FISHERFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL
        SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your
        input data has the correct shape, else a meaningful exception is thrown. Use resize to resize
        the images.
    -   This model does not support updating.
    <p>
    ### Model internal data:
    <p>
    -   num_components see FisherFaceRecognizer::create.
    -   threshold see FisherFaceRecognizer::create.
    -   eigenvalues The eigenvalues for this Linear Discriminant Analysis (ordered descending).
    -   eigenvectors The eigenvectors for this Linear Discriminant Analysis (ordered by their
        eigenvalue).
    -   mean The sample mean calculated from the training data.
    -   projections The projections of the training data.
    -   labels The labels corresponding to the projections.
     */
    public static native @Ptr FisherFaceRecognizer create(int num_components/*=0*/, double threshold/*=DBL_MAX*/);
    public static native @Ptr FisherFaceRecognizer create();
}


@Namespace("cv::face") public static class LBPHFaceRecognizer extends FaceRecognizer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LBPHFaceRecognizer(Pointer p) { super(p); }

    /** @see setGridX */
    public native int getGridX();
    /** \copybrief getGridX @see getGridX */
    public native void setGridX(int val);
    /** @see setGridY */
    public native int getGridY();
    /** \copybrief getGridY @see getGridY */
    public native void setGridY(int val);
    /** @see setRadius */
    public native int getRadius();
    /** \copybrief getRadius @see getRadius */
    public native void setRadius(int val);
    /** @see setNeighbors */
    public native int getNeighbors();
    /** \copybrief getNeighbors @see getNeighbors */
    public native void setNeighbors(int val);
    /** @see setThreshold */
    public native double getThreshold();
    /** \copybrief getThreshold @see getThreshold */
    public native void setThreshold(double val);
    public native @ByVal MatVector getHistograms();
    public native @ByVal Mat getLabels();

    /**
    @param radius The radius used for building the Circular Local Binary Pattern. The greater the
    radius, the smoother the image but more spatial information you can get.
    @param neighbors The number of sample points to build a Circular Local Binary Pattern from. An
    appropriate value is to use {@code 8} sample points. Keep in mind: the more sample points you include,
    the higher the computational cost.
    @param grid_x The number of cells in the horizontal direction, 8 is a common value used in
    publications. The more cells, the finer the grid, the higher the dimensionality of the resulting
    feature vector.
    @param grid_y The number of cells in the vertical direction, 8 is a common value used in
    publications. The more cells, the finer the grid, the higher the dimensionality of the resulting
    feature vector.
    @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor
    is larger than the threshold, this method returns -1.
    <p>
    ### Notes:
    <p>
    -   The Circular Local Binary Patterns (used in training and prediction) expect the data given as
        grayscale images, use cvtColor to convert between the color spaces.
    -   This model supports updating.
    <p>
    ### Model internal data:
    <p>
    -   radius see LBPHFaceRecognizer::create.
    -   neighbors see LBPHFaceRecognizer::create.
    -   grid_x see LLBPHFaceRecognizer::create.
    -   grid_y see LBPHFaceRecognizer::create.
    -   threshold see LBPHFaceRecognizer::create.
    -   histograms Local Binary Patterns Histograms calculated from the given training data (empty if
        none was given).
    -   labels Labels corresponding to the calculated Local Binary Patterns Histograms.
     */
    public static native @Ptr LBPHFaceRecognizer create(int radius/*=1*/, int neighbors/*=8*/, int grid_x/*=8*/, int grid_y/*=8*/, double threshold/*=DBL_MAX*/);
    public static native @Ptr LBPHFaceRecognizer create();
}

/** \} */

 //namespace cv::face

// #endif //__OPENCV_FACEREC_HPP__


// Parsed from <opencv2/face/facemark.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

/*
This file was part of GSoC Project: Facemark API for OpenCV
Final report: https://gist.github.com/kurnianggoro/74de9121e122ad0bd825176751d47ecc
Student: Laksono Kurnianggoro
Mentor: Delia Passalacqua
*/

// #ifndef __OPENCV_FACELANDMARK_HPP__
// #define __OPENCV_FACELANDMARK_HPP__

/**
\defgroup face Face Analysis
- \ref tutorial_table_of_content_facemark
- The Facemark API
*/

// #include "opencv2/core.hpp"
// #include <vector>


/** \brief Abstract base class for all facemark models
<p>
To utilize this API in your program, please take a look at the \ref tutorial_table_of_content_facemark
### Description
<p>
Facemark is a base class which provides universal access to any specific facemark algorithm.
Therefore, the users should declare a desired algorithm before they can use it in their application.
<p>
Here is an example on how to declare a facemark algorithm:
<pre>{@code
// Using Facemark in your code:
Ptr<Facemark> facemark = createFacemarkLBF();
}</pre>
<p>
The typical pipeline for facemark detection is as follows:
- Load the trained model using Facemark::loadModel.
- Perform the fitting on an image via Facemark::fit.
*/
@Namespace("cv::face") public static class Facemark extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Facemark(Pointer p) { super(p); }


    /** \brief A function to load the trained model before the fitting process.
    @param model A string represent the filename of a trained model.
    <p>
    <B>Example of usage</B>
    <pre>{@code
    facemark->loadModel("../data/lbf.model");
    }</pre>
    */
    public native void loadModel( @Str BytePointer model );
    public native void loadModel( @Str String model );
    // virtual void saveModel(String fs)=0;

    /** \brief Detect facial landmarks from an image.
    @param image Input image.
    @param faces Output of the function which represent region of interest of the detected faces.
    Each face is stored in cv::Rect container.
    @param landmarks The detected landmark points for each faces.
    <p>
    <B>Example of usage</B>
    <pre>{@code
    Mat image = imread("image.jpg");
    std::vector<Rect> faces;
    std::vector<std::vector<Point2f> > landmarks;
    facemark->fit(image, faces, landmarks);
    }</pre>
    */
    public native @Cast("bool") boolean fit( @ByVal Mat image,
                          @ByRef RectVector faces,
                          @ByRef Point2fVectorVector landmarks);
} /* Facemark*/


/** construct an AAM facemark detector */
@Namespace("cv::face") public static native @Ptr Facemark createFacemarkAAM();

/** construct an LBF facemark detector */
@Namespace("cv::face") public static native @Ptr Facemark createFacemarkLBF();

/** construct a Kazemi facemark detector */
@Namespace("cv::face") public static native @Ptr Facemark createFacemarkKazemi();


 // face
 // cv

// #endif //__OPENCV_FACELANDMARK_HPP__


// Parsed from <opencv2/face/facemark_train.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

/*
This file was part of GSoC Project: Facemark API for OpenCV
Final report: https://gist.github.com/kurnianggoro/74de9121e122ad0bd825176751d47ecc
Student: Laksono Kurnianggoro
Mentor: Delia Passalacqua
*/

// #ifndef __OPENCV_FACELANDMARKTRAIN_HPP__
// #define __OPENCV_FACELANDMARKTRAIN_HPP__

/**
\defgroup face Face Analysis
- \ref tutorial_table_of_content_facemark
- The Facemark API
*/

// #include "opencv2/face/facemark.hpp"
// #include "opencv2/objdetect.hpp"
// #include <vector>
// #include <string>

/** \addtogroup face
 *  \{ */

@Namespace("cv::face") @NoOffset public static class CParams extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CParams(Pointer p) { super(p); }

    /**  the face detector */
    public native @Str BytePointer cascade(); public native CParams cascade(BytePointer cascade);
    /** Parameter specifying how much the image size is reduced at each image scale. */
    public native double scaleFactor(); public native CParams scaleFactor(double scaleFactor);
    /** Parameter specifying how many neighbors each candidate rectangle should have to retain it. */
    public native int minNeighbors(); public native CParams minNeighbors(int minNeighbors);
    /** Minimum possible object size. */
    public native @ByRef Size minSize(); public native CParams minSize(Size minSize);
    /** Maximum possible object size. */
    public native @ByRef Size maxSize(); public native CParams maxSize(Size maxSize);

    public CParams(
            @Str BytePointer cascade_model,
            double sf/*=1.1*/,
            int minN/*=3*/,
            @ByVal(nullValue = "cv::Size(30, 30)") Size minSz,
            @ByVal(nullValue = "cv::Size()") Size maxSz
        ) { super((Pointer)null); allocate(cascade_model, sf, minN, minSz, maxSz); }
    private native void allocate(
            @Str BytePointer cascade_model,
            double sf/*=1.1*/,
            int minN/*=3*/,
            @ByVal(nullValue = "cv::Size(30, 30)") Size minSz,
            @ByVal(nullValue = "cv::Size()") Size maxSz
        );
    public CParams(
            @Str BytePointer cascade_model
        ) { super((Pointer)null); allocate(cascade_model); }
    private native void allocate(
            @Str BytePointer cascade_model
        );
    public CParams(
            @Str String cascade_model,
            double sf/*=1.1*/,
            int minN/*=3*/,
            @ByVal(nullValue = "cv::Size(30, 30)") Size minSz,
            @ByVal(nullValue = "cv::Size()") Size maxSz
        ) { super((Pointer)null); allocate(cascade_model, sf, minN, minSz, maxSz); }
    private native void allocate(
            @Str String cascade_model,
            double sf/*=1.1*/,
            int minN/*=3*/,
            @ByVal(nullValue = "cv::Size(30, 30)") Size minSz,
            @ByVal(nullValue = "cv::Size()") Size maxSz
        );
    public CParams(
            @Str String cascade_model
        ) { super((Pointer)null); allocate(cascade_model); }
    private native void allocate(
            @Str String cascade_model
        );

    public native @ByRef CascadeClassifier face_cascade(); public native CParams face_cascade(CascadeClassifier face_cascade);
}

/** \brief Default face detector
This function is mainly utilized by the implementation of a Facemark Algorithm.
End users are advised to use function Facemark::getFaces which can be manually defined
and circumvented to the algorithm by Facemark::setFaceDetector.
<p>
@param image The input image to be processed.
@param faces Output of the function which represent region of interest of the detected faces.
Each face is stored in cv::Rect container.
@param params detector parameters
<p>
<B>Example of usage</B>
<pre>{@code
std::vector<cv::Rect> faces;
CParams params("haarcascade_frontalface_alt.xml");
cv::face::getFaces(frame, faces, &params);
for(int j=0;j<faces.size();j++){
    cv::rectangle(frame, faces[j], cv::Scalar(255,0,255));
}
cv::imshow("detection", frame);
}</pre>
*/
@Namespace("cv::face") public static native @Cast("bool") boolean getFaces(@ByVal Mat image, @ByRef RectVector faces, CParams params);

@Namespace("cv::face") public static native @Cast("bool") boolean getFacesHAAR(@ByVal Mat image, @ByRef RectVector faces, @Str String face_cascade_name);

/** \brief A utility to load list of paths to training image and annotation file.
@param imageList The specified file contains paths to the training images.
@param annotationList The specified file contains paths to the training annotations.
@param images The loaded paths of training images.
@param annotations The loaded paths of annotation files.
<p>
Example of usage:
<pre>{@code
String imageFiles = "images_path.txt";
String ptsFiles = "annotations_path.txt";
std::vector<String> images_train;
std::vector<String> landmarks_train;
loadDatasetList(imageFiles,ptsFiles,images_train,landmarks_train);
}</pre>
*/
@Namespace("cv::face") public static native @Cast("bool") boolean loadDatasetList(@Str BytePointer imageList,
                                  @Str BytePointer annotationList,
                                  @ByRef StringVector images,
                                  @ByRef StringVector annotations);
@Namespace("cv::face") public static native @Cast("bool") boolean loadDatasetList(@Str String imageList,
                                  @Str String annotationList,
                                  @ByRef StringVector images,
                                  @ByRef StringVector annotations);

/** \brief A utility to load facial landmark dataset from a single file.
<p>
@param filename The filename of a file that contains the dataset information.
Each line contains the filename of an image followed by
pairs of x and y values of facial landmarks points separated by a space.
Example
<pre>{@code
/home/user/ibug/image_003_1.jpg 336.820955 240.864510 334.238298 260.922709 335.266918 ...
/home/user/ibug/image_005_1.jpg 376.158428 230.845712 376.736984 254.924635 383.265403 ...
}</pre>
@param images A vector where each element represent the filename of image in the dataset.
Images are not loaded by default to save the memory.
@param facePoints The loaded landmark points for all training data.
@param delim Delimiter between each element, the default value is a whitespace.
@param offset An offset value to adjust the loaded points.
<p>
<B>Example of usage</B>
<pre>{@code
cv::String imageFiles = "../data/images_train.txt";
cv::String ptsFiles = "../data/points_train.txt";
std::vector<String> images;
std::vector<std::vector<Point2f> > facePoints;
loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);
}</pre>
*/
@Namespace("cv::face") public static native @Cast("bool") boolean loadTrainingData( @Str String filename, @ByRef StringVector images,
                                    @ByRef Point2fVectorVector facePoints,
                                    @Cast("char") byte delim/*=' '*/, float offset/*=0.0f*/);

/** \brief A utility to load facial landmark information from the dataset.
<p>
@param imageList A file contains the list of image filenames in the training dataset.
@param groundTruth A file contains the list of filenames
where the landmarks points information are stored.
The content in each file should follow the standard format (see face::loadFacePoints).
@param images A vector where each element represent the filename of image in the dataset.
Images are not loaded by default to save the memory.
@param facePoints The loaded landmark points for all training data.
@param offset An offset value to adjust the loaded points.
<p>
<B>Example of usage</B>
<pre>{@code
cv::String imageFiles = "../data/images_train.txt";
cv::String ptsFiles = "../data/points_train.txt";
std::vector<String> images;
std::vector<std::vector<Point2f> > facePoints;
loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);
}</pre>
<p>
example of content in the images_train.txt
<pre>{@code
/home/user/ibug/image_003_1.jpg
/home/user/ibug/image_004_1.jpg
/home/user/ibug/image_005_1.jpg
/home/user/ibug/image_006.jpg
}</pre>
<p>
example of content in the points_train.txt
<pre>{@code
/home/user/ibug/image_003_1.pts
/home/user/ibug/image_004_1.pts
/home/user/ibug/image_005_1.pts
/home/user/ibug/image_006.pts
}</pre>
*/
@Namespace("cv::face") public static native @Cast("bool") boolean loadTrainingData( @Str String imageList, @Str String groundTruth,
                                    @ByRef StringVector images,
                                    @ByRef Point2fVectorVector facePoints,
                                    float offset/*=0.0f*/);

/** \brief This function extracts the data for training from .txt files which contains the corresponding image name and landmarks.
*The first file in each file should give the path of the image whose
*landmarks are being described in the file. Then in the subsequent
*lines there should be coordinates of the landmarks in the image
*i.e each line should be of the form x,y
*where x represents the x coordinate of the landmark and y represents
*the y coordinate of the landmark.
*
*For reference you can see the files as provided in the
*<a href="http://www.ifp.illinois.edu/~vuongle2/helen/">HELEN dataset</a>
*
* @param filename A vector of type cv::String containing name of the .txt files.
* @param trainlandmarks A vector of type cv::Point2f that would store shape or landmarks of all images.
* @param trainimages A vector of type cv::String which stores the name of images whose landmarks are tracked
* @return A boolean value. It returns true when it reads the data successfully and false otherwise
*/
@Namespace("cv::face") public static native @Cast("bool") boolean loadTrainingData(@ByVal StringVector filename,@ByRef Point2fVectorVector trainlandmarks,@ByRef StringVector trainimages);

/** \brief A utility to load facial landmark information from a given file.
<p>
@param filename The filename of file contains the facial landmarks data.
@param points The loaded facial landmark points.
@param offset An offset value to adjust the loaded points.
<p>
<B>Example of usage</B>
<pre>{@code
std::vector<Point2f> points;
face::loadFacePoints("filename.txt", points, 0.0f);
}</pre>
<p>
The annotation file should follow the default format which is
<pre>{@code
version: 1
n_points:  68
{
212.716603 499.771793
230.232816 566.290071
...
}
}</pre>
where n_points is the number of points considered
and each point is represented as its position in x and y.
*/
@Namespace("cv::face") public static native @Cast("bool") boolean loadFacePoints( @Str String filename, @ByRef Point2fVectorVector points,
                                  float offset/*=0.0f*/);

/** \brief Utility to draw the detected facial landmark points
<p>
@param image The input image to be processed.
@param points Contains the data of points which will be drawn.
@param color The color of points in BGR format represented by cv::Scalar.
<p>
<B>Example of usage</B>
<pre>{@code
std::vector<Rect> faces;
std::vector<std::vector<Point2f> > landmarks;
facemark->getFaces(img, faces);
facemark->fit(img, faces, landmarks);
for(int j=0;j<rects.size();j++){
    face::drawFacemarks(frame, landmarks[j], Scalar(0,0,255));
}
}</pre>
*/
@Namespace("cv::face") public static native void drawFacemarks( @ByVal Mat image, @ByRef Point2fVector points,
                                 @ByVal(nullValue = "cv::Scalar(255,0,0)") Scalar color);

/** \brief Abstract base class for trainable facemark models
<p>
To utilize this API in your program, please take a look at the \ref tutorial_table_of_content_facemark
### Description
<p>
The AAM and LBF facemark models in OpenCV are derived from the abstract base class FacemarkTrain, which
provides a unified access to those facemark algorithms in OpenCV.
<p>
Here is an example on how to declare facemark algorithm:
<pre>{@code
// Using Facemark in your code:
Ptr<Facemark> facemark = FacemarkLBF::create();
}</pre>
<p>
<p>
The typical pipeline for facemark detection is listed as follows:
- (Non-mandatory) Set a user defined face detection using FacemarkTrain::setFaceDetector.
  The facemark algorithms are desgined to fit the facial points into a face.
  Therefore, the face information should be provided to the facemark algorithm.
  Some algorithms might provides a default face recognition function.
  However, the users might prefer to use their own face detector to obtains the best possible detection result.
- (Non-mandatory) Training the model for a specific algorithm using FacemarkTrain::training.
  In this case, the model should be automatically saved by the algorithm.
  If the user already have a trained model, then this part can be omitted.
- Load the trained model using Facemark::loadModel.
- Perform the fitting via the Facemark::fit.
*/
@Namespace("cv::face") public static class FacemarkTrain extends Facemark {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FacemarkTrain(Pointer p) { super(p); }

    /** \brief Add one training sample to the trainer.
    <p>
    @param image Input image.
    @param landmarks The ground-truth of facial landmarks points corresponds to the image.
    <p>
    <B>Example of usage</B>
    <pre>{@code
    String imageFiles = "../data/images_train.txt";
    String ptsFiles = "../data/points_train.txt";
    std::vector<String> images_train;
    std::vector<String> landmarks_train;

    // load the list of dataset: image paths and landmark file paths
    loadDatasetList(imageFiles,ptsFiles,images_train,landmarks_train);

    Mat image;
    std::vector<Point2f> facial_points;
    for(size_t i=0;i<images_train.size();i++){
        image = imread(images_train[i].c_str());
        loadFacePoints(landmarks_train[i],facial_points);
        facemark->addTrainingSample(image, facial_points);
    }
    }</pre>
    <p>
    The contents in the training files should follows the standard format.
    Here are examples for the contents in these files.
    example of content in the images_train.txt
    <pre>{@code
    /home/user/ibug/image_003_1.jpg
    /home/user/ibug/image_004_1.jpg
    /home/user/ibug/image_005_1.jpg
    /home/user/ibug/image_006.jpg
    }</pre>
    <p>
    example of content in the points_train.txt
    <pre>{@code
    /home/user/ibug/image_003_1.pts
    /home/user/ibug/image_004_1.pts
    /home/user/ibug/image_005_1.pts
    /home/user/ibug/image_006.pts
    }</pre>
    <p>
    */
    public native @Cast("bool") boolean addTrainingSample(@ByVal Mat image, @ByRef Point2fVector landmarks);

    /** \brief Trains a Facemark algorithm using the given dataset.
    Before the training process, training samples should be added to the trainer
    using face::addTrainingSample function.
    <p>
    @param parameters Optional extra parameters (algorithm dependent).
    <p>
    <B>Example of usage</B>
    <pre>{@code
    FacemarkLBF::Params params;
    params.model_filename = "ibug68.model"; // filename to save the trained model
    Ptr<Facemark> facemark = FacemarkLBF::create(params);

    // add training samples (see Facemark::addTrainingSample)

    facemark->training();
    }</pre>
    */

    public native void training(Pointer parameters/*=0*/);
    public native void training();

    /** \brief Set a user defined face detector for the Facemark algorithm.
    @param detector The user defined face detector function
    @param userData Detector parameters
    <p>
    <B>Example of usage</B>
    <pre>{@code
    MyDetectorParameters detectorParameters(...);
    facemark->setFaceDetector(myDetector, &detectorParameters);
    }</pre>
    <p>
    Example of a user defined face detector
    <pre>{@code
    bool myDetector( InputArray image, OutputArray faces, void* userData)
    {
        MyDetectorParameters* params = (MyDetectorParameters*)userData;
        // -------- do something --------
    }
    }</pre>
    <p>
    TODO Lifetime of detector parameters is uncontrolled. Rework interface design to "Ptr<FaceDetector>".
    */
    public native @Cast("bool") boolean setFaceDetector(@Cast("cv::face::FN_FaceDetector") Pointer detector, Pointer userData/*=0*/);
    public native @Cast("bool") boolean setFaceDetector(@Cast("cv::face::FN_FaceDetector") Pointer detector);

    /** \brief Detect faces from a given image using default or user defined face detector.
    Some Algorithm might not provide a default face detector.
    <p>
    @param image Input image.
    @param faces Output of the function which represent region of interest of the detected faces. Each face is stored in cv::Rect container.
    <p>
    <B>Example of usage</B>
    <pre>{@code
    std::vector<cv::Rect> faces;
    facemark->getFaces(img, faces);
    for(int j=0;j<faces.size();j++){
        cv::rectangle(img, faces[j], cv::Scalar(255,0,255));
    }
    }</pre>
    */
    public native @Cast("bool") boolean getFaces(@ByVal Mat image, @ByRef RectVector faces);

    /** \brief Get data from an algorithm
    <p>
    @param items The obtained data, algorithm dependent.
    <p>
    <B>Example of usage</B>
    <pre>{@code
    Ptr<FacemarkAAM> facemark = FacemarkAAM::create();
    facemark->loadModel("AAM.yml");

    FacemarkAAM::Data data;
    facemark->getData(&data);
    std::vector<Point2f> s0 = data.s0;

    cout<<s0<<endl;
    }</pre>
    */
    public native @Cast("bool") boolean getData(Pointer items/*=0*/);
    public native @Cast("bool") boolean getData(); // FIXIT
} /* Facemark*/

/** \} */
 /* namespace face */
 /* namespace cv */
// #endif //__OPENCV_FACELANDMARKTRAIN_HPP__


// Parsed from <opencv2/face/facemarkLBF.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.
                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)
Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.
This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.

This file was part of GSoC Project: Facemark API for OpenCV
Final report: https://gist.github.com/kurnianggoro/74de9121e122ad0bd825176751d47ecc
Student: Laksono Kurnianggoro
Mentor: Delia Passalacqua
*/

// #ifndef __OPENCV_FACEMARK_LBF_HPP__
// #define __OPENCV_FACEMARK_LBF_HPP__

// #include "opencv2/face/facemark_train.hpp"

/** \addtogroup face
 *  \{ */

@Namespace("cv::face") public static class FacemarkLBF extends FacemarkTrain {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FacemarkLBF(Pointer p) { super(p); }

    @NoOffset public static class Params extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Params(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Params(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Params position(long position) {
            return (Params)super.position(position);
        }
    
        /**
        * \brief Constructor
        */
        public Params() { super((Pointer)null); allocate(); }
        private native void allocate();

        
        /**  offset for the loaded face landmark points */
        public native double shape_offset(); public native Params shape_offset(double shape_offset);
        
        /**  filename of the face detector model */
        public native @Str BytePointer cascade_face(); public native Params cascade_face(BytePointer cascade_face);
        
        /** show the training print-out */
        public native @Cast("bool") boolean verbose(); public native Params verbose(boolean verbose);

        
        /**  number of landmark points */
        public native int n_landmarks(); public native Params n_landmarks(int n_landmarks);
        
        /**  multiplier for augment the training data */
        public native int initShape_n(); public native Params initShape_n(int initShape_n);

        
        /**  number of refinement stages */
        public native int stages_n(); public native Params stages_n(int stages_n);
        
        /**  number of tree in the model for each landmark point refinement */
        public native int tree_n(); public native Params tree_n(int tree_n);
        
        /**  the depth of decision tree, defines the size of feature */
        public native int tree_depth(); public native Params tree_depth(int tree_depth);
        
        /**  overlap ratio for training the LBF feature */
        public native double bagging_overlap(); public native Params bagging_overlap(double bagging_overlap);

        
        /**  filename where the trained model will be saved */
        public native @StdString BytePointer model_filename(); public native Params model_filename(BytePointer model_filename);
        /** flag to save the trained model or not */
        public native @Cast("bool") boolean save_model(); public native Params save_model(boolean save_model);
        /** seed for shuffling the training data */
        public native @Cast("unsigned int") int seed(); public native Params seed(int seed);

        public native @StdVector IntPointer feats_m(); public native Params feats_m(IntPointer feats_m);
        public native @StdVector DoublePointer radius_m(); public native Params radius_m(DoublePointer radius_m);
        
        /**  index of facemark points on pupils of left and right eye */
        public native @StdVector IntPointer pupils(int i); public native Params pupils(int i, IntPointer pupils);
        @MemberGetter public native @StdVector IntPointer pupils();

        public native @ByRef Rect detectROI(); public native Params detectROI(Rect detectROI);

        public native void read(@Const @ByRef FileNode arg0);
        public native void write(@ByRef FileStorage arg0);

    }

    @NoOffset public static class BBox extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public BBox(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public BBox(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public BBox position(long position) {
            return (BBox)super.position(position);
        }
    
        public BBox() { super((Pointer)null); allocate(); }
        private native void allocate();
        public BBox(double x, double y, double w, double h) { super((Pointer)null); allocate(x, y, w, h); }
        private native void allocate(double x, double y, double w, double h);

        public native @ByVal Mat project(@Const @ByRef Mat shape);
        public native @ByVal Mat reproject(@Const @ByRef Mat shape);

        public native double x(); public native BBox x(double x);
        public native double y(); public native BBox y(double y);
        public native double x_center(); public native BBox x_center(double x_center);
        public native double y_center(); public native BBox y_center(double y_center);
        public native double x_scale(); public native BBox x_scale(double x_scale);
        public native double y_scale(); public native BBox y_scale(double y_scale);
        public native double width(); public native BBox width(double width);
        public native double height(); public native BBox height(double height);
    }

    public static native @Ptr FacemarkLBF create(@Const @ByRef(nullValue = "cv::face::FacemarkLBF::Params()") Params parameters );
    public static native @Ptr FacemarkLBF create( );
} /* LBF */

/** \} */

 /* namespace face */
/* namespace cv */

// #endif


// Parsed from <opencv2/face/facemarkAAM.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.
                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)
Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.
This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.

This file was part of GSoC Project: Facemark API for OpenCV
Final report: https://gist.github.com/kurnianggoro/74de9121e122ad0bd825176751d47ecc
Student: Laksono Kurnianggoro
Mentor: Delia Passalacqua
*/

// #ifndef __OPENCV_FACEMARK_AAM_HPP__
// #define __OPENCV_FACEMARK_AAM_HPP__

// #include "opencv2/face/facemark_train.hpp"

/** \addtogroup face
 *  \{ */

@Namespace("cv::face") public static class FacemarkAAM extends FacemarkTrain {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FacemarkAAM(Pointer p) { super(p); }

    @NoOffset public static class Params extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Params(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Params(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Params position(long position) {
            return (Params)super.position(position);
        }
    
        /**
        * \brief Constructor
        */
        public Params() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
        * \brief Read parameters from file, currently unused
        */
        public native void read(@Const @ByRef FileNode arg0);

        /**
        * \brief Read parameters from file, currently unused
        */
        public native void write(@ByRef FileStorage arg0);

        public native @StdString BytePointer model_filename(); public native Params model_filename(BytePointer model_filename);
        public native int m(); public native Params m(int m);
        public native int n(); public native Params n(int n);
        public native int n_iter(); public native Params n_iter(int n_iter);
        public native @Cast("bool") boolean verbose(); public native Params verbose(boolean verbose);
        public native @Cast("bool") boolean save_model(); public native Params save_model(boolean save_model);
        public native int max_m(); public native Params max_m(int max_m);
        public native int max_n(); public native Params max_n(int max_n);
        public native int texture_max_m(); public native Params texture_max_m(int texture_max_m);
        public native @StdVector FloatPointer scales(); public native Params scales(FloatPointer scales);
    }

    /**
    * \brief Optional parameter for fitting process.
    */
    @NoOffset public static class Config extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Config(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Config(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Config position(long position) {
            return (Config)super.position(position);
        }
    
        public Config( @ByVal(nullValue = "cv::Mat::eye(2,2,CV_32F)") Mat rot,
                        @ByVal(nullValue = "cv::Point2f(0.0f, 0.0f)") Point2f trans,
                        float scaling/*=1.0f*/,
                        int scale_id/*=0*/
                ) { super((Pointer)null); allocate(rot, trans, scaling, scale_id); }
        private native void allocate( @ByVal(nullValue = "cv::Mat::eye(2,2,CV_32F)") Mat rot,
                        @ByVal(nullValue = "cv::Point2f(0.0f, 0.0f)") Point2f trans,
                        float scaling/*=1.0f*/,
                        int scale_id/*=0*/
                );
        public Config(
                ) { super((Pointer)null); allocate(); }
        private native void allocate(
                );

        public native @ByRef Mat R(); public native Config R(Mat R);
        public native @ByRef Point2f t(); public native Config t(Point2f t);
        public native float scale(); public native Config scale(float scale);
        public native int model_scale_idx(); public native Config model_scale_idx(int model_scale_idx);

    }

    /**
    * \brief Data container for the facemark::getData function
    */
    public static class Data extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public Data() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Data(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Data(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public Data position(long position) {
            return (Data)super.position(position);
        }
    
        public native @ByRef Point2fVector s0(); public native Data s0(Point2fVector s0);
    }

    /**
    * \brief The model of AAM Algorithm
    */
    public static class Model extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public Model() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Model(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Model(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public Model position(long position) {
            return (Model)super.position(position);
        }
    
        
        /**  defines the scales considered to build the model */
        public native @StdVector FloatPointer scales(); public native Model scales(FloatPointer scales);

        /*warping*/
        
        /**  each element contains 3 values, represent index of facemarks that construct one triangle (obtained using delaunay triangulation) */
        public native @ByRef @Cast("std::vector<cv::Vec3i>*") Point3iVector triangles(); public native Model triangles(Point3iVector triangles);

        public static class Texture extends Pointer {
            static { Loader.load(); }
            /** Default native constructor. */
            public Texture() { super((Pointer)null); allocate(); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public Texture(long size) { super((Pointer)null); allocateArray(size); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Texture(Pointer p) { super(p); }
            private native void allocate();
            private native void allocateArray(long size);
            @Override public Texture position(long position) {
                return (Texture)super.position(position);
            }
        
            /**  unused delete */
            public native int max_m(); public native Texture max_m(int max_m);
            
            /**  resolution of the current scale */
            public native @ByRef Rect resolution(); public native Texture resolution(Rect resolution);
            
            /**  gray values from all face region in the dataset, projected in PCA space */
            public native @ByRef Mat A(); public native Texture A(Mat A);
            
            /**  average of gray values from all face region in the dataset */
            public native @ByRef Mat A0(); public native Texture A0(Mat A0);
            
            /**  gray values from all erorded face region in the dataset, projected in PCA space */
            public native @ByRef Mat AA(); public native Texture AA(Mat AA);
            
            /**  average of gray values from all erorded face region in the dataset */
            public native @ByRef Mat AA0(); public native Texture AA0(Mat AA0);

            
            /**  index for warping of each delaunay triangle region constructed by 3 facemarks */
            public native @ByRef PointVectorVector textureIdx(); public native Texture textureIdx(PointVectorVector textureIdx);
            
            /**  basic shape, normalized to be fit in an image with current detection resolution */
            public native @ByRef Point2fVector base_shape(); public native Texture base_shape(Point2fVector base_shape);
            
            /**  index of pixels for mapping process to obtains the grays values of face region */
            public native @StdVector IntPointer ind1(); public native Texture ind1(IntPointer ind1);
            
            /**  index of pixels for mapping process to obtains the grays values of eroded face region */
            public native @StdVector IntPointer ind2(); public native Texture ind2(IntPointer ind2);
        }
        
        /**  a container to holds the texture data for each scale of fitting */
        public native @StdVector Texture textures(); public native Model textures(Texture textures);

        /*shape*/
        
        /**  the basic shape obtained from training dataset */
        public native @ByRef Point2fVector s0(); public native Model s0(Point2fVector s0);
        
        /**  the encoded shapes from training data */
        public native @ByRef Mat S(); public native Model S(Mat S);
        public native @ByRef Mat Q(); public native Model Q(Mat Q);

    }

    /** overload with additional Config structures */
    public native @Cast("bool") boolean fitConfig( @ByVal Mat image, @ByRef RectVector roi, @ByRef Point2fVectorVector _landmarks, @StdVector Config runtime_params );


    /**  initializer */
    public static native @Ptr FacemarkAAM create(@Const @ByRef(nullValue = "cv::face::FacemarkAAM::Params()") Params parameters );
    public static native @Ptr FacemarkAAM create( );

} /* AAM */

/** \} */

 /* namespace face */
 /* namespace cv */
// #endif


// Parsed from <opencv2/face/face_alignment.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.
// #ifndef __OPENCV_FACE_ALIGNMENT_HPP__
// #define __OPENCV_FACE_ALIGNMENT_HPP__

// #include "opencv2/face/facemark_train.hpp"
@Namespace("cv::face") public static class FacemarkKazemi extends Facemark {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FacemarkKazemi(Pointer p) { super(p); }

    @NoOffset public static class Params extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Params(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Params(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Params position(long position) {
            return (Params)super.position(position);
        }
    
        /**
        * \brief Constructor
        */
        public Params() { super((Pointer)null); allocate(); }
        private native void allocate();
        /** cascade_depth This stores the deapth of cascade used for training. */
        public native @Cast("unsigned long") long cascade_depth(); public native Params cascade_depth(long cascade_depth);
        /** tree_depth This stores the max height of the regression tree built. */
        public native @Cast("unsigned long") long tree_depth(); public native Params tree_depth(long tree_depth);
        /** num_trees_per_cascade_level This stores number of trees fit per cascade level. */
        public native @Cast("unsigned long") long num_trees_per_cascade_level(); public native Params num_trees_per_cascade_level(long num_trees_per_cascade_level);
        /** learning_rate stores the learning rate in gradient boosting, also reffered as shrinkage. */
        public native float learning_rate(); public native Params learning_rate(float learning_rate);
        /** oversampling_amount stores number of initialisations used to create training samples. */
        public native @Cast("unsigned long") long oversampling_amount(); public native Params oversampling_amount(long oversampling_amount);
        /** num_test_coordinates stores number of test coordinates. */
        public native @Cast("unsigned long") long num_test_coordinates(); public native Params num_test_coordinates(long num_test_coordinates);
        /** lambda stores a value to calculate probability of closeness of two coordinates. */
        public native float lambda(); public native Params lambda(float lambda);
        /** num_test_splits stores number of random test splits generated. */
        public native @Cast("unsigned long") long num_test_splits(); public native Params num_test_splits(long num_test_splits);
        /** configfile stores the name of the file containing the values of training parameters */
        public native @Str BytePointer configfile(); public native Params configfile(BytePointer configfile);
    }
    public static native @Ptr FacemarkKazemi create(@Const @ByRef(nullValue = "cv::face::FacemarkKazemi::Params()") Params parameters);
    public static native @Ptr FacemarkKazemi create();

    /** \brief This function is used to train the model using gradient boosting to get a cascade of regressors
    *which can then be used to predict shape.
    *@param images A vector of type cv::Mat which stores the images which are used in training samples.
    *@param landmarks A vector of vectors of type cv::Point2f which stores the landmarks detected in a particular image.
    *@param scale A size of type cv::Size to which all images and landmarks have to be scaled to.
    *@param configfile A variable of type std::string which stores the name of the file storing parameters for training the model.
    *@param modelFilename A variable of type std::string which stores the name of the trained model file that has to be saved.
    *@return A boolean value. The function returns true if the model is trained properly or false if it is not trained.
    */
    public native @Cast("bool") boolean training(@ByRef MatVector images, @ByRef Point2fVectorVector landmarks,@StdString BytePointer configfile,@ByVal Size scale,@StdString BytePointer modelFilename/*="face_landmarks.dat"*/);
    public native @Cast("bool") boolean training(@ByRef MatVector images, @ByRef Point2fVectorVector landmarks,@StdString BytePointer configfile,@ByVal Size scale);
    public native @Cast("bool") boolean training(@ByRef MatVector images, @ByRef Point2fVectorVector landmarks,@StdString String configfile,@ByVal Size scale,@StdString String modelFilename/*="face_landmarks.dat"*/);
    public native @Cast("bool") boolean training(@ByRef MatVector images, @ByRef Point2fVectorVector landmarks,@StdString String configfile,@ByVal Size scale);

    /** set the custom face detector */
    public native @Cast("bool") boolean setFaceDetector(@Cast("bool (*)(cv::InputArray, cv::OutputArray, void*)") Pointer f, Pointer userData);
    /** get faces using the custom detector */
    public native @Cast("bool") boolean getFaces(@ByVal Mat image, @ByRef RectVector faces);
}

 // namespace
// #endif


}
