/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.xfeatures2d;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint2f;
import org.opencv.utils.Converters;

public class PCTSignatures
extends Algorithm {
    public static final int L0_25 = 0;
    public static final int L0_5 = 1;
    public static final int L1 = 2;
    public static final int L2 = 3;
    public static final int L2SQUARED = 4;
    public static final int L5 = 5;
    public static final int L_INFINITY = 6;
    public static final int UNIFORM = 0;
    public static final int REGULAR = 1;
    public static final int NORMAL = 2;
    public static final int MINUS = 0;
    public static final int GAUSSIAN = 1;
    public static final int HEURISTIC = 2;

    protected PCTSignatures(long addr) {
        super(addr);
    }

    public static PCTSignatures __fromPtr__(long addr) {
        return new PCTSignatures(addr);
    }

    public static PCTSignatures create(int initSampleCount, int initSeedCount, int pointDistribution) {
        PCTSignatures retVal = PCTSignatures.__fromPtr__(PCTSignatures.create_0(initSampleCount, initSeedCount, pointDistribution));
        return retVal;
    }

    public static PCTSignatures create() {
        PCTSignatures retVal = PCTSignatures.__fromPtr__(PCTSignatures.create_1());
        return retVal;
    }

    public static PCTSignatures create(MatOfPoint2f initSamplingPoints, int initSeedCount) {
        MatOfPoint2f initSamplingPoints_mat = initSamplingPoints;
        PCTSignatures retVal = PCTSignatures.__fromPtr__(PCTSignatures.create_2(initSamplingPoints_mat.nativeObj, initSeedCount));
        return retVal;
    }

    public static PCTSignatures create(MatOfPoint2f initSamplingPoints, MatOfInt initClusterSeedIndexes) {
        MatOfPoint2f initSamplingPoints_mat = initSamplingPoints;
        MatOfInt initClusterSeedIndexes_mat = initClusterSeedIndexes;
        PCTSignatures retVal = PCTSignatures.__fromPtr__(PCTSignatures.create_3(initSamplingPoints_mat.nativeObj, initClusterSeedIndexes_mat.nativeObj));
        return retVal;
    }

    public float getDropThreshold() {
        float retVal = PCTSignatures.getDropThreshold_0(this.nativeObj);
        return retVal;
    }

    public float getJoiningDistance() {
        float retVal = PCTSignatures.getJoiningDistance_0(this.nativeObj);
        return retVal;
    }

    public float getWeightA() {
        float retVal = PCTSignatures.getWeightA_0(this.nativeObj);
        return retVal;
    }

    public float getWeightB() {
        float retVal = PCTSignatures.getWeightB_0(this.nativeObj);
        return retVal;
    }

    public float getWeightContrast() {
        float retVal = PCTSignatures.getWeightContrast_0(this.nativeObj);
        return retVal;
    }

    public float getWeightEntropy() {
        float retVal = PCTSignatures.getWeightEntropy_0(this.nativeObj);
        return retVal;
    }

    public float getWeightL() {
        float retVal = PCTSignatures.getWeightL_0(this.nativeObj);
        return retVal;
    }

    public float getWeightX() {
        float retVal = PCTSignatures.getWeightX_0(this.nativeObj);
        return retVal;
    }

    public float getWeightY() {
        float retVal = PCTSignatures.getWeightY_0(this.nativeObj);
        return retVal;
    }

    public int getClusterMinSize() {
        int retVal = PCTSignatures.getClusterMinSize_0(this.nativeObj);
        return retVal;
    }

    public int getDistanceFunction() {
        int retVal = PCTSignatures.getDistanceFunction_0(this.nativeObj);
        return retVal;
    }

    public int getGrayscaleBits() {
        int retVal = PCTSignatures.getGrayscaleBits_0(this.nativeObj);
        return retVal;
    }

    public int getInitSeedCount() {
        int retVal = PCTSignatures.getInitSeedCount_0(this.nativeObj);
        return retVal;
    }

    public int getIterationCount() {
        int retVal = PCTSignatures.getIterationCount_0(this.nativeObj);
        return retVal;
    }

    public int getMaxClustersCount() {
        int retVal = PCTSignatures.getMaxClustersCount_0(this.nativeObj);
        return retVal;
    }

    public int getSampleCount() {
        int retVal = PCTSignatures.getSampleCount_0(this.nativeObj);
        return retVal;
    }

    public int getWindowRadius() {
        int retVal = PCTSignatures.getWindowRadius_0(this.nativeObj);
        return retVal;
    }

    public MatOfPoint2f getSamplingPoints() {
        MatOfPoint2f retVal = MatOfPoint2f.fromNativeAddr(PCTSignatures.getSamplingPoints_0(this.nativeObj));
        return retVal;
    }

    public MatOfInt getInitSeedIndexes() {
        MatOfInt retVal = MatOfInt.fromNativeAddr(PCTSignatures.getInitSeedIndexes_0(this.nativeObj));
        return retVal;
    }

    public void computeSignature(Mat image, Mat signature) {
        PCTSignatures.computeSignature_0(this.nativeObj, image.nativeObj, signature.nativeObj);
    }

    public void computeSignatures(List<Mat> images, List<Mat> signatures) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat signatures_mat = Converters.vector_Mat_to_Mat(signatures);
        PCTSignatures.computeSignatures_0(this.nativeObj, images_mat.nativeObj, signatures_mat.nativeObj);
    }

    public static void drawSignature(Mat source, Mat signature, Mat result, float radiusToShorterSideRatio, int borderThickness) {
        PCTSignatures.drawSignature_0(source.nativeObj, signature.nativeObj, result.nativeObj, radiusToShorterSideRatio, borderThickness);
    }

    public static void drawSignature(Mat source, Mat signature, Mat result) {
        PCTSignatures.drawSignature_1(source.nativeObj, signature.nativeObj, result.nativeObj);
    }

    public static void generateInitPoints(MatOfPoint2f initPoints, int count, int pointDistribution) {
        MatOfPoint2f initPoints_mat = initPoints;
        PCTSignatures.generateInitPoints_0(initPoints_mat.nativeObj, count, pointDistribution);
    }

    public void setClusterMinSize(int clusterMinSize) {
        PCTSignatures.setClusterMinSize_0(this.nativeObj, clusterMinSize);
    }

    public void setDistanceFunction(int distanceFunction) {
        PCTSignatures.setDistanceFunction_0(this.nativeObj, distanceFunction);
    }

    public void setDropThreshold(float dropThreshold) {
        PCTSignatures.setDropThreshold_0(this.nativeObj, dropThreshold);
    }

    public void setGrayscaleBits(int grayscaleBits) {
        PCTSignatures.setGrayscaleBits_0(this.nativeObj, grayscaleBits);
    }

    public void setInitSeedIndexes(MatOfInt initSeedIndexes) {
        MatOfInt initSeedIndexes_mat = initSeedIndexes;
        PCTSignatures.setInitSeedIndexes_0(this.nativeObj, initSeedIndexes_mat.nativeObj);
    }

    public void setIterationCount(int iterationCount) {
        PCTSignatures.setIterationCount_0(this.nativeObj, iterationCount);
    }

    public void setJoiningDistance(float joiningDistance) {
        PCTSignatures.setJoiningDistance_0(this.nativeObj, joiningDistance);
    }

    public void setMaxClustersCount(int maxClustersCount) {
        PCTSignatures.setMaxClustersCount_0(this.nativeObj, maxClustersCount);
    }

    public void setSamplingPoints(MatOfPoint2f samplingPoints) {
        MatOfPoint2f samplingPoints_mat = samplingPoints;
        PCTSignatures.setSamplingPoints_0(this.nativeObj, samplingPoints_mat.nativeObj);
    }

    public void setTranslation(int idx, float value) {
        PCTSignatures.setTranslation_0(this.nativeObj, idx, value);
    }

    public void setTranslations(MatOfFloat translations) {
        MatOfFloat translations_mat = translations;
        PCTSignatures.setTranslations_0(this.nativeObj, translations_mat.nativeObj);
    }

    public void setWeight(int idx, float value) {
        PCTSignatures.setWeight_0(this.nativeObj, idx, value);
    }

    public void setWeightA(float weight) {
        PCTSignatures.setWeightA_0(this.nativeObj, weight);
    }

    public void setWeightB(float weight) {
        PCTSignatures.setWeightB_0(this.nativeObj, weight);
    }

    public void setWeightContrast(float weight) {
        PCTSignatures.setWeightContrast_0(this.nativeObj, weight);
    }

    public void setWeightEntropy(float weight) {
        PCTSignatures.setWeightEntropy_0(this.nativeObj, weight);
    }

    public void setWeightL(float weight) {
        PCTSignatures.setWeightL_0(this.nativeObj, weight);
    }

    public void setWeightX(float weight) {
        PCTSignatures.setWeightX_0(this.nativeObj, weight);
    }

    public void setWeightY(float weight) {
        PCTSignatures.setWeightY_0(this.nativeObj, weight);
    }

    public void setWeights(MatOfFloat weights) {
        MatOfFloat weights_mat = weights;
        PCTSignatures.setWeights_0(this.nativeObj, weights_mat.nativeObj);
    }

    public void setWindowRadius(int radius) {
        PCTSignatures.setWindowRadius_0(this.nativeObj, radius);
    }

    @Override
    protected void finalize() throws Throwable {
        PCTSignatures.delete(this.nativeObj);
    }

    private static native long create_0(int var0, int var1, int var2);

    private static native long create_1();

    private static native long create_2(long var0, int var2);

    private static native long create_3(long var0, long var2);

    private static native float getDropThreshold_0(long var0);

    private static native float getJoiningDistance_0(long var0);

    private static native float getWeightA_0(long var0);

    private static native float getWeightB_0(long var0);

    private static native float getWeightContrast_0(long var0);

    private static native float getWeightEntropy_0(long var0);

    private static native float getWeightL_0(long var0);

    private static native float getWeightX_0(long var0);

    private static native float getWeightY_0(long var0);

    private static native int getClusterMinSize_0(long var0);

    private static native int getDistanceFunction_0(long var0);

    private static native int getGrayscaleBits_0(long var0);

    private static native int getInitSeedCount_0(long var0);

    private static native int getIterationCount_0(long var0);

    private static native int getMaxClustersCount_0(long var0);

    private static native int getSampleCount_0(long var0);

    private static native int getWindowRadius_0(long var0);

    private static native long getSamplingPoints_0(long var0);

    private static native long getInitSeedIndexes_0(long var0);

    private static native void computeSignature_0(long var0, long var2, long var4);

    private static native void computeSignatures_0(long var0, long var2, long var4);

    private static native void drawSignature_0(long var0, long var2, long var4, float var6, int var7);

    private static native void drawSignature_1(long var0, long var2, long var4);

    private static native void generateInitPoints_0(long var0, int var2, int var3);

    private static native void setClusterMinSize_0(long var0, int var2);

    private static native void setDistanceFunction_0(long var0, int var2);

    private static native void setDropThreshold_0(long var0, float var2);

    private static native void setGrayscaleBits_0(long var0, int var2);

    private static native void setInitSeedIndexes_0(long var0, long var2);

    private static native void setIterationCount_0(long var0, int var2);

    private static native void setJoiningDistance_0(long var0, float var2);

    private static native void setMaxClustersCount_0(long var0, int var2);

    private static native void setSamplingPoints_0(long var0, long var2);

    private static native void setTranslation_0(long var0, int var2, float var3);

    private static native void setTranslations_0(long var0, long var2);

    private static native void setWeight_0(long var0, int var2, float var3);

    private static native void setWeightA_0(long var0, float var2);

    private static native void setWeightB_0(long var0, float var2);

    private static native void setWeightContrast_0(long var0, float var2);

    private static native void setWeightEntropy_0(long var0, float var2);

    private static native void setWeightL_0(long var0, float var2);

    private static native void setWeightX_0(long var0, float var2);

    private static native void setWeightY_0(long var0, float var2);

    private static native void setWeights_0(long var0, long var2);

    private static native void setWindowRadius_0(long var0, int var2);

    private static native void delete(long var0);
}

