/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.sockets.sslengine;

import com.subgraph.orchid.sockets.sslengine.SSLEngineManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SSLEngineOutputStream
extends OutputStream {
    private final SSLEngineManager manager;
    private final ByteBuffer outputBuffer;

    public SSLEngineOutputStream(SSLEngineManager manager) {
        this.manager = manager;
        this.outputBuffer = manager.getSendBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputBuffer.put((byte)b);
        this.manager.write();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int n;
        for (int written = 0; written < len; written += n) {
            n = this.doWrite(b, off + written, len - written);
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.close();
    }

    private int doWrite(byte[] b, int off, int len) throws IOException {
        int putLength = Math.min(len, this.outputBuffer.remaining());
        this.outputBuffer.put(b, off, putLength);
        this.manager.write();
        return putLength;
    }
}

