/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.directory.DocumentParserFactoryImpl;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import com.subgraph.orchid.directory.downloader.HttpConnection;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParserFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public abstract class DocumentFetcher<T> {
    protected static final DocumentParserFactory PARSER_FACTORY = new DocumentParserFactoryImpl();

    abstract String getRequestPath();

    abstract DocumentParser<T> createParser(ByteBuffer var1);

    public List<T> requestDocuments(HttpConnection httpConnection) throws IOException, DirectoryRequestFailedException {
        ByteBuffer body = this.makeRequest(httpConnection);
        if (body.hasRemaining()) {
            return this.processResponse(body);
        }
        return Collections.emptyList();
    }

    private ByteBuffer makeRequest(HttpConnection httpConnection) throws IOException, DirectoryRequestFailedException {
        httpConnection.sendGetRequest(this.getRequestPath());
        httpConnection.readResponse();
        if (httpConnection.getStatusCode() == 200) {
            return httpConnection.getMessageBody();
        }
        throw new DirectoryRequestFailedException("Request " + this.getRequestPath() + " to directory " + httpConnection.getHost() + " returned error code: " + httpConnection.getStatusCode() + " " + httpConnection.getStatusMessage());
    }

    private List<T> processResponse(ByteBuffer response) throws DirectoryRequestFailedException {
        BasicDocumentParsingResult result;
        DocumentParser parser = this.createParser(response);
        boolean success = parser.parse(result = new BasicDocumentParsingResult());
        if (success) {
            return result.getParsedDocuments();
        }
        throw new DirectoryRequestFailedException("Failed to parse response from directory: " + result.getMessage());
    }
}

