/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.RouterMicrodescriptor;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.downloader.BridgeDescriptorFetcher;
import com.subgraph.orchid.directory.downloader.CertificateFetcher;
import com.subgraph.orchid.directory.downloader.ConsensusFetcher;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import com.subgraph.orchid.directory.downloader.DocumentFetcher;
import com.subgraph.orchid.directory.downloader.HttpConnection;
import com.subgraph.orchid.directory.downloader.MicrodescriptorFetcher;
import com.subgraph.orchid.directory.downloader.RouterDescriptorFetcher;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class DirectoryDocumentRequestor {
    private static final int OPEN_DIRECTORY_STREAM_TIMEOUT = 10000;
    private final DirectoryCircuit circuit;
    private final TorInitializationTracker initializationTracker;

    public DirectoryDocumentRequestor(DirectoryCircuit circuit) {
        this(circuit, null);
    }

    public DirectoryDocumentRequestor(DirectoryCircuit circuit, TorInitializationTracker initializationTracker) {
        this.circuit = circuit;
        this.initializationTracker = initializationTracker;
    }

    public RouterDescriptor downloadBridgeDescriptor(Router bridge) throws DirectoryRequestFailedException {
        return this.fetchSingleDocument(new BridgeDescriptorFetcher());
    }

    public ConsensusDocument downloadCurrentConsensus(boolean useMicrodescriptors) throws DirectoryRequestFailedException {
        return this.fetchSingleDocument(new ConsensusFetcher(useMicrodescriptors), 1);
    }

    public List<KeyCertificate> downloadKeyCertificates(Set<ConsensusDocument.RequiredCertificate> required) throws DirectoryRequestFailedException {
        return this.fetchDocuments(new CertificateFetcher(required), 2);
    }

    public List<RouterDescriptor> downloadRouterDescriptors(Set<HexDigest> fingerprints) throws DirectoryRequestFailedException {
        return this.fetchDocuments(new RouterDescriptorFetcher(fingerprints), 3);
    }

    public List<RouterMicrodescriptor> downloadRouterMicrodescriptors(Set<HexDigest> fingerprints) throws DirectoryRequestFailedException {
        return this.fetchDocuments(new MicrodescriptorFetcher(fingerprints), 3);
    }

    private <T> T fetchSingleDocument(DocumentFetcher<T> fetcher) throws DirectoryRequestFailedException {
        return this.fetchSingleDocument(fetcher, 0);
    }

    private <T> T fetchSingleDocument(DocumentFetcher<T> fetcher, int purpose) throws DirectoryRequestFailedException {
        List<T> result = this.fetchDocuments(fetcher, purpose);
        if (result.size() == 1) {
            return result.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> fetchDocuments(DocumentFetcher<T> fetcher, int purpose) throws DirectoryRequestFailedException {
        HttpConnection http = this.createHttpConnection(purpose);
        try {
            List<T> list = fetcher.requestDocuments(http);
            http.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                http.close();
                throw throwable;
            }
            catch (TimeoutException e) {
                throw new DirectoryRequestFailedException("Directory request timed out");
            }
            catch (StreamConnectFailedException e) {
                throw new DirectoryRequestFailedException("Failed to open directory stream", e);
            }
            catch (IOException e) {
                throw new DirectoryRequestFailedException("I/O exception processing directory request", e);
            }
            catch (InterruptedException e) {
                throw new DirectoryRequestFailedException("Directory request interrupted");
            }
        }
    }

    private HttpConnection createHttpConnection(int purpose) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        return new HttpConnection(this.openDirectoryStream(purpose));
    }

    private Stream openDirectoryStream(int purpose) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        int requestEventCode = this.purposeToEventCode(purpose, false);
        int loadingEventCode = this.purposeToEventCode(purpose, true);
        this.notifyInitialization(requestEventCode);
        Stream stream = this.circuit.openDirectoryStream(10000L, true);
        this.notifyInitialization(loadingEventCode);
        return stream;
    }

    private int purposeToEventCode(int purpose, boolean getLoadingEvent) {
        switch (purpose) {
            case 1: {
                return getLoadingEvent ? 25 : 20;
            }
            case 2: {
                return getLoadingEvent ? 40 : 35;
            }
            case 3: {
                return getLoadingEvent ? 50 : 45;
            }
        }
        return 0;
    }

    private void notifyInitialization(int code) {
        if (code > 0 && this.initializationTracker != null) {
            this.initializationTracker.notifyEvent(code);
        }
    }
}

