/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.geoip.CountryCodeService;
import java.util.Collections;
import java.util.Set;

public class RouterImpl
implements Router {
    private final Directory directory;
    private final HexDigest identityHash;
    protected RouterStatus status;
    private Descriptor descriptor;
    private volatile String cachedCountryCode;

    static RouterImpl createFromRouterStatus(Directory directory, RouterStatus status) {
        return new RouterImpl(directory, status);
    }

    protected RouterImpl(Directory directory, RouterStatus status) {
        this.directory = directory;
        this.identityHash = status.getIdentity();
        this.status = status;
        this.refreshDescriptor();
    }

    void updateStatus(RouterStatus status) {
        if (!this.identityHash.equals(status.getIdentity())) {
            throw new TorException("Identity hash does not match status update");
        }
        this.status = status;
        this.cachedCountryCode = null;
        this.descriptor = null;
        this.refreshDescriptor();
    }

    @Override
    public boolean isDescriptorDownloadable() {
        this.refreshDescriptor();
        if (this.descriptor != null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.status.getPublicationTime().getDate().getTime();
        return diff > 600000L;
    }

    @Override
    public String getVersion() {
        return this.status.getVersion();
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return this.status.getDescriptorDigest();
    }

    @Override
    public IPv4Address getAddress() {
        return this.status.getAddress();
    }

    @Override
    public Descriptor getCurrentDescriptor() {
        this.refreshDescriptor();
        return this.descriptor;
    }

    private synchronized void refreshDescriptor() {
        if (this.descriptor != null || this.directory == null) {
            return;
        }
        if (this.status.getMicrodescriptorDigest() != null) {
            this.descriptor = this.directory.getMicrodescriptorFromCache(this.status.getMicrodescriptorDigest());
        } else if (this.status.getDescriptorDigest() != null) {
            this.descriptor = this.directory.getBasicDescriptorFromCache(this.status.getDescriptorDigest());
        }
    }

    @Override
    public HexDigest getMicrodescriptorDigest() {
        return this.status.getMicrodescriptorDigest();
    }

    public boolean hasFlag(String flag) {
        return this.status.hasFlag(flag);
    }

    @Override
    public boolean isHibernating() {
        RouterDescriptor rd = this.downcastDescriptor();
        if (rd == null) {
            return false;
        }
        return rd.isHibernating();
    }

    @Override
    public boolean isRunning() {
        return this.hasFlag("Running");
    }

    @Override
    public boolean isValid() {
        return this.hasFlag("Valid");
    }

    @Override
    public boolean isBadExit() {
        return this.hasFlag("BadExit");
    }

    @Override
    public boolean isPossibleGuard() {
        return this.hasFlag("Guard");
    }

    @Override
    public boolean isExit() {
        return this.hasFlag("Exit");
    }

    @Override
    public boolean isFast() {
        return this.hasFlag("Fast");
    }

    @Override
    public boolean isStable() {
        return this.hasFlag("Stable");
    }

    @Override
    public boolean isHSDirectory() {
        return this.hasFlag("HSDir");
    }

    @Override
    public int getDirectoryPort() {
        return this.status.getDirectoryPort();
    }

    @Override
    public HexDigest getIdentityHash() {
        return this.identityHash;
    }

    @Override
    public TorPublicKey getIdentityKey() {
        RouterDescriptor rd = this.downcastDescriptor();
        if (rd != null) {
            return rd.getIdentityKey();
        }
        return null;
    }

    @Override
    public String getNickname() {
        return this.status.getNickname();
    }

    @Override
    public int getOnionPort() {
        return this.status.getRouterPort();
    }

    @Override
    public TorPublicKey getOnionKey() {
        this.refreshDescriptor();
        if (this.descriptor != null) {
            return this.descriptor.getOnionKey();
        }
        return null;
    }

    @Override
    public byte[] getNTorOnionKey() {
        this.refreshDescriptor();
        if (this.descriptor != null) {
            return this.descriptor.getNTorOnionKey();
        }
        return null;
    }

    @Override
    public boolean hasBandwidth() {
        return this.status.hasBandwidth();
    }

    @Override
    public int getEstimatedBandwidth() {
        return this.status.getEstimatedBandwidth();
    }

    @Override
    public int getMeasuredBandwidth() {
        return this.status.getMeasuredBandwidth();
    }

    @Override
    public Set<String> getFamilyMembers() {
        this.refreshDescriptor();
        if (this.descriptor != null) {
            return this.descriptor.getFamilyMembers();
        }
        return Collections.emptySet();
    }

    @Override
    public int getAverageBandwidth() {
        RouterDescriptor rd = this.downcastDescriptor();
        if (rd == null) {
            return 0;
        }
        return rd.getAverageBandwidth();
    }

    @Override
    public int getBurstBandwidth() {
        RouterDescriptor rd = this.downcastDescriptor();
        if (rd == null) {
            return 0;
        }
        return rd.getBurstBandwidth();
    }

    @Override
    public int getObservedBandwidth() {
        RouterDescriptor rd = this.downcastDescriptor();
        if (rd == null) {
            return 0;
        }
        return rd.getObservedBandwidth();
    }

    @Override
    public boolean exitPolicyAccepts(IPv4Address address, int port) {
        this.refreshDescriptor();
        if (this.descriptor == null) {
            return false;
        }
        if (address == null) {
            return this.descriptor.exitPolicyAccepts(port);
        }
        return this.descriptor.exitPolicyAccepts(address, port);
    }

    @Override
    public boolean exitPolicyAccepts(int port) {
        return this.exitPolicyAccepts(null, port);
    }

    public String toString() {
        return "Router[" + this.getNickname() + " (" + this.getAddress() + ":" + this.getOnionPort() + ")]";
    }

    @Override
    public String getCountryCode() {
        String cc = this.cachedCountryCode;
        if (cc == null) {
            this.cachedCountryCode = cc = CountryCodeService.getInstance().getCountryCodeForAddress(this.getAddress());
        }
        return cc;
    }

    private RouterDescriptor downcastDescriptor() {
        this.refreshDescriptor();
        if (this.descriptor instanceof RouterDescriptor) {
            return (RouterDescriptor)this.descriptor;
        }
        return null;
    }
}

