/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentObject;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.NameIntegerParameter;
import com.subgraph.orchid.encoders.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class DocumentFieldParserImpl
implements DocumentFieldParser {
    private static final Logger logger = Logger.getLogger(DocumentFieldParserImpl.class.getName());
    private static final String BEGIN_TAG = "-----BEGIN";
    private static final String END_TAG = "-----END";
    private static final String TAG_DELIMITER = "-----";
    private static final String DEFAULT_DELIMITER = " ";
    private final ByteBuffer inputBuffer;
    private final SimpleDateFormat dateFormat;
    private String delimiter = " ";
    private String currentKeyword;
    private List<String> currentItems;
    private int currentItemsPosition;
    private boolean recognizeOpt;
    private String signatureIgnoreToken;
    private boolean isProcessingSignedEntity = false;
    private TorMessageDigest signatureDigest;
    private TorMessageDigest signatureDigest256;
    private StringBuilder rawDocumentBuffer;
    private DocumentParsingHandler callbackHandler;

    public DocumentFieldParserImpl(ByteBuffer buffer) {
        buffer.rewind();
        this.inputBuffer = buffer;
        this.rawDocumentBuffer = new StringBuilder();
        this.dateFormat = DocumentFieldParserImpl.createDateFormat();
    }

    private static SimpleDateFormat createDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        format.setLenient(false);
        return format;
    }

    @Override
    public String parseNickname() {
        return this.getItem();
    }

    @Override
    public String parseString() {
        return this.getItem();
    }

    @Override
    public void setRecognizeOpt() {
        this.recognizeOpt = true;
    }

    @Override
    public void setHandler(DocumentParsingHandler handler) {
        this.callbackHandler = handler;
    }

    @Override
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public int argumentsRemaining() {
        return this.currentItems.size() - this.currentItemsPosition;
    }

    private String getItem() {
        if (this.currentItemsPosition >= this.currentItems.size()) {
            throw new TorParsingException("Overrun while reading arguments");
        }
        return this.currentItems.get(this.currentItemsPosition++);
    }

    @Override
    public String parseConcatenatedString() {
        StringBuilder result = new StringBuilder();
        while (this.argumentsRemaining() > 0) {
            if (result.length() > 0) {
                result.append(DEFAULT_DELIMITER);
            }
            result.append(this.getItem());
        }
        return result.toString();
    }

    @Override
    public boolean parseBoolean() {
        int i = this.parseInteger();
        if (i == 1) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        throw new TorParsingException("Illegal boolean value: " + i);
    }

    @Override
    public int parseInteger() {
        return this.parseInteger(this.getItem());
    }

    @Override
    public int parseInteger(String item) {
        try {
            return Integer.parseInt(item);
        }
        catch (NumberFormatException e) {
            throw new TorParsingException("Failed to parse expected integer value: " + item);
        }
    }

    @Override
    public int[] parseIntegerList() {
        String item = this.getItem();
        String[] ns = item.split(",");
        int[] result = new int[ns.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.parseInteger(ns[i]);
        }
        return result;
    }

    @Override
    public int parsePort() {
        return this.parsePort(this.getItem());
    }

    @Override
    public int parsePort(String item) {
        int port = this.parseInteger(item);
        if (port < 0 || port > 65535) {
            throw new TorParsingException("Illegal port value: " + port);
        }
        return port;
    }

    @Override
    public Timestamp parseTimestamp() {
        String timeAndDate = this.getItem() + DEFAULT_DELIMITER + this.getItem();
        try {
            return new Timestamp(this.dateFormat.parse(timeAndDate));
        }
        catch (ParseException e) {
            throw new TorParsingException("Could not parse timestamp value: " + timeAndDate);
        }
    }

    @Override
    public HexDigest parseHexDigest() {
        return HexDigest.createFromString(this.parseString());
    }

    @Override
    public HexDigest parseBase32Digest() {
        return HexDigest.createFromBase32String(this.parseString());
    }

    @Override
    public HexDigest parseFingerprint() {
        return HexDigest.createFromString(this.parseConcatenatedString());
    }

    @Override
    public void verifyExpectedArgumentCount(String keyword, int argumentCount) {
        this.verifyExpectedArgumentCount(keyword, argumentCount, argumentCount);
    }

    private void verifyExpectedArgumentCount(String keyword, int expectedMin, int expectedMax) {
        int argumentCount = this.argumentsRemaining();
        if (expectedMin != -1 && argumentCount < expectedMin) {
            throw new TorParsingException("Not enough arguments for keyword '" + keyword + "' expected " + expectedMin + " and got " + argumentCount);
        }
        if (expectedMax != -1 && argumentCount > expectedMax) {
            throw new TorParsingException("Too many arguments for keyword '" + keyword + "' expected " + expectedMax + " and got " + argumentCount);
        }
    }

    @Override
    public byte[] parseBase64Data() {
        StringBuilder string = new StringBuilder(this.getItem());
        switch (string.length() % 4) {
            case 2: {
                string.append("==");
                break;
            }
            case 3: {
                string.append("=");
                break;
            }
        }
        try {
            return Base64.decode(string.toString().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TorException(e);
        }
    }

    @Override
    public IPv4Address parseAddress() {
        return IPv4Address.createFromString(this.getItem());
    }

    @Override
    public TorPublicKey parsePublicKey() {
        DocumentObject documentObject = this.parseObject();
        return TorPublicKey.createFromPEMBuffer(documentObject.getContent());
    }

    @Override
    public byte[] parseNtorPublicKey() {
        byte[] key = this.parseBase64Data();
        if (key.length != 32) {
            throw new TorParsingException("NTor public key was not expected length after base64 decoding.  Length is " + key.length);
        }
        return key;
    }

    @Override
    public TorSignature parseSignature() {
        DocumentObject documentObject = this.parseObject();
        TorSignature s = TorSignature.createFromPEMBuffer(documentObject.getContent());
        return s;
    }

    @Override
    public NameIntegerParameter parseParameter() {
        String item = this.getItem();
        int eq = item.indexOf(61);
        if (eq == -1) {
            throw new TorParsingException("Parameter not in expected form name=value");
        }
        String name = item.substring(0, eq);
        this.validateParameterName(name);
        int value = this.parseInteger(item.substring(eq + 1));
        return new NameIntegerParameter(name, value);
    }

    private void validateParameterName(String name) {
        if (name.isEmpty()) {
            throw new TorParsingException("Parameter name cannot be empty");
        }
        for (char c : name.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new TorParsingException("Parameter name can only contain letters.  Rejecting: " + name);
        }
    }

    public DocumentObject parseTypedObject(String type) {
        DocumentObject object = this.parseObject();
        if (!type.equals(object.getKeyword())) {
            throw new TorParsingException("Unexpected object type.  Expecting: " + type + ", but got: " + object.getKeyword());
        }
        return object;
    }

    @Override
    public DocumentObject parseObject() {
        String line = this.readLine();
        String keyword = this.parseObjectHeader(line);
        DocumentObject object = new DocumentObject(keyword, line);
        this.parseObjectBody(object, keyword);
        return object;
    }

    private String parseObjectHeader(String headerLine) {
        if (!headerLine.startsWith(BEGIN_TAG) || !headerLine.endsWith(TAG_DELIMITER)) {
            throw new TorParsingException("Did not find expected object start tag.");
        }
        return headerLine.substring(BEGIN_TAG.length() + 1, headerLine.length() - TAG_DELIMITER.length());
    }

    private void parseObjectBody(DocumentObject object, String keyword) {
        String endTag = "-----END " + keyword + TAG_DELIMITER;
        while (true) {
            String line;
            if ((line = this.readLine()) == null) {
                throw new TorParsingException("EOF reached before end of '" + keyword + "' object.");
            }
            if (line.equals(endTag)) {
                object.addFooterLine(line);
                return;
            }
            this.parseObjectContent(object, line);
        }
    }

    private void parseObjectContent(DocumentObject object, String content) {
        object.addContent(content);
    }

    @Override
    public String getCurrentKeyword() {
        return this.currentKeyword;
    }

    @Override
    public void processDocument() {
        if (this.callbackHandler == null) {
            throw new TorException("DocumentFieldParser#processDocument() called with null callbackHandler");
        }
        while (true) {
            String line;
            if ((line = this.readLine()) == null) {
                this.callbackHandler.endOfDocument();
                return;
            }
            if (!this.processLine(line)) continue;
            this.callbackHandler.parseKeywordLine();
        }
    }

    @Override
    public void startSignedEntity() {
        this.isProcessingSignedEntity = true;
        this.signatureDigest = new TorMessageDigest();
        this.signatureDigest256 = new TorMessageDigest(true);
    }

    @Override
    public void endSignedEntity() {
        this.isProcessingSignedEntity = false;
    }

    @Override
    public void setSignatureIgnoreToken(String token) {
        this.signatureIgnoreToken = token;
    }

    @Override
    public TorMessageDigest getSignatureMessageDigest() {
        return this.signatureDigest;
    }

    @Override
    public TorMessageDigest getSignatureMessageDigest256() {
        return this.signatureDigest256;
    }

    private void updateRawDocument(String line) {
        this.rawDocumentBuffer.append(line);
        this.rawDocumentBuffer.append('\n');
    }

    @Override
    public String getRawDocument() {
        return this.rawDocumentBuffer.toString();
    }

    @Override
    public void resetRawDocument() {
        this.rawDocumentBuffer = new StringBuilder();
    }

    @Override
    public void resetRawDocument(String initialContent) {
        this.rawDocumentBuffer = new StringBuilder();
        this.rawDocumentBuffer.append(initialContent);
    }

    @Override
    public boolean verifySignedEntity(TorPublicKey publicKey, TorSignature signature) {
        this.isProcessingSignedEntity = false;
        return publicKey.verifySignature(signature, this.signatureDigest);
    }

    private String readLine() {
        String line = this.nextLineFromInputBuffer();
        if (line != null) {
            this.updateCurrentSignature(line);
            this.updateRawDocument(line);
        }
        return line;
    }

    private String nextLineFromInputBuffer() {
        if (!this.inputBuffer.hasRemaining()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (this.inputBuffer.hasRemaining()) {
            char c = (char)(this.inputBuffer.get() & 0xFF);
            if (c == '\n') {
                return sb.toString();
            }
            if (c == '\r') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private void updateCurrentSignature(String line) {
        if (!this.isProcessingSignedEntity) {
            return;
        }
        if (this.signatureIgnoreToken != null && line.startsWith(this.signatureIgnoreToken)) {
            return;
        }
        this.signatureDigest.update(line + "\n");
        this.signatureDigest256.update(line + "\n");
    }

    private boolean processLine(String line) {
        List<String> lineItems = Arrays.asList(line.split(this.delimiter));
        if (lineItems.size() == 0 || lineItems.get(0).length() == 0) {
            return false;
        }
        this.currentKeyword = lineItems.get(0);
        this.currentItems = lineItems;
        this.currentItemsPosition = 1;
        if (this.recognizeOpt && this.currentKeyword.equals("opt") && lineItems.size() > 1) {
            this.currentKeyword = lineItems.get(1);
            this.currentItemsPosition = 2;
        }
        return true;
    }

    @Override
    public void logDebug(String message) {
        logger.fine(message);
    }

    @Override
    public void logError(String message) {
        logger.warning(message);
    }

    @Override
    public void logWarn(String message) {
        logger.info(message);
    }
}

