/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.Tor;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TorRFC5869KeyDerivation {
    private static final String PROTOID = "ntor-curve25519-sha256-1";
    private static final String M_EXPAND = "ntor-curve25519-sha256-1:key_expand";
    private static final byte[] M_EXPAND_BYTES = "ntor-curve25519-sha256-1:key_expand".getBytes(Tor.getDefaultCharset());
    private final byte[] seed;

    public TorRFC5869KeyDerivation(byte[] seed) {
        this.seed = new byte[seed.length];
        System.arraycopy(seed, 0, this.seed, 0, seed.length);
    }

    public void deriveKeys(byte[] keyMaterialOut, byte[] verifyHashOut) {
        ByteBuffer keyData = this.deriveKeys(keyMaterialOut.length + verifyHashOut.length);
        keyData.get(keyMaterialOut);
        keyData.get(verifyHashOut);
    }

    public ByteBuffer deriveKeys(int length) {
        int round = 1;
        ByteBuffer bb = this.makeBuffer(length);
        byte[] macOutput = null;
        while (bb.hasRemaining()) {
            if ((macOutput = this.expandRound(round, macOutput)).length > bb.remaining()) {
                bb.put(macOutput, 0, bb.remaining());
            } else {
                bb.put(macOutput);
            }
            ++round;
        }
        bb.flip();
        return bb;
    }

    private byte[] expandRound(int round, byte[] priorMac) {
        ByteBuffer bb;
        if (round == 1) {
            bb = this.makeBuffer(M_EXPAND_BYTES.length + 1);
        } else {
            bb = this.makeBuffer(M_EXPAND_BYTES.length + 32 + 1);
            bb.put(priorMac);
        }
        bb.put(M_EXPAND_BYTES);
        bb.put((byte)round);
        Mac mac = this.createMacInstance();
        return mac.doFinal(bb.array());
    }

    private ByteBuffer makeBuffer(int len) {
        byte[] bs = new byte[len];
        return ByteBuffer.wrap(bs);
    }

    private Mac createMacInstance() {
        SecretKeySpec keyspec = new SecretKeySpec(this.seed, "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keyspec);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not create HmacSHA256 instance: " + e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Could not create HmacSHA256 instance: " + e);
        }
    }
}

