/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.circuits.hs.HSAuthentication;
import com.subgraph.orchid.circuits.hs.HSAuthenticationException;
import com.subgraph.orchid.circuits.hs.HSDescriptor;
import com.subgraph.orchid.circuits.hs.HSDescriptorCookie;
import com.subgraph.orchid.circuits.hs.HSDescriptorKeyword;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.circuits.hs.IntroductionPoint;
import com.subgraph.orchid.circuits.hs.IntroductionPointParser;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.directory.DocumentFieldParserImpl;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentObject;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;
import com.subgraph.orchid.encoders.Base64;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class HSDescriptorParser
implements DocumentParser<HSDescriptor> {
    private static final Logger logger = Logger.getLogger(HSDescriptor.class.getName());
    private final DocumentFieldParser fieldParser;
    private final HSDescriptor descriptor;
    private final HSAuthentication authentication;
    private DocumentParsingResultHandler<HSDescriptor> resultHandler;

    public HSDescriptorParser(HiddenService hiddenService, DocumentFieldParser fieldParser) {
        this(hiddenService, fieldParser, null);
    }

    public HSDescriptorParser(HiddenService hiddenService, DocumentFieldParser fieldParser, HSDescriptorCookie cookie) {
        this.fieldParser = fieldParser;
        this.fieldParser.setHandler(this.createParsingHandler());
        this.descriptor = new HSDescriptor(hiddenService);
        this.authentication = new HSAuthentication(cookie);
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void parseKeywordLine() {
                HSDescriptorParser.this.processKeywordLine();
            }

            @Override
            public void endOfDocument() {
            }
        };
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<HSDescriptor> resultHandler) {
        this.resultHandler = resultHandler;
        this.fieldParser.startSignedEntity();
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<HSDescriptor> parse() {
        BasicDocumentParsingResult<HSDescriptor> result = new BasicDocumentParsingResult<HSDescriptor>();
        this.parse((DocumentParsingResultHandler<HSDescriptor>)result);
        return result;
    }

    private void processKeywordLine() {
        HSDescriptorKeyword keyword = HSDescriptorKeyword.findKeyword(this.fieldParser.getCurrentKeyword());
        if (!keyword.equals((Object)HSDescriptorKeyword.UNKNOWN_KEYWORD)) {
            this.processKeyword(keyword);
        }
    }

    private void processKeyword(HSDescriptorKeyword keyword) {
        switch (keyword) {
            case RENDEZVOUS_SERVICE_DESCRIPTOR: {
                this.descriptor.setDescriptorId(this.fieldParser.parseBase32Digest());
                break;
            }
            case VERSION: {
                if (this.fieldParser.parseInteger() == 2) break;
                throw new TorParsingException("Unexpected Descriptor version");
            }
            case PERMANENT_KEY: {
                this.descriptor.setPermanentKey(this.fieldParser.parsePublicKey());
                break;
            }
            case SECRET_ID_PART: {
                this.descriptor.setSecretIdPart(this.fieldParser.parseBase32Digest());
                break;
            }
            case PUBLICATION_TIME: {
                this.descriptor.setPublicationTime(this.fieldParser.parseTimestamp());
                break;
            }
            case PROTOCOL_VERSIONS: {
                this.descriptor.setProtocolVersions(this.fieldParser.parseIntegerList());
                break;
            }
            case INTRODUCTION_POINTS: {
                this.processIntroductionPoints();
                break;
            }
            case SIGNATURE: {
                this.processSignature();
                break;
            }
        }
    }

    private void processIntroductionPoints() {
        DocumentObject ob = this.fieldParser.parseObject();
        ByteBuffer buffer = this.createIntroductionPointBuffer(ob);
        IntroductionPointParser parser = new IntroductionPointParser(new DocumentFieldParserImpl(buffer));
        parser.parse(new DocumentParsingResultHandler<IntroductionPoint>(){

            @Override
            public void documentParsed(IntroductionPoint document) {
                logger.fine("adding intro point " + document.getIdentity());
                HSDescriptorParser.this.descriptor.addIntroductionPoint(document);
            }

            @Override
            public void documentInvalid(IntroductionPoint document, String message) {
                logger.info("Invalid introduction point received");
            }

            @Override
            public void parsingError(String message) {
                logger.info("Error parsing introduction points: " + message);
            }
        });
    }

    private ByteBuffer createIntroductionPointBuffer(DocumentObject ob) {
        byte[] content = Base64.decode(ob.getContent(false));
        if (content[0] == 105) {
            return ByteBuffer.wrap(content);
        }
        try {
            byte[] decrypted = this.authentication.decryptIntroductionPoints(content);
            return ByteBuffer.wrap(decrypted);
        }
        catch (HSAuthenticationException e) {
            throw new TorParsingException("Failed to decrypt introduction points: " + e.getMessage());
        }
    }

    private void processSignature() {
        this.fieldParser.endSignedEntity();
        TorSignature signature = this.fieldParser.parseSignature();
        if (!this.fieldParser.verifySignedEntity(this.descriptor.getPermanentKey(), signature)) {
            this.resultHandler.documentInvalid(this.descriptor, "Signature verification failed");
            this.fieldParser.logWarn("Signature failed for descriptor: " + this.descriptor.getDescriptorId().toBase32());
            return;
        }
        this.resultHandler.documentParsed(this.descriptor);
    }
}

