/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.guards;

import com.subgraph.orchid.BridgeRouter;
import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.geoip.CountryCodeService;
import java.util.Collections;
import java.util.Set;

public class BridgeRouterImpl
implements BridgeRouter {
    private final IPv4Address address;
    private final int port;
    private HexDigest identity;
    private Descriptor descriptor;
    private volatile String cachedCountryCode;

    BridgeRouterImpl(IPv4Address address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    public HexDigest getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(HexDigest identity) {
        this.identity = identity;
    }

    @Override
    public void setDescriptor(RouterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeRouterImpl other = (BridgeRouterImpl)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.port == other.port;
    }

    @Override
    public String getNickname() {
        return this.toString();
    }

    @Override
    public String getCountryCode() {
        String cc = this.cachedCountryCode;
        if (cc == null) {
            this.cachedCountryCode = cc = CountryCodeService.getInstance().getCountryCodeForAddress(this.getAddress());
        }
        return cc;
    }

    @Override
    public int getOnionPort() {
        return this.port;
    }

    @Override
    public int getDirectoryPort() {
        return 0;
    }

    @Override
    public TorPublicKey getIdentityKey() {
        return null;
    }

    @Override
    public HexDigest getIdentityHash() {
        return this.identity;
    }

    @Override
    public boolean isDescriptorDownloadable() {
        return false;
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public Descriptor getCurrentDescriptor() {
        return this.descriptor;
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return null;
    }

    @Override
    public HexDigest getMicrodescriptorDigest() {
        return null;
    }

    @Override
    public TorPublicKey getOnionKey() {
        if (this.descriptor != null) {
            return this.descriptor.getOnionKey();
        }
        return null;
    }

    @Override
    public byte[] getNTorOnionKey() {
        if (this.descriptor != null) {
            return this.descriptor.getNTorOnionKey();
        }
        return null;
    }

    @Override
    public boolean hasBandwidth() {
        return false;
    }

    @Override
    public int getEstimatedBandwidth() {
        return 0;
    }

    @Override
    public int getMeasuredBandwidth() {
        return 0;
    }

    @Override
    public Set<String> getFamilyMembers() {
        if (this.descriptor != null) {
            return this.descriptor.getFamilyMembers();
        }
        return Collections.emptySet();
    }

    @Override
    public int getAverageBandwidth() {
        return 0;
    }

    @Override
    public int getBurstBandwidth() {
        return 0;
    }

    @Override
    public int getObservedBandwidth() {
        return 0;
    }

    @Override
    public boolean isHibernating() {
        if (this.descriptor instanceof RouterDescriptor) {
            return ((RouterDescriptor)this.descriptor).isHibernating();
        }
        return false;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isBadExit() {
        return false;
    }

    @Override
    public boolean isPossibleGuard() {
        return true;
    }

    @Override
    public boolean isExit() {
        return false;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isHSDirectory() {
        return false;
    }

    @Override
    public boolean exitPolicyAccepts(IPv4Address address, int port) {
        return false;
    }

    @Override
    public boolean exitPolicyAccepts(int port) {
        return false;
    }

    public String toString() {
        return "[Bridge " + this.address + ":" + this.port + "]";
    }
}

