/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.StreamImpl;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class DirectoryCircuitImpl
extends CircuitImpl
implements DirectoryCircuit {
    protected DirectoryCircuitImpl(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        super(circuitManager, prechosenPath);
    }

    @Override
    public Stream openDirectoryStream(long timeout, boolean autoclose) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        StreamImpl stream = this.createNewStream(autoclose);
        try {
            stream.openDirectory(timeout);
            return stream;
        }
        catch (Exception e) {
            this.removeStream(stream);
            return this.processStreamOpenException(e);
        }
    }

    @Override
    protected List<Router> choosePathForCircuit(CircuitPathChooser pathChooser) throws InterruptedException, PathSelectionFailedException {
        if (this.prechosenPath != null) {
            return this.prechosenPath;
        }
        return pathChooser.chooseDirectoryPath();
    }

    @Override
    protected String getCircuitTypeLabel() {
        return "Directory";
    }
}

