/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitBuildHandler;
import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.Connection;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.ExitCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.Threading;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.CircuitBuildTask;
import com.subgraph.orchid.circuits.CircuitCreationRequest;
import com.subgraph.orchid.circuits.CircuitCreationTask;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.PendingExitStreams;
import com.subgraph.orchid.circuits.StreamExitRequest;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.circuits.guards.EntryGuards;
import com.subgraph.orchid.circuits.hs.HiddenServiceManager;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.directory.downloader.DirectoryDownloaderImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class CircuitManagerImpl
implements CircuitManager,
DashboardRenderable {
    private static final int OPEN_DIRECTORY_STREAM_RETRY_COUNT = 5;
    private static final int OPEN_DIRECTORY_STREAM_TIMEOUT = 10000;
    private final TorConfig config;
    private final Directory directory;
    private final ConnectionCache connectionCache;
    private final Set<CircuitImpl> activeCircuits;
    private final Queue<InternalCircuit> cleanInternalCircuits;
    private int requestedInternalCircuitCount = 0;
    private int pendingInternalCircuitCount = 0;
    private final TorRandom random;
    private final PendingExitStreams pendingExitStreams;
    private final ScheduledExecutorService scheduledExecutor = Threading.newSingleThreadScheduledPool("CircuitManager worker");
    private final CircuitCreationTask circuitCreationTask;
    private final TorInitializationTracker initializationTracker;
    private final CircuitPathChooser pathChooser;
    private final HiddenServiceManager hiddenServiceManager;
    private final ReentrantLock lock = Threading.lock("circuitManager");
    private boolean isBuilding = false;

    public CircuitManagerImpl(TorConfig config, DirectoryDownloaderImpl directoryDownloader, Directory directory, ConnectionCache connectionCache, TorInitializationTracker initializationTracker) {
        this.config = config;
        this.directory = directory;
        this.connectionCache = connectionCache;
        this.pathChooser = CircuitPathChooser.create(config, directory);
        if (config.getUseEntryGuards() || config.getUseBridges()) {
            this.pathChooser.enableEntryGuards(new EntryGuards(config, connectionCache, directoryDownloader, directory));
        }
        this.pendingExitStreams = new PendingExitStreams(config);
        this.circuitCreationTask = new CircuitCreationTask(config, directory, connectionCache, this.pathChooser, this, initializationTracker);
        this.activeCircuits = new HashSet<CircuitImpl>();
        this.cleanInternalCircuits = new LinkedList<InternalCircuit>();
        this.random = new TorRandom();
        this.initializationTracker = initializationTracker;
        this.hiddenServiceManager = new HiddenServiceManager(config, directory, this);
        directoryDownloader.setCircuitManager(this);
    }

    @Override
    public void startBuildingCircuits() {
        this.lock.lock();
        try {
            this.isBuilding = true;
            this.scheduledExecutor.scheduleAtFixedRate(this.circuitCreationTask, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBuildingCircuits(boolean killCircuits) {
        this.lock.lock();
        try {
            this.isBuilding = false;
            this.scheduledExecutor.shutdownNow();
        }
        finally {
            this.lock.unlock();
        }
        if (killCircuits) {
            ArrayList<CircuitImpl> circuits;
            Set<CircuitImpl> set = this.activeCircuits;
            synchronized (set) {
                circuits = new ArrayList<CircuitImpl>(this.activeCircuits);
            }
            for (CircuitImpl c : circuits) {
                c.destroyCircuit();
            }
        }
    }

    public ExitCircuit createNewExitCircuit(Router exitRouter) {
        return CircuitImpl.createExitCircuit(this, exitRouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveCircuit(CircuitImpl circuit) {
        boolean doDestroy;
        Set<CircuitImpl> set = this.activeCircuits;
        synchronized (set) {
            this.activeCircuits.add(circuit);
            this.activeCircuits.notifyAll();
        }
        this.lock.lock();
        try {
            doDestroy = !this.isBuilding;
        }
        finally {
            this.lock.unlock();
        }
        if (doDestroy) {
            circuit.destroyCircuit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActiveCircuit(CircuitImpl circuit) {
        Set<CircuitImpl> set = this.activeCircuits;
        synchronized (set) {
            this.activeCircuits.remove(circuit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActiveCircuitCount() {
        Set<CircuitImpl> set = this.activeCircuits;
        synchronized (set) {
            return this.activeCircuits.size();
        }
    }

    Set<Circuit> getPendingCircuits() {
        return this.getCircuitsByFilter(new CircuitFilter(){

            @Override
            public boolean filter(Circuit circuit) {
                return circuit.isPending();
            }
        });
    }

    int getPendingCircuitCount() {
        this.lock.lock();
        try {
            int n = this.getPendingCircuits().size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Circuit> getCircuitsByFilter(CircuitFilter filter) {
        HashSet<Circuit> result = new HashSet<Circuit>();
        HashSet<CircuitImpl> circuits = new HashSet<CircuitImpl>();
        Set<CircuitImpl> set = this.activeCircuits;
        synchronized (set) {
            circuits.addAll(this.activeCircuits);
        }
        for (CircuitImpl c : circuits) {
            if (filter != null && !filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    List<ExitCircuit> getRandomlyOrderedListOfExitCircuits() {
        Set<Circuit> notDirectory = this.getCircuitsByFilter(new CircuitFilter(){

            @Override
            public boolean filter(Circuit circuit) {
                boolean exitType = circuit instanceof ExitCircuit;
                return exitType && !circuit.isMarkedForClose() && circuit.isConnected();
            }
        });
        ArrayList<ExitCircuit> ac = new ArrayList<ExitCircuit>();
        for (Circuit c : notDirectory) {
            if (!(c instanceof ExitCircuit)) continue;
            ac.add((ExitCircuit)c);
        }
        int sz = ac.size();
        for (int i = 0; i < sz; ++i) {
            ExitCircuit tmp = ac.get(i);
            int swapIdx = this.random.nextInt(sz);
            ac.set(i, ac.get(swapIdx));
            ac.set(swapIdx, tmp);
        }
        return ac;
    }

    @Override
    public Stream openExitStreamTo(String hostname, int port) throws InterruptedException, TimeoutException, OpenFailedException {
        if (hostname.endsWith(".onion")) {
            return this.hiddenServiceManager.getStreamTo(hostname, port);
        }
        this.validateHostname(hostname);
        this.circuitCreationTask.predictPort(port);
        return this.pendingExitStreams.openExitStream(hostname, port);
    }

    private void validateHostname(String hostname) throws OpenFailedException {
        this.maybeRejectInternalAddress(hostname);
        if (hostname.toLowerCase().endsWith(".onion")) {
            throw new OpenFailedException("Hidden services not supported");
        }
        if (hostname.toLowerCase().endsWith(".exit")) {
            throw new OpenFailedException(".exit addresses are not supported");
        }
    }

    private void maybeRejectInternalAddress(String hostname) throws OpenFailedException {
        if (IPv4Address.isValidIPv4AddressString(hostname)) {
            this.maybeRejectInternalAddress(IPv4Address.createFromString(hostname));
        }
    }

    private void maybeRejectInternalAddress(IPv4Address address) throws OpenFailedException {
        InetAddress inetAddress = address.toInetAddress();
        if (inetAddress.isSiteLocalAddress() && this.config.getClientRejectInternalAddress()) {
            throw new OpenFailedException("Rejecting stream target with internal address: " + address);
        }
    }

    @Override
    public Stream openExitStreamTo(IPv4Address address, int port) throws InterruptedException, TimeoutException, OpenFailedException {
        this.maybeRejectInternalAddress(address);
        this.circuitCreationTask.predictPort(port);
        return this.pendingExitStreams.openExitStream(address, port);
    }

    public List<StreamExitRequest> getPendingExitStreams() {
        return this.pendingExitStreams.getUnreservedPendingRequests();
    }

    @Override
    public Stream openDirectoryStream() throws OpenFailedException, InterruptedException, TimeoutException {
        return this.openDirectoryStream(0);
    }

    @Override
    public Stream openDirectoryStream(int purpose) throws OpenFailedException, InterruptedException {
        int requestEventCode = this.purposeToEventCode(purpose, false);
        int loadingEventCode = this.purposeToEventCode(purpose, true);
        int failCount = 0;
        while (failCount < 5) {
            DirectoryCircuit circuit = this.openDirectoryCircuit();
            if (requestEventCode > 0) {
                this.initializationTracker.notifyEvent(requestEventCode);
            }
            try {
                Stream stream = circuit.openDirectoryStream(10000L, true);
                if (loadingEventCode > 0) {
                    this.initializationTracker.notifyEvent(loadingEventCode);
                }
                return stream;
            }
            catch (StreamConnectFailedException e) {
                circuit.markForClose();
                ++failCount;
            }
            catch (TimeoutException e) {
                circuit.markForClose();
            }
        }
        throw new OpenFailedException("Retry count exceeded opening directory stream");
    }

    @Override
    public DirectoryCircuit openDirectoryCircuit() throws OpenFailedException {
        for (int failCount = 0; failCount < 5; ++failCount) {
            DirectoryCircuit circuit = CircuitImpl.createDirectoryCircuit(this);
            if (!this.tryOpenCircuit(circuit, true, true)) continue;
            return circuit;
        }
        throw new OpenFailedException("Could not create circuit for directory stream");
    }

    private int purposeToEventCode(int purpose, boolean getLoadingEvent) {
        switch (purpose) {
            case 1: {
                return getLoadingEvent ? 25 : 20;
            }
            case 2: {
                return getLoadingEvent ? 40 : 35;
            }
            case 3: {
                return getLoadingEvent ? 50 : 45;
            }
        }
        return 0;
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) throws IOException {
        if ((flags & 8) == 0) {
            return;
        }
        renderer.renderComponent(writer, flags, this.connectionCache);
        renderer.renderComponent(writer, flags, this.circuitCreationTask.getCircuitPredictor());
        writer.println("[Circuit Manager]");
        writer.println();
        for (Circuit c : this.getCircuitsByFilter(null)) {
            renderer.renderComponent(writer, flags, c);
        }
    }

    @Override
    public InternalCircuit getCleanInternalCircuit() throws InterruptedException {
        Queue<InternalCircuit> queue = this.cleanInternalCircuits;
        synchronized (queue) {
            InternalCircuit internalCircuit;
            try {
                ++this.requestedInternalCircuitCount;
                while (this.cleanInternalCircuits.isEmpty()) {
                    this.cleanInternalCircuits.wait();
                }
                internalCircuit = this.cleanInternalCircuits.remove();
                --this.requestedInternalCircuitCount;
            }
            catch (Throwable throwable) {
                --this.requestedInternalCircuitCount;
                throw throwable;
            }
            return internalCircuit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNeededCleanCircuitCount(boolean isPredicted) {
        Queue<InternalCircuit> queue = this.cleanInternalCircuits;
        synchronized (queue) {
            int predictedCount = isPredicted ? 2 : 0;
            int needed = Math.max(this.requestedInternalCircuitCount, predictedCount) - (this.pendingInternalCircuitCount + this.cleanInternalCircuits.size());
            if (needed < 0) {
                return 0;
            }
            return needed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementPendingInternalCircuitCount() {
        Queue<InternalCircuit> queue = this.cleanInternalCircuits;
        synchronized (queue) {
            ++this.pendingInternalCircuitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementPendingInternalCircuitCount() {
        Queue<InternalCircuit> queue = this.cleanInternalCircuits;
        synchronized (queue) {
            --this.pendingInternalCircuitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCleanInternalCircuit(InternalCircuit circuit) {
        Queue<InternalCircuit> queue = this.cleanInternalCircuits;
        synchronized (queue) {
            --this.pendingInternalCircuitCount;
            this.cleanInternalCircuits.add(circuit);
            this.cleanInternalCircuits.notifyAll();
        }
    }

    boolean isNtorEnabled() {
        switch (this.config.getUseNTorHandshake()) {
            case AUTO: {
                return this.isNtorEnabledInConsensus();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        throw new IllegalArgumentException("getUseNTorHandshake() returned " + (Object)((Object)this.config.getUseNTorHandshake()));
    }

    boolean isNtorEnabledInConsensus() {
        ConsensusDocument consensus = this.directory.getCurrentConsensusDocument();
        return consensus != null && consensus.getUseNTorHandshake();
    }

    @Override
    public DirectoryCircuit openDirectoryCircuitTo(List<Router> path) throws OpenFailedException {
        DirectoryCircuit circuit = CircuitImpl.createDirectoryCircuitTo(this, path);
        if (!this.tryOpenCircuit(circuit, true, false)) {
            throw new OpenFailedException("Could not create directory circuit for path");
        }
        return circuit;
    }

    @Override
    public ExitCircuit openExitCircuitTo(List<Router> path) throws OpenFailedException {
        ExitCircuit circuit = CircuitImpl.createExitCircuitTo(this, path);
        if (!this.tryOpenCircuit(circuit, false, false)) {
            throw new OpenFailedException("Could not create exit circuit for path");
        }
        return circuit;
    }

    @Override
    public InternalCircuit openInternalCircuitTo(List<Router> path) throws OpenFailedException {
        InternalCircuit circuit = CircuitImpl.createInternalCircuitTo(this, path);
        if (!this.tryOpenCircuit(circuit, false, false)) {
            throw new OpenFailedException("Could not create internal circuit for path");
        }
        return circuit;
    }

    private boolean tryOpenCircuit(Circuit circuit, boolean isDirectory, boolean trackInitialization) {
        DirectoryCircuitResult result = new DirectoryCircuitResult();
        CircuitCreationRequest req = new CircuitCreationRequest(this.pathChooser, circuit, result, isDirectory);
        CircuitBuildTask task = new CircuitBuildTask(req, this.connectionCache, this.isNtorEnabled(), trackInitialization ? this.initializationTracker : null);
        task.run();
        return result.isSuccessful();
    }

    private static class DirectoryCircuitResult
    implements CircuitBuildHandler {
        private boolean isFailed;

        private DirectoryCircuitResult() {
        }

        @Override
        public void connectionCompleted(Connection connection) {
        }

        @Override
        public void nodeAdded(CircuitNode node) {
        }

        @Override
        public void circuitBuildCompleted(Circuit circuit) {
        }

        @Override
        public void connectionFailed(String reason) {
            this.isFailed = true;
        }

        @Override
        public void circuitBuildFailed(String reason) {
            this.isFailed = true;
        }

        boolean isSuccessful() {
            return !this.isFailed;
        }
    }

    static interface CircuitFilter {
        public boolean filter(Circuit var1);
    }
}

