/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath.android;

import android.content.res.AssetManager;
import java.io.IOException;
import java.io.InputStreamReader;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.core.ClassPathScanException;
import org.avaje.classpath.scanner.internal.FileCopyUtils;

public class AndroidResource
implements Resource {
    private final AssetManager assetManager;
    private final String path;
    private final String name;

    public AndroidResource(AssetManager assetManager, String path, String name) {
        this.assetManager = assetManager;
        this.path = path;
        this.name = name;
    }

    public String toString() {
        return this.getLocation();
    }

    public String getLocation() {
        return this.path + "/" + this.name;
    }

    public String getLocationOnDisk() {
        return null;
    }

    public String loadAsString(String encoding) {
        try {
            return FileCopyUtils.copyToString(new InputStreamReader(this.assetManager.open(this.getLocation()), encoding));
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load asset: " + this.getLocation(), e);
        }
    }

    public byte[] loadAsBytes() {
        try {
            return FileCopyUtils.copyToByteArray(this.assetManager.open(this.getLocation()));
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load asset: " + this.getLocation(), e);
        }
    }

    public String getFilename() {
        return this.name;
    }
}

