/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.description.Description;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.error.ShouldMatch;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractAssert<SELF extends AbstractAssert<SELF, ACTUAL>, ACTUAL>
implements Assert<SELF, ACTUAL> {
    public static boolean throwUnsupportedExceptionOnEquals = true;
    private static final String ORG_ASSERTJ = "org.assert";
    @VisibleForTesting
    Objects objects = Objects.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    public final WritableAssertionInfo info;
    @VisibleForTesting
    protected final ACTUAL actual;
    protected final SELF myself;
    private static Representation customRepresentation = null;

    public AbstractAssert(ACTUAL actual, Class<?> selfType) {
        this.myself = (AbstractAssert)selfType.cast(this);
        this.actual = actual;
        this.info = new WritableAssertionInfo(customRepresentation);
    }

    public WritableAssertionInfo getWritableAssertionInfo() {
        return this.info;
    }

    protected void failWithMessage(String errorMessage, Object ... arguments) {
        AssertionError assertionError = Failures.instance().failureIfErrorMessageIsOverridden(this.info);
        if (assertionError == null) {
            String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]);
            assertionError = new AssertionError((Object)(description + String.format(errorMessage, arguments)));
        }
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(assertionError);
        throw assertionError;
    }

    protected void throwAssertionError(ErrorMessageFactory errorMessageFactory) {
        AssertionError failure = Failures.instance().failure((AssertionInfo)this.info, errorMessageFactory);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(failure);
        throw failure;
    }

    private void removeCustomAssertRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (!Failures.instance().isRemoveAssertJRelatedElementsFromStackTrace()) {
            return;
        }
        if (this.isAssertjAssertClass()) {
            return;
        }
        ArrayList<StackTraceElement> filtered = Lists.newArrayList(((Throwable)((Object)assertionError)).getStackTrace());
        for (StackTraceElement element : ((Throwable)((Object)assertionError)).getStackTrace()) {
            if (!this.isElementOfCustomAssert(element)) continue;
            filtered.remove(element);
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[filtered.size()]);
        ((Throwable)((Object)assertionError)).setStackTrace(newStackTrace);
    }

    private boolean isAssertjAssertClass() {
        return this.getClass().getName().startsWith(ORG_ASSERTJ);
    }

    private boolean isElementOfCustomAssert(StackTraceElement stackTraceElement) {
        for (Class<?> currentAssertClass = this.getClass(); currentAssertClass != AbstractAssert.class; currentAssertClass = currentAssertClass.getSuperclass()) {
            if (!stackTraceElement.getClassName().equals(currentAssertClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)this.describedAs(description, args);
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)this.describedAs(description);
    }

    @CheckReturnValue
    protected SELF inHexadecimal() {
        this.info.useHexadecimalRepresentation();
        return this.myself;
    }

    @CheckReturnValue
    protected SELF inBinary() {
        this.info.useBinaryRepresentation();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description, Object ... args) {
        this.info.description(description, args);
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public SELF isEqualTo(Object expected) {
        this.objects.assertEqual(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        this.objects.assertNotEqual(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public void isNull() {
        this.objects.assertNull(this.info, this.actual);
    }

    @Override
    public SELF isNotNull() {
        this.objects.assertNotNull(this.info, this.actual);
        return this.myself;
    }

    @Override
    public SELF isSameAs(Object expected) {
        this.objects.assertSame(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public SELF isNotSameAs(Object other) {
        this.objects.assertNotSame(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF isIn(Object ... values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isNotIn(Object ... values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        this.conditions.assertIs(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        this.conditions.assertIsNot(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        this.conditions.assertHas(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        this.conditions.assertDoesNotHave(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public <T> SELF isInstanceOfSatisfying(Class<T> type, Consumer<T> requirements) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        java.util.Objects.requireNonNull(requirements, "The Consumer<T> expressing the assertions requirements must not be null");
        requirements.accept(this.actual);
        return this.myself;
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        this.objects.assertIsNotInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsNotInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        this.objects.assertHasSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF hasToString(String expectedToString) {
        this.objects.assertHasToString(this.info, this.actual, expectedToString);
        return this.myself;
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        this.objects.assertDoesNotHaveSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsNotExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsNotOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> asList() {
        this.objects.assertIsInstanceOf(this.info, this.actual, List.class);
        return this.newListAssertInstance((List)this.actual);
    }

    @Override
    @CheckReturnValue
    public AbstractCharSequenceAssert<?, String> asString() {
        this.objects.assertIsInstanceOf(this.info, this.actual, String.class);
        return Assertions.assertThat((String)this.actual);
    }

    public String descriptionText() {
        return this.info.descriptionText();
    }

    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        this.info.overridingErrorMessage(Strings.formatIfArgs(newErrorMessage, args));
        return this.myself;
    }

    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        this.overridingErrorMessage(newErrorMessage, args);
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        this.objects = new Objects(new ComparatorBasedComparisonStrategy(customComparator));
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.objects = Objects.instance();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        Failures.instance().enablePrintThreadDump();
        return this.myself;
    }

    @Override
    @CheckReturnValue
    public SELF withRepresentation(Representation representation) {
        this.info.useRepresentation(representation);
        return this.myself;
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        if (throwUnsupportedExceptionOnEquals) {
            throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 1;
    }

    public SELF matches(Predicate<? super ACTUAL> predicate) {
        return this.matches(predicate, PredicateDescription.GIVEN);
    }

    public SELF matches(Predicate<? super ACTUAL> predicate, String predicateDescription) {
        return this.matches(predicate, new PredicateDescription(predicateDescription));
    }

    public SELF satisfies(Consumer<ACTUAL> requirements) {
        java.util.Objects.requireNonNull(requirements, "The Consumer<T> expressing the assertions requirements must not be null");
        requirements.accept(this.actual);
        return this.myself;
    }

    private SELF matches(Predicate<? super ACTUAL> predicate, PredicateDescription predicateDescription) {
        java.util.Objects.requireNonNull(predicate, "The predicate must not be null");
        if (predicate.test(this.actual)) {
            return this.myself;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(this.actual, predicate, predicateDescription));
    }

    public static void setCustomRepresentation(Representation customRepresentation) {
        AbstractAssert.customRepresentation = customRepresentation;
    }

    @Override
    public SELF hasSameHashCodeAs(Object other) {
        this.objects.assertHasSameHashCodeAs(this.info, this.actual, other);
        return this.myself;
    }

    protected <E> AbstractListAssert<?, List<? extends E>, E, ObjectAssert<E>> newListAssertInstance(List<? extends E> newActual) {
        return new ListAssert<E>(newActual);
    }
}

