/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.util.Arrays;

public final class DualValue {
    static final Class<?>[] DEFAULT_ORDERED_COLLECTION_TYPES = Arrays.array(List.class, SortedSet.class, LinkedHashSet.class);
    final FieldLocation fieldLocation;
    final Object actual;
    final Object expected;
    private final int hashCode;

    public DualValue(List<String> path, Object actual, Object expected) {
        this(new FieldLocation(path), actual, expected);
    }

    static DualValue rootDualValue(Object actual, Object expected) {
        return new DualValue(FieldLocation.rootFieldLocation(), actual, expected);
    }

    public DualValue(FieldLocation fieldLocation, Object actualFieldValue, Object expectedFieldValue) {
        this.fieldLocation = Objects.requireNonNull(fieldLocation, "fieldLocation must not be null");
        this.actual = actualFieldValue;
        this.expected = expectedFieldValue;
        this.hashCode = Objects.hash(this.actual, this.expected);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DualValue)) {
            return false;
        }
        DualValue that = (DualValue)other;
        return this.actual == that.actual && this.expected == that.expected;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("DualValue [fielLocation=%s, actual=%s, expected=%s]", this.fieldLocation, this.actual, this.expected);
    }

    public List<String> getDecomposedPath() {
        return Collections.unmodifiableList(this.fieldLocation.getDecomposedPath());
    }

    public String getConcatenatedPath() {
        return this.fieldLocation.getPathToUseInRules();
    }

    public String getFieldName() {
        return this.fieldLocation.getFieldName();
    }

    public boolean isActualJavaType() {
        if (this.actual == null) {
            return false;
        }
        return this.actual.getClass().getName().startsWith("java.");
    }

    public boolean isExpectedFieldAnArray() {
        return Arrays.isArray(this.expected);
    }

    public boolean isActualFieldAnArray() {
        return Arrays.isArray(this.actual);
    }

    public boolean isActualFieldAnOptional() {
        return this.actual instanceof Optional;
    }

    public boolean isActualFieldAnOptionalInt() {
        return this.actual instanceof OptionalInt;
    }

    public boolean isActualFieldAnOptionalLong() {
        return this.actual instanceof OptionalLong;
    }

    public boolean isActualFieldAnOptionalDouble() {
        return this.actual instanceof OptionalDouble;
    }

    public boolean isActualFieldAnEmptyOptionalOfAnyType() {
        return this.isActualFieldAnEmptyOptional() || this.isActualFieldAnEmptyOptionalInt() || this.isActualFieldAnEmptyOptionalLong() || this.isActualFieldAnEmptyOptionalDouble();
    }

    private boolean isActualFieldAnEmptyOptional() {
        return this.isActualFieldAnOptional() && !((Optional)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalInt() {
        return this.isActualFieldAnOptionalInt() && !((OptionalInt)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalLong() {
        return this.isActualFieldAnOptionalLong() && !((OptionalLong)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalDouble() {
        return this.isActualFieldAnOptionalDouble() && !((OptionalDouble)this.actual).isPresent();
    }

    public boolean isExpectedFieldAnOptional() {
        return this.expected instanceof Optional;
    }

    public boolean isActualFieldAMap() {
        return this.actual instanceof Map;
    }

    public boolean isExpectedFieldAMap() {
        return this.expected instanceof Map;
    }

    public boolean isActualFieldASortedMap() {
        return this.actual instanceof SortedMap;
    }

    public boolean isExpectedFieldASortedMap() {
        return this.expected instanceof SortedMap;
    }

    public boolean isActualFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.actual);
    }

    public boolean isExpectedFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.expected);
    }

    public boolean isActualFieldAnIterable() {
        return this.actual instanceof Iterable && !(this.actual instanceof Path);
    }

    public boolean isExpectedFieldAnIterable() {
        return this.expected instanceof Iterable && !(this.expected instanceof Path);
    }

    private static boolean isAnOrderedCollection(Object value) {
        return Stream.of(DEFAULT_ORDERED_COLLECTION_TYPES).anyMatch(type -> type.isInstance(value));
    }

    public boolean isExpectedAnEnum() {
        return this.expected.getClass().isEnum();
    }

    public boolean isActualAnEnum() {
        return this.actual != null && this.actual.getClass().isEnum();
    }

    public boolean hasNoContainerValues() {
        return !DualValue.isContainer(this.actual) && !DualValue.isContainer(this.expected);
    }

    public boolean hasNoNullValues() {
        return this.actual != null && this.expected != null;
    }

    private static boolean isContainer(Object o) {
        return o instanceof Iterable || o instanceof Map || o instanceof Optional || Arrays.isArray(o);
    }

    public boolean hasPotentialCyclingValues() {
        return DualValue.isPotentialCyclingValue(this.actual) && DualValue.isPotentialCyclingValue(this.expected);
    }

    private static boolean isPotentialCyclingValue(Object object) {
        if (object == null) {
            return false;
        }
        String canonicalName = object.getClass().getCanonicalName();
        if (canonicalName == null) {
            return true;
        }
        return !canonicalName.startsWith("java.lang");
    }
}

