/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.api.Descriptable;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.VisibleForTesting;

public class Condition<T>
implements Descriptable<Condition<T>> {
    @VisibleForTesting
    Description description;
    private Predicate<T> predicate;

    public Condition() {
        this.as(this.getClass().getSimpleName(), new Object[0]);
    }

    public Condition(String description) {
        this.as(description, new Object[0]);
    }

    public Condition(Predicate<T> predicate, String description, Object ... args) {
        this.checkPredicate(predicate);
        this.predicate = predicate;
        this.description = new TextDescription(description, args);
    }

    public Condition(Description description) {
        this.as(description);
    }

    @Override
    public Condition<T> describedAs(Description newDescription) {
        this.description = Description.emptyIfNull(newDescription);
        return this;
    }

    public Description description() {
        return this.description;
    }

    public boolean matches(T value) {
        this.checkPredicate(this.predicate);
        return this.predicate.test(value);
    }

    private void checkPredicate(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "Unless you subclass Condition and override matches, you need to pass a non null Predicate to build a Condition.");
    }

    public String toString() {
        return this.description().value();
    }
}

