/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.util.Lists;

class IterableDiff {
    private final ComparisonStrategy comparisonStrategy;
    List<Object> unexpected;
    List<Object> missing;

    <T> IterableDiff(Iterable<T> actual, Iterable<T> expected, ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
        this.unexpected = this.subtract(actual, expected);
        this.missing = this.subtract(expected, actual);
    }

    static <T> IterableDiff diff(Iterable<T> actual, Iterable<T> expected, ComparisonStrategy comparisonStrategy) {
        return new IterableDiff(actual, expected, comparisonStrategy);
    }

    boolean differencesFound() {
        return !this.unexpected.isEmpty() || !this.missing.isEmpty();
    }

    private <T> List<Object> subtract(Iterable<T> first, Iterable<T> second) {
        ArrayList<T> missingInFirst = new ArrayList<T>();
        ArrayList<T> copyOfSecond = Lists.newArrayList(second);
        for (T elementInFirst : first) {
            if (this.iterableContains(copyOfSecond, elementInFirst)) {
                this.iterablesRemoveFirst(copyOfSecond, elementInFirst);
                continue;
            }
            missingInFirst.add(elementInFirst);
        }
        return Collections.unmodifiableList(missingInFirst);
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterablesRemoveFirst(Iterable<?> actual, Object value) {
        this.comparisonStrategy.iterablesRemoveFirst(actual, value);
    }
}

