/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertySupport;

public class PropertyOrFieldSupport {
    private static final String SEPARATOR = ".";
    private PropertySupport propertySupport;
    private FieldSupport fieldSupport;
    public static final PropertyOrFieldSupport EXTRACTION = new PropertyOrFieldSupport();
    public static final PropertyOrFieldSupport COMPARISON = new PropertyOrFieldSupport(PropertySupport.instance(), FieldSupport.COMPARISON);

    PropertyOrFieldSupport() {
        this.propertySupport = PropertySupport.instance();
        this.fieldSupport = FieldSupport.extraction();
    }

    @VisibleForTesting
    PropertyOrFieldSupport(PropertySupport propertySupport, FieldSupport fieldSupport) {
        this.propertySupport = propertySupport;
        this.fieldSupport = fieldSupport;
    }

    public void setAllowUsingPrivateFields(boolean allowUsingPrivateFields) {
        this.fieldSupport.setAllowUsingPrivateFields(allowUsingPrivateFields);
    }

    public Object getValueOf(String propertyOrFieldName, Object input) {
        Preconditions.checkArgument(propertyOrFieldName != null, "The name of the property/field to read should not be null", new Object[0]);
        Preconditions.checkArgument(!propertyOrFieldName.isEmpty(), "The name of the property/field to read should not be empty", new Object[0]);
        Preconditions.checkArgument(input != null, "The object to extract property/field from should not be null", new Object[0]);
        if (this.isNested(propertyOrFieldName)) {
            String firstPropertyName = this.popNameFrom(propertyOrFieldName);
            Object propertyOrFieldValue = this.getSimpleValue(firstPropertyName, input);
            if (propertyOrFieldValue == null) {
                return null;
            }
            return this.getValueOf(this.nextNameFrom(propertyOrFieldName), propertyOrFieldValue);
        }
        return this.getSimpleValue(propertyOrFieldName, input);
    }

    public Object getSimpleValue(String propertyOrFieldName, Object input) {
        try {
            return this.propertySupport.propertyValueOf(propertyOrFieldName, Object.class, input);
        }
        catch (IntrospectionError propertyIntrospectionError) {
            try {
                return this.fieldSupport.fieldValue(propertyOrFieldName, Object.class, input);
            }
            catch (IntrospectionError fieldIntrospectionError) {
                String message = String.format("%nCan't find any field or property with name '%s'.%nError when introspecting properties was :%n- %s %nError when introspecting fields was :%n- %s", propertyOrFieldName, propertyIntrospectionError.getMessage(), fieldIntrospectionError.getMessage());
                throw new IntrospectionError(message, fieldIntrospectionError);
            }
        }
    }

    private String popNameFrom(String propertyOrFieldNameChain) {
        if (!this.isNested(propertyOrFieldNameChain)) {
            return propertyOrFieldNameChain;
        }
        return propertyOrFieldNameChain.substring(0, propertyOrFieldNameChain.indexOf(SEPARATOR));
    }

    private String nextNameFrom(String propertyOrFieldNameChain) {
        if (!this.isNested(propertyOrFieldNameChain)) {
            return "";
        }
        return propertyOrFieldNameChain.substring(propertyOrFieldNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNested(String propertyOrFieldName) {
        return propertyOrFieldName.contains(SEPARATOR) && !propertyOrFieldName.startsWith(SEPARATOR) && !propertyOrFieldName.endsWith(SEPARATOR);
    }
}

