/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collections;
import java.util.List;
import org.assertj.core.util.Strings;

final class DualValue {
    final List<String> path;
    final String concatenatedPath;
    final Object actual;
    final Object expected;
    private final int hashCode;

    DualValue(List<String> path, Object actual, Object expected) {
        this.path = path;
        this.concatenatedPath = Strings.join(path).with(".");
        this.actual = actual;
        this.expected = expected;
        int h1 = actual != null ? actual.hashCode() : 0;
        int h2 = expected != null ? expected.hashCode() : 0;
        this.hashCode = h1 + h2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DualValue)) {
            return false;
        }
        DualValue that = (DualValue)other;
        return this.actual == that.actual && this.expected == that.expected;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("DualValue [path=%s, actual=%s, expected=%s]", this.concatenatedPath, this.actual, this.expected);
    }

    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public String getConcatenatedPath() {
        return this.concatenatedPath;
    }

    public boolean isJavaType() {
        if (this.actual == null) {
            return false;
        }
        return this.actual.getClass().getName().startsWith("java.");
    }
}

