/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.net.URL;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Urls;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractUrlAssert<SELF extends AbstractUrlAssert<SELF>>
extends AbstractAssert<SELF, URL> {
    @VisibleForTesting
    protected Urls urls = Urls.instance();

    public AbstractUrlAssert(URL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF hasProtocol(String expected) {
        this.urls.assertHasProtocol(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasPath(String expected) {
        this.urls.assertHasPath(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoPath() {
        this.urls.assertHasPath(this.info, (URL)this.actual, "");
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasPort(int expected) {
        this.urls.assertHasPort(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoPort() {
        this.urls.assertHasPort(this.info, (URL)this.actual, -1);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasHost(String expected) {
        this.urls.assertHasHost(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasAuthority(String expected) {
        this.urls.assertHasAuthority(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasQuery(String expected) {
        this.urls.assertHasQuery(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoQuery() {
        this.urls.assertHasQuery(this.info, (URL)this.actual, null);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasAnchor(String expected) {
        this.urls.assertHasAnchor(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoAnchor() {
        this.urls.assertHasAnchor(this.info, (URL)this.actual, null);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasUserInfo(String expected) {
        this.urls.assertHasUserInfo(this.info, (URL)this.actual, expected);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoUserInfo() {
        this.urls.assertHasUserInfo(this.info, (URL)this.actual, null);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasParameter(String name) {
        this.urls.assertHasParameter(this.info, (URL)this.actual, name);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasParameter(String name, String value) {
        this.urls.assertHasParameter(this.info, (URL)this.actual, name, value);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoParameters() {
        this.urls.assertHasNoParameters(this.info, (URL)this.actual);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoParameter(String name) {
        this.urls.assertHasNoParameter(this.info, (URL)this.actual, name);
        return (SELF)((AbstractUrlAssert)this.myself);
    }

    public SELF hasNoParameter(String name, String value) {
        this.urls.assertHasNoParameter(this.info, (URL)this.actual, name, value);
        return (SELF)((AbstractUrlAssert)this.myself);
    }
}

