/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainKeys;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainKey;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Maps {
    private static final Maps INSTANCE = new Maps();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Maps instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Maps() {
    }

    public void assertNullOrEmpty(AssertionInfo info, Map<?, ?> actual) {
        if (actual == null || actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
    }

    public void assertEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertNotEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
    }

    public void assertHasSize(AssertionInfo info, Map<?, ?> actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, actual.size(), expectedSize, info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map, Iterable<?> other) {
        this.assertNotNull(info, map);
        CommonValidations.hasSameSizeAsCheck(info, map, other, map.size());
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map, Object other) {
        this.assertNotNull(info, map);
        Arrays.assertIsArray(info, other);
        CommonValidations.hasSameSizeAsCheck(info, map, other, map.size());
    }

    public void assertContains(AssertionInfo info, Map<?, ?> actual, MapEntry[] entries) {
        Maps.isNotNull(entries);
        this.assertNotNull(info, actual);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        Maps.failIfEmptySinceActualIsNotEmpty(entries);
        LinkedHashSet<MapEntry> notFound = new LinkedHashSet<MapEntry>();
        for (MapEntry entry : entries) {
            if (this.containsEntry(actual, entry)) continue;
            notFound.add(entry);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContain.shouldContain(actual, entries, notFound));
    }

    public void assertDoesNotContain(AssertionInfo info, Map<?, ?> actual, MapEntry[] entries) {
        Maps.isNotNullOrEmpty(entries);
        this.assertNotNull(info, actual);
        LinkedHashSet<MapEntry> found = new LinkedHashSet<MapEntry>();
        for (MapEntry entry : entries) {
            if (!this.containsEntry(actual, entry)) continue;
            found.add(entry);
        }
        if (found.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, entries, found));
    }

    public <K, V> void assertContainsKeys(AssertionInfo info, Map<K, V> actual, K ... keys) {
        this.assertNotNull(info, actual);
        LinkedHashSet<K> notFound = new LinkedHashSet<K>();
        for (K key : keys) {
            if (actual.containsKey(key)) continue;
            notFound.add(key);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContainKeys.shouldContainKeys(actual, notFound));
    }

    public <K, V> void assertDoesNotContainKey(AssertionInfo info, Map<K, V> actual, K key) {
        this.assertNotNull(info, actual);
        if (!actual.containsKey(key)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainKey.shouldNotContainKey(actual, key));
    }

    public <K, V> void assertContainsValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (actual.containsValue(value)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainValue.shouldContainValue(actual, value));
    }

    public <K, V> void assertDoesNotContainValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (!actual.containsValue(value)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainValue.shouldNotContainValue(actual, value));
    }

    public <K, V> void assertContainsOnly(AssertionInfo info, Map<K, V> actual, MapEntry ... entries) {
        this.doCommonContainsCheck(info, actual, entries);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        Maps.isNotEmpty(entries);
        LinkedHashSet<MapEntry> notFound = new LinkedHashSet<MapEntry>();
        LinkedHashSet<MapEntry> notExpected = new LinkedHashSet<MapEntry>();
        this.compareActualMapAndExpectedEntries(actual, entries, notExpected, notFound);
        if (notFound.isEmpty() && notExpected.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, entries, notFound, notExpected));
    }

    public <K, V> void assertContainsExactly(AssertionInfo info, Map<K, V> actual, MapEntry ... entries) {
        this.doCommonContainsCheck(info, actual, entries);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        Maps.isNotEmpty(entries);
        this.assertHasSameSizeAs(info, actual, entries);
        LinkedHashSet<MapEntry> notFound = new LinkedHashSet<MapEntry>();
        LinkedHashSet<MapEntry> notExpected = new LinkedHashSet<MapEntry>();
        this.compareActualMapAndExpectedEntries(actual, entries, notExpected, notFound);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int index = 0;
            for (K keyFromActual : actual.keySet()) {
                if (!org.assertj.core.util.Objects.areEqual(keyFromActual, entries[index].key)) {
                    MapEntry actualEntry = MapEntry.entry(keyFromActual, actual.get(keyFromActual));
                    throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actualEntry, entries[index], index));
                }
                ++index;
            }
            return;
        }
        throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, (Object)entries, notFound, notExpected));
    }

    private <K, V> void compareActualMapAndExpectedEntries(Map<K, V> actual, MapEntry[] entries, Set<MapEntry> notExpected, Set<MapEntry> notFound) {
        Map<K, V> expectedEntries = Maps.entriesToMap(entries);
        LinkedHashMap<K, V> actualEntries = new LinkedHashMap<K, V>(actual);
        for (Map.Entry<K, V> entry : expectedEntries.entrySet()) {
            if (this.containsEntry(actualEntries, MapEntry.entry(entry.getKey(), entry.getValue()))) {
                actualEntries.remove(entry.getKey());
                continue;
            }
            notFound.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<K, V> entry : actualEntries.entrySet()) {
            notExpected.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
    }

    private <K, V> void doCommonContainsCheck(AssertionInfo info, Map<K, V> actual, MapEntry[] entries) {
        this.assertNotNull(info, actual);
        Maps.isNotNull(entries);
    }

    private static <K, V> Map<K, V> entriesToMap(MapEntry[] entries) {
        LinkedHashMap<Object, Object> expectedEntries = new LinkedHashMap<Object, Object>();
        for (MapEntry entry : entries) {
            expectedEntries.put(entry.key, entry.value);
        }
        return expectedEntries;
    }

    private static void isNotEmpty(MapEntry[] entries) {
        if (entries.length == 0) {
            throw new IllegalArgumentException("The array of entries to look for should not be empty");
        }
    }

    private static void isNotNullOrEmpty(MapEntry[] entries) {
        Maps.isNotNull(entries);
        Maps.isNotEmpty(entries);
    }

    private static void isNotNull(MapEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("The array of entries to look for should not be null");
        }
    }

    private boolean containsEntry(Map<?, ?> actual, MapEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entries to look for should not be null");
        }
        if (!actual.containsKey(entry.key)) {
            return false;
        }
        return org.assertj.core.util.Objects.areEqual(actual.get(entry.key), entry.value);
    }

    private void assertNotNull(AssertionInfo info, Map<?, ?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static void failIfEmptySinceActualIsNotEmpty(MapEntry[] values) {
        if (values.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }
}

